/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.collections;

import com.paterva.maltego.util.collections.CompoundIterator;
import java.util.Collection;
import java.util.Iterator;

public class CompoundReadonlyCollection<T>
implements Collection<T> {
    private Collection<T>[] _collections;

    public CompoundReadonlyCollection(Collection<T> ... collectionArray) {
        this._collections = collectionArray;
    }

    @Override
    public int size() {
        int n = 0;
        for (Collection<T> collection : this._collections) {
            n += collection.size();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<T> collection : this._collections) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        for (Collection<T> collection : this._collections) {
            Object[] objectArray2 = collection.toArray();
            CompoundReadonlyCollection.copy(objectArray2, objectArray, n);
            n += objectArray2.length;
        }
        return objectArray;
    }

    private static <T> void copy(T[] TArray, T[] TArray2, int n) {
        System.arraycopy(TArray, 0, TArray2, n, TArray.length);
    }

    @Override
    public <A> A[] toArray(A[] AArray) {
        int n = 0;
        for (Collection<T> collection : this._collections) {
            Object[] objectArray = collection.toArray();
            CompoundReadonlyCollection.copy(objectArray, AArray, n);
            n += objectArray.length;
        }
        return AArray;
    }

    @Override
    public void clear() {
    }

    @Override
    public Iterator<T> iterator() {
        return new CompoundIterator<T>(this._collections);
    }

    @Override
    public boolean add(T t) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        for (Collection<T> collection : this._collections) {
            if (!collection.contains(object)) continue;
            return true;
        }
        return false;
    }
}

