/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

public class Version
implements Comparable<Version> {
    public static final String PROP_OEM = "maltego.oem";
    public static final String PROP_VERSION = "maltego.version";
    public static final String PROP_FULL_VERSION = "maltego.fullversion";
    public static final String PROP_BUILD_NUMBER = "maltego.buildnumber";
    public static final String PROP_VERSION_SUBTITLE = "maltego.version-subtitle";
    public static final String PROP_DISPLAY_VERSION = "maltego.displayversion";
    private int _release = 0;
    private int _major = 0;
    private int _minor = 0;
    private int _build = 0;

    private Version(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 0) {
            this._release = this.parseInt(stringArray[0]);
        }
        if (stringArray.length > 1) {
            this._major = this.parseInt(stringArray[1]);
        }
        if (stringArray.length > 2) {
            this._minor = this.parseInt(stringArray[2]);
        }
        if (stringArray.length > 3) {
            this._build = this.parseInt(stringArray[3]);
        }
    }

    public static Version parse(String string) {
        return new Version(string);
    }

    public static Version current() {
        return Version.parse(System.getProperty(PROP_FULL_VERSION));
    }

    public int release() {
        return this._release;
    }

    public int major() {
        return this._major;
    }

    public int minor() {
        return this._minor;
    }

    public int build() {
        return this._build;
    }

    public String toString() {
        return String.format("%d.%d.%d.%d", this._release, this._major, this._minor, this._build);
    }

    public boolean equals(Object object) {
        if (object instanceof Version) {
            Version version = (Version)object;
            return version.release() == this.release() && version.major() == this.major() && version.minor() == this.minor() && version.build() == this.build();
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 37 * n + this._release;
        n = 37 * n + this._major;
        n = 37 * n + this._minor;
        n = 37 * n + this._build;
        return n;
    }

    @Override
    public int compareTo(Version version) {
        if (version.release() != this.release()) {
            return this.compareInts(this.release(), version.release());
        }
        if (version.major() != this.major()) {
            return this.compareInts(this.major(), version.major());
        }
        if (version.minor() != this.minor()) {
            return this.compareInts(this.minor(), version.minor());
        }
        return this.compareInts(this.build(), version.build());
    }

    private int compareInts(int n, int n2) {
        return Integer.valueOf(n).compareTo(n2);
    }

    private int parseInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

