/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;

public class StringUtilities {
    private static String _newline = System.getProperty("line.separator");

    private StringUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append(StringUtilities.newLine());
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringBuffer.toString();
    }

    public static String capitalize(String string) {
        if (StringUtilities.isNullOrEmpty(string)) {
            return string;
        }
        String string2 = string.substring(0, 1);
        return string2.toUpperCase() + string.substring(1);
    }

    public static boolean isNullString(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).length() == 0;
        }
        return false;
    }

    public static String toCommaList(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            for (String string : stringArray) {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public static String[] fromCommaList(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public static String newLine() {
        return _newline;
    }

    public static boolean areEqual(String string, String string2) {
        if (string != null) {
            return string.equals(string2);
        }
        return string2 == null;
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return false;
        }
        return string.length() == 0;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String createUniqueString(Collection<String> collection, String string) {
        int n = 1;
        String string2 = string;
        while (collection.contains(string2)) {
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    public static String createRedPostfixHtmlString(String string, String string2) {
        return "<html><body>" + string + " <font color=\"#FF0000\">" + string2 + "</font></body></html>";
    }
}

