/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.XmlSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

public abstract class IconResourceProvider {
    public static IconResourceProvider getDefault() {
        IconResourceProvider iconResourceProvider = (IconResourceProvider)Lookup.getDefault().lookup(IconResourceProvider.class);
        if (iconResourceProvider == null) {
            iconResourceProvider = new Default();
        }
        return iconResourceProvider;
    }

    public abstract String[] getCategories();

    public abstract String[] getResources(String var1);

    public abstract String[] getResourceNames(String var1);

    public abstract String getCategory(String var1);

    public String[] getAllResourceNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getCategories()) {
            for (String string2 : this.getResourceNames(string)) {
                hashSet.add(string2);
            }
        }
        Object[] objectArray = hashSet.toArray(new String[hashSet.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String[] getAllResources() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getCategories()) {
            for (String string2 : this.getResources(string)) {
                hashSet.add(string2);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public abstract String getFullName(String var1);

    public abstract String getShortName(String var1);

    @Root(name="Icon")
    private static class IconStub {
        @Attribute(name="name", required=true)
        private String _name;
        @Attribute(name="path", required=true)
        private String _path;

        private IconStub() {
        }

        public String getName() {
            return this._name;
        }

        public String getPath() {
            return this._path;
        }
    }

    @Root(name="Icons")
    private static class IconsStub {
        @Attribute(name="basedir", required=false)
        private String _baseDir;
        @ElementList(name="Icons", type=IconStub.class, required=true, inline=true)
        private List<IconStub> _icons;

        private IconsStub() {
        }

        public List<IconStub> icons() {
            if (this._icons == null) {
                this._icons = new ArrayList<IconStub>();
            }
            return this._icons;
        }

        public String getBaseDir() {
            return this._baseDir;
        }

        public String getAbsolutePath(String string) {
            String string2;
            if (this._baseDir != null && (string2 = this._baseDir.trim()).length() > 0) {
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                return string2 + "/" + string;
            }
            return string;
        }
    }

    public static class Default
    extends IconResourceProvider {
        private Map<String, String> _short;
        private Map<String, String> _long;
        private Map<String, String[]> _categories;

        private Map<String, String> shortNames() {
            this.init();
            return this._short;
        }

        private Map<String, String> longNames() {
            this.init();
            return this._long;
        }

        private Map<String, String[]> categories() {
            this.init();
            return this._categories;
        }

        private synchronized void init() {
            if (this._short == null) {
                FileObject fileObject;
                this._short = new TreeMap<String, String>();
                this._long = new TreeMap<String, String>();
                this._categories = new TreeMap<String, String[]>();
                FileObject fileObject2 = FileUtil.getConfigRoot();
                FileObject fileObject3 = fileObject2.getFileObject("Maltego");
                if (fileObject3 != null && (fileObject = fileObject3.getFileObject("IconBrowser")) != null) {
                    for (FileObject fileObject4 : fileObject.getChildren()) {
                        Enumeration enumeration = fileObject4.getData(false);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while (enumeration.hasMoreElements()) {
                            arrayList.addAll(this.loadFile((FileObject)enumeration.nextElement(), this._long, this._short));
                        }
                        this._categories.put(fileObject4.getName(), arrayList.toArray(new String[arrayList.size()]));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<String> loadFile(FileObject fileObject, Map<String, String> map, Map<String, String> map2) {
            InputStream inputStream = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                XmlSerializer xmlSerializer = new XmlSerializer();
                inputStream = fileObject.getInputStream();
                IconsStub iconsStub = xmlSerializer.read(IconsStub.class, inputStream);
                for (IconStub iconStub : iconsStub.icons()) {
                    String string = iconStub.getName();
                    String string2 = iconsStub.getAbsolutePath(iconStub.getPath());
                    arrayList.add(string);
                    map.put(string2, string);
                    map2.put(string, string2);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return arrayList;
        }

        @Override
        public String getFullName(String string) {
            if (string == null) {
                return null;
            }
            return this.shortNames().get(string);
        }

        @Override
        public String getShortName(String string) {
            if (string == null) {
                return null;
            }
            return this.longNames().get(string);
        }

        @Override
        public String[] getCategories() {
            Set<String> set = this.categories().keySet();
            return set.toArray(new String[set.size()]);
        }

        @Override
        public String[] getResources(String string) {
            String[] stringArray = this.getResourceNames(string);
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = this.getFullName(stringArray[i]);
            }
            return stringArray2;
        }

        @Override
        public String[] getResourceNames(String string) {
            return this.categories().get(string);
        }

        @Override
        public String getCategory(String string) {
            for (Map.Entry<String, String[]> entry : this._categories.entrySet()) {
                for (String string2 : entry.getValue()) {
                    if (!this.getFullName(string2).equals(string)) continue;
                    return entry.getKey();
                }
            }
            return null;
        }
    }
}

