/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileExtensionFileFilter
extends FileFilter {
    private String _description;
    private String[] _extensions;
    private String _title;

    public FileExtensionFileFilter() {
        this(null);
    }

    public FileExtensionFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public FileExtensionFileFilter(String string, String string2) {
        this(new String[]{string}, string2);
    }

    public FileExtensionFileFilter(String[] stringArray, String string) {
        this._title = string;
        this.setExtensions(stringArray);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.getExtensions() == null) {
            return true;
        }
        String string = file.getName();
        for (String string2 : this.getExtensions()) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public String getTitle() {
        if (this._title == null) {
            return "Supported files";
        }
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
        this.setExtensions(this._extensions);
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String[] getExtensions() {
        return this._extensions;
    }

    public void setExtensions(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTitle());
        stringBuffer.append(" (");
        this._extensions = stringArray;
        if (stringArray != null) {
            this._extensions = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!string.startsWith(".")) {
                    string = "." + string;
                }
                this._extensions[i] = string;
                stringBuffer.append("*");
                stringBuffer.append(string);
                stringBuffer.append(",");
            }
        }
        this._description = stringBuffer.substring(0, stringBuffer.length() - 1) + ")";
    }
}

