/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph;

import com.paterva.maltego.graph.GraphWrapper;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;

class DirtyTrackingGraphWrapper
extends GraphWrapper {
    public static String PROP_DIRTY = "dirty";
    private boolean _dirty = false;

    protected DirtyTrackingGraphWrapper(D d) {
        super(d);
    }

    @Override
    protected void onEdgeCreated(H h) {
        super.onEdgeCreated(h);
        this.markDirty();
    }

    @Override
    protected void onEdgeChanged(H h) {
        super.onEdgeChanged(h);
        this.markDirty();
    }

    @Override
    protected void onNodeCreated(Y y) {
        super.onNodeCreated(y);
        this.markDirty();
    }

    @Override
    protected void onNodeChanged(Y y) {
        super.onNodeChanged(y);
        this.markDirty();
    }

    @Override
    protected void onEdgeRemoved(H h) {
        super.onEdgeRemoved(h);
        this.markDirty();
    }

    @Override
    protected void onNodeRemoved(Y y) {
        super.onNodeRemoved(y);
        this.markDirty();
    }

    @Override
    protected void onSubGraphInserted() {
        super.onSubGraphInserted();
        this.markDirty();
    }

    @Override
    protected void onSubGraphRemoved() {
        super.onSubGraphRemoved();
        this.markDirty();
    }

    public void markClean() {
        if (this._dirty) {
            this._dirty = false;
            this.firePropertyChange(PROP_DIRTY, true, false);
        }
    }

    public void markDirty() {
        if (!this._dirty) {
            this._dirty = true;
            this.firePropertyChange(PROP_DIRTY, false, true);
        }
    }

    public boolean isDirty() {
        return this._dirty;
    }
}

