/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.HashMap;

public class DataSources {
    private static DataSource EMPTY;

    private DataSources() {
    }

    public static DataSource empty() {
        if (EMPTY == null) {
            EMPTY = new DataSource(){

                @Override
                public Object getValue(PropertyDescriptor propertyDescriptor) {
                    return null;
                }

                @Override
                public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
                }
            };
        }
        return EMPTY;
    }

    public static DataSource proxy(DataSource ... dataSourceArray) {
        return new Proxy(dataSourceArray);
    }

    public static DataSource readOnlyProxy(DataSource ... dataSourceArray) {
        return new ReadOnlyProxy(dataSourceArray);
    }

    public static DataSource singleton(String string, Object object) {
        return new Singleton(string, object);
    }

    public static class Map
    extends HashMap<PropertyDescriptor, Object>
    implements DataSource {
        @Override
        public Object getValue(PropertyDescriptor propertyDescriptor) {
            return this.get(propertyDescriptor);
        }

        @Override
        public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
            this.put(propertyDescriptor, object);
        }
    }

    public static class ReadOnlyProxy
    implements DataSource {
        private DataSource[] _delegates;

        public ReadOnlyProxy(DataSource ... dataSourceArray) {
            this._delegates = dataSourceArray;
        }

        @Override
        public Object getValue(PropertyDescriptor propertyDescriptor) {
            for (DataSource dataSource : this._delegates) {
                Object object = dataSource.getValue(propertyDescriptor);
                if (object == null) continue;
                return object;
            }
            return null;
        }

        @Override
        public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
            throw new UnsupportedOperationException("This data source is read only");
        }
    }

    public static class Proxy
    implements DataSource {
        private DataSource[] _delegates;

        public Proxy(DataSource ... dataSourceArray) {
            this._delegates = dataSourceArray;
        }

        @Override
        public Object getValue(PropertyDescriptor propertyDescriptor) {
            for (DataSource dataSource : this._delegates) {
                Object object = dataSource.getValue(propertyDescriptor);
                if (object == null) continue;
                return object;
            }
            return null;
        }

        @Override
        public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
            if (this._delegates.length > 0) {
                this._delegates[0].setValue(propertyDescriptor, object);
            }
        }
    }

    private static class Singleton
    implements DataSource {
        private String _key;
        private Object _value;

        private Singleton(String string, Object object) {
            this._key = string;
            this._value = object;
        }

        @Override
        public Object getValue(PropertyDescriptor propertyDescriptor) {
            if (propertyDescriptor.getName().equals(this._key)) {
                return this._value;
            }
            return null;
        }

        @Override
        public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
        }
    }
}

