
<html>
<head>
<title>Bluetooth Device Tracking Demo - BlackHat 2004</title>

<style>
    a
    {
        text-decoration: none;
    }

    a:hover
    {
        color: #444444;
        text-decoration: none;
    }

    td
    {
        font-family: verdana,arial,helvetica;
        font-size: 8pt;
        color: #000000;
    }

    text
    {
        font-family: verdana,arial,helvetica;
        font-size: 8pt;
        color: #777777;
    }

   .font           { font-family: verdana,arial,helvetica; font-size: 8pt; }
   .navlink        { font-size: smaller; color: #000000; }
   .smallnospace   { font-size: smaller; }

   .email
    {
        font-family: verdana,arial,helvetica; font-size: 8pt; 
        color: #669999;
        text-decoration: none;
    }

    .big_links
    {
        font-family: verdana,arial,helvetica; font-size: 8pt;
        color: #669999;
        font-weight: bold;
        text-decoration: none;
    }

    .small_links
    {
        font-family: verdana,arial,helvetica; font-size: 8pt;
        color: #777777;
        text-decoration: none;
    }

</style>
</head>

<body bgcolor="#ffffff">

<?php 

$locations = array();
$sensors = array();

function draw_device( $name, $mac, $loc, $xpos, $ypos, $ymax )
{
    global $sensors;
    global $locations;

    $convert = 'convert';
    $loc = strtolower($loc);

    if ( $sensors[$mac] )
    {
        unset( $sensors[$mac] );
        $convert .= ' -fill red';
    }
    
    else
    {
        $convert .= ' -fill blue';
    } 

    # determine x,y and reset y.

    if ( $locations[$loc] == 0 )
    {
	# first item in this section, account for font height.
        $locations[$loc] = ( $ypos + 10 );
    }

    $y = $locations[$loc];
    $locations[$loc] = ( $y + 10 );

    if ( $y <= $ymax )
    {
        $convert .= ' -draw "text ';
        $convert .= "$xpos,$y '";
        $convert .= "$name($mac)'";
        $convert .= '" images/map-temp.jpg images/map-current.jpg';
        exec( $convert );
        exec( 'cp images/map-current.jpg images/map-temp.jpg');
    }
}

    # show current map (last minute).

    $db = mysql_connect('localhost', 'root');

    if ( !$db )
    {
        echo 'database down, come back later.\n';
        exit;
    }

    mysql_select_db('BT_TRACKER',$db);
    exec( 'cp images/map.jpg images/map-current.jpg' );
    exec( 'cp images/map.jpg images/map-temp.jpg' );
    $count = 0;

    $sql = "SELECT DISTINCT SENSOR,LOC FROM BT WHERE ";
    $sql .= "( UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(MOMENT) <= 60 ) ";
   
    $s_result = mysql_query( $sql, $db );
    $num_sensors = mysql_num_rows( $s_result );

    if ( $num_sensors > 0 ) 
    {
        while( $myrow = mysql_fetch_row( $s_result ) )
        {
            $sensors[$myrow[0]] = $myrow[1];
            $blah = $sensors[$myrow[0]];
        }

        mysql_free_result( $s_result );
    }

    $sql = "SELECT DISTINCT(d.MAC), d.NAME,d.LOC,MAX(d.MOMENT),d.SENSOR,";
    $sql .= "l.LOC,l.X0,l.Y0,l.XMAX,l.YMAX ";
    $sql .= " FROM BT AS d, MAP AS l";
    $sql .= " WHERE (d.LOC LIKE l.LOC) AND ";
    $sql .= "( UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(d.MOMENT) <= 60 ) ";
    $sql .= " GROUP BY d.MAC ORDER BY d.MOMENT DESC, d.LOC DESC";

    $result = mysql_query( $sql, $db );
    $num_rows = mysql_num_rows( $result );

    if ( $num_rows > 0 )
    {
        while( $myrow = mysql_fetch_row( $result ) )
        {
            if ( $count == 0 )
            {
                print "<font size='-1' face='arial,helvetica'>";
                print "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                print "Devices seen in the last 60 seconds";
                print "  (last known contact: $myrow[3])<br></font>";
                $count = $count + 1;
            }

            if( $myrow[0] == "" )
            {
                continue;
            }

            draw_device( $myrow[1],$myrow[0], $myrow[5],
                         $myrow[6], $myrow[7], $myrow[9] );
        }

        mysql_free_result( $result );
    }

    # now, if we have any undetected sensors left, we draw them.

    foreach ( $sensors as $i => $value )
    {
        # lookup the X location for this sensor, there is a better way
        # to do this, but i'm lazy.

        $sql = "SELECT X0,Y0,YMAX FROM MAP WHERE LOC LIKE '$value'";
       
        $result = mysql_query( $sql, $db );
        $num_rows = mysql_num_rows( $result ); 

        if ( $num_rows > 0 )
        {
            $myrow = mysql_fetch_row( $result );
            draw_device( "sensor", $i, $value, $myrow[0], $myrow[1], $myrow[2]);
        }
    }

    print "<img alt='the universe' src='images/map-current.jpg'>";

$sub_device = mysql_escape_string( $_POST['device'] );
$sub_mac = mysql_escape_string( $_POST['mac'] );

print "<br><br>";

print "<form method='POST' name='search'>";
print "<table bgcolor='#bbbbbb' border='0'>";
print "<font face='arial,helveticau'>";
print "<tr><td>Device Name:</td><td colspan='2'>";
print "<input type='text' name='device' ";
print "value='$sub_device'>";
print "</td></tr>";

print "<tr><td>MAC Address:</td><td colspan='2'><input type='text' name='mac' ";
print "value='$sub_mac'></td></tr>";

print "<tr><td>Location:</td><td colspan='2'>";
print "<input type='text' name='location'><td></tr>";

print "<tr><td>Date Restrict:</td><td>";
print "<select name='date_type'>";
print "<option name='on' selected>on</option>";
print "<option name='before'>before</option>";
print "<option name='after'>after</option></select></td>";
print "<td><input type='text' name='date'>(YYYY-MM-DD)</td></tr>";

print "<tr><td>Time Restrict:</td><td>";
print "<select name='time_type'>";
print "<option name='on' selected>on</option>";
print "<option name='before'>before</option>";
print "<option name='after'>after</option></select></td>";
print "<td><input type='text' name='time'>(HH:MM:SS)</td></tr>";

print "<tr><td>&nbsp;</td></tr>";
print "<tr><td><input type='submit' name='submit' value='Search'></td></tr>";

print "</font>";
print "</table></form>";

if ( $_POST )
{
    $name = mysql_escape_string( $_POST['device'] );
    $mac  = mysql_escape_string( $_POST['mac'] );

    if ( $name == "" and $mac == "" )
    {
        print '</body></html>';
        exit;
    }

    $sql = "SELECT * FROM BT WHERE ";

    if( $name != "" )
    {
        $sql .= "NAME LIKE '$name%'";
    }

    if( $mac != "" )
    {
        if ( $name != "" ) { $sql .= " AND "; }

        $sql .= "MAC LIKE '$mac%'";
    }

    $sql .= " ORDER BY BT.MOMENT";

    $result = mysql_query( $sql, $db );
    $num_rows = mysql_num_rows( $result );

    print "<font face='arial,helvetica' size='-1'>";
    print "Search returned ($num_rows) results.";
    print "<font><br><br>";

    if ( $num_rows <= 0 )
    {
        print "</body></html>";
        exit;
    }

    # print results table heading.

    print "<table width='500' border='0' bgcolor='bbbbbb' cellspacing='2'>";
    print "<tr bgcolor='bbbbbb'><td><b>Device</b></td><td><b>MAC</b></td>";
    print "<td><b>Location</b></td><td><b>Time</b></td>";
    print "<td><b>Detected By</b></td></tr>";

    # print results table.

    $row = 0;

    while( $myrow = mysql_fetch_row( $result ) )
    {
        print "<tr class='small_links'";

        if ( $row % 2 == 0 )
            print " bgcolor='ffffff'>";
        else
            print " bgcolor='dddddd'>";
        print "<td>$myrow[2]</td><td>$myrow[1]</td>";
        print "<td>$myrow[4]</td><td>$myrow[3]</td>";
        print "<td>$myrow[5]</td></tr>";
        $row = ( $row + 1 );
    }

    # print table footer. 

    print "</table>";
    print "<br><br>";

    mysql_free_result( $result );
    mysql_close( $db );
}

?>

</body>
</html>
