/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.BluetoothStackExtension;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.NotSupportedIOException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.RetrieveDevicesCallback;
import com.intel.bluetooth.SDPInputStream;
import com.intel.bluetooth.SearchServicesDeviceNotReachableException;
import com.intel.bluetooth.SearchServicesException;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesTerminatedException;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackOSX
implements BluetoothStack,
BluetoothStackExtension {
    public static final boolean debug = false;
    private static BluetoothStackOSX singleInstance = null;
    private static final int ATTR_RETRIEVABLE_MAX = 256;
    private final Vector deviceDiscoveryListeners = new Vector();
    private final Hashtable deviceDiscoveryListenerReportedDevices = new Hashtable();
    private int receive_mtu_max = -1;
    private int localDeviceSupportedSoftwareVersion;
    private long lastDeviceDiscoveryTime = 0L;
    private int localDeviceServiceClasses = 0;
    private Thread localDeviceServiceClassMaintainer = null;
    private static final int BLUETOOTH_SOFTWARE_VERSION_2_0_0 = 20000;

    BluetoothStackOSX() {
    }

    public native boolean isNativeCodeLoaded();

    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        return BluetoothStack.LibraryInformation.library("bluecove");
    }

    public String getStackID() {
        return "mac";
    }

    public String toString() {
        return this.getStackID();
    }

    public int getFeatureSet() {
        if (this.localDeviceSupportedSoftwareVersion >= 20000) {
            return 7 | (this.isLocalDeviceFeatureRSSI() ? 8 : 0);
        }
        return 3;
    }

    public native int getLibraryVersion();

    public native int detectBluetoothStack();

    private native boolean initializeImpl();

    public void initialize() throws BluetoothStateException {
        if (singleInstance != null) {
            throw new BluetoothStateException("Only one instance of " + this.getStackID() + " stack supported");
        }
        String sysVersion = System.getProperty("os.version");
        String jreDataModel = System.getProperty("sun.arch.data.model");
        boolean osIsLeopard = sysVersion != null && sysVersion.startsWith("10.5");
        boolean jreIs64Bit = "64".equals(jreDataModel);
        if (osIsLeopard && jreIs64Bit) {
            throw new BluetoothStateException("Mac OS X 10.5 not supported with a 64 bit JRE");
        }
        this.localDeviceSupportedSoftwareVersion = this.getLocalDeviceSupportedSoftwareVersion();
        DebugLog.debug("localDeviceSupportedSoftwareVersion", this.localDeviceSupportedSoftwareVersion);
        if (!this.initializeImpl()) {
            throw new BluetoothStateException("OS X BluetoothStack not found");
        }
        singleInstance = this;
    }

    public void destroy() {
        if (this.localDeviceSupportedSoftwareVersion >= 20000) {
            this.setLocalDeviceServiceClassesImpl(0);
        }
        singleInstance = null;
    }

    public native void enableNativeDebug(Class var1, boolean var2);

    public boolean isCurrentThreadInterruptedCallback() {
        return UtilsJavaSE.isCurrentThreadInterrupted();
    }

    public native String getLocalDeviceBluetoothAddress() throws BluetoothStateException;

    public native String getLocalDeviceName();

    private native int getDeviceClassImpl();

    public DeviceClass getLocalDeviceClass() {
        return new DeviceClass(this.getDeviceClassImpl());
    }

    private native boolean setLocalDeviceServiceClassesImpl(int var1);

    public synchronized void setLocalDeviceServiceClasses(int classOfDevice) {
        if (this.localDeviceSupportedSoftwareVersion < 20000) {
            return;
        }
        if (classOfDevice != this.localDeviceServiceClasses) {
            this.setLocalDeviceServiceClassesImpl(classOfDevice);
        }
        this.localDeviceServiceClasses = classOfDevice;
        if (classOfDevice != 0 && this.localDeviceServiceClassMaintainer == null) {
            this.localDeviceServiceClassMaintainer = new MaintainDeviceServiceClassesThread();
            UtilsJavaSE.threadSetDaemon(this.localDeviceServiceClassMaintainer);
            this.localDeviceServiceClassMaintainer.start();
        }
    }

    public native boolean isLocalDevicePowerOn();

    private native boolean isLocalDeviceFeatureSwitchRoles();

    private native boolean isLocalDeviceFeatureParkMode();

    private native boolean isLocalDeviceFeatureRSSI();

    private native int getLocalDeviceL2CAPMTUMaximum();

    private native int getLocalDeviceSupportedSoftwareVersion();

    private native String getLocalDeviceSoftwareVersionInfo();

    private native int getLocalDeviceManufacturer();

    private native String getLocalDeviceVersion();

    public String getLocalDeviceProperty(String property) {
        if ("bluetooth.connected.devices.max".equals(property)) {
            return this.isLocalDeviceFeatureParkMode() ? "255" : "7";
        }
        if ("bluetooth.sd.trans.max".equals(property)) {
            return "7";
        }
        if ("bluetooth.connected.inquiry.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.inquiry".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page".equals(property)) {
            return "true";
        }
        if ("bluetooth.sd.attr.retrievable.max".equals(property)) {
            return String.valueOf(256);
        }
        if ("bluetooth.master.switch".equals(property)) {
            return "false";
        }
        if ("bluetooth.l2cap.receiveMTU.max".equals(property)) {
            return String.valueOf(this.receiveMTUMAX());
        }
        if ("bluecove.radio.version".equals(property)) {
            return this.getLocalDeviceVersion();
        }
        if ("bluecove.radio.manufacturer".equals(property)) {
            return String.valueOf(this.getLocalDeviceManufacturer());
        }
        if ("bluecove.stack.version".equals(property)) {
            return this.getLocalDeviceSoftwareVersionInfo();
        }
        return null;
    }

    private int receiveMTUMAX() {
        if (this.receive_mtu_max < 0) {
            this.receive_mtu_max = this.getLocalDeviceL2CAPMTUMaximum();
        }
        return this.receive_mtu_max;
    }

    private native boolean getLocalDeviceDiscoverableImpl();

    public int getLocalDeviceDiscoverable() {
        if (this.getLocalDeviceDiscoverableImpl()) {
            return 10390323;
        }
        return 0;
    }

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        return this.getLocalDeviceDiscoverable() == mode;
    }

    private void verifyDeviceReady() throws BluetoothStateException {
        if (!this.isLocalDevicePowerOn()) {
            throw new BluetoothStateException("Bluetooth Device is not ready");
        }
    }

    private native boolean retrieveDevicesImpl(int var1, RetrieveDevicesCallback var2);

    public RemoteDevice[] retrieveDevices(int option) {
        final Vector devices = new Vector();
        RetrieveDevicesCallback retrieveDevicesCallback = new RetrieveDevicesCallback(){

            public void deviceFoundCallback(long deviceAddr, int deviceClass, String deviceName, boolean paired) {
                DebugLog.debug("device found", deviceAddr);
                RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(BluetoothStackOSX.this, deviceAddr, deviceName, paired);
                if (!devices.contains(remoteDevice)) {
                    devices.add(remoteDevice);
                }
            }
        };
        if (this.retrieveDevicesImpl(option, retrieveDevicesCallback)) {
            return RemoteDeviceHelper.remoteDeviceListToArray(devices);
        }
        return null;
    }

    private native boolean isRemoteDeviceTrustedImpl(long var1);

    public Boolean isRemoteDeviceTrusted(long address) {
        return new Boolean(this.isRemoteDeviceTrustedImpl(address));
    }

    private native boolean isRemoteDeviceAuthenticatedImpl(long var1);

    public Boolean isRemoteDeviceAuthenticated(long address) {
        return new Boolean(this.isRemoteDeviceAuthenticatedImpl(address));
    }

    private native int readRemoteDeviceRSSIImpl(long var1) throws IOException;

    public int readRemoteDeviceRSSI(long address) throws IOException {
        return this.readRemoteDeviceRSSIImpl(address);
    }

    private native boolean authenticateRemoteDeviceImpl(long var1) throws IOException;

    public boolean authenticateRemoteDevice(long address) throws IOException {
        return this.authenticateRemoteDeviceImpl(address);
    }

    public boolean authenticateRemoteDevice(long address, String passkey) throws IOException {
        return false;
    }

    public void removeAuthenticationWithRemoteDevice(long address) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public native String getRemoteDeviceFriendlyName(long var1) throws IOException;

    private native int runDeviceInquiryImpl(DeviceInquiryRunnable var1, DeviceInquiryThread var2, int var3, int var4, DiscoveryListener var5) throws BluetoothStateException;

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        long acceptableInterval;
        long sinceDiscoveryLast = System.currentTimeMillis() - this.lastDeviceDiscoveryTime;
        if (sinceDiscoveryLast < (acceptableInterval = 7000L)) {
            try {
                Thread.sleep(acceptableInterval - sinceDiscoveryLast);
            }
            catch (InterruptedException e) {
                throw new BluetoothStateException();
            }
        }
        this.deviceDiscoveryListeners.addElement(listener);
        this.deviceDiscoveryListenerReportedDevices.put(listener, new Vector());
        DeviceInquiryRunnable inquiryRunnable = new DeviceInquiryRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
                try {
                    int n = BluetoothStackOSX.this.runDeviceInquiryImpl(this, startedNotify, accessCode, DeviceInquiryThread.getConfigDeviceInquiryDuration(), listener);
                    return n;
                }
                finally {
                    BluetoothStackOSX.this.lastDeviceDiscoveryTime = System.currentTimeMillis();
                    BluetoothStackOSX.this.deviceDiscoveryListeners.removeElement(listener);
                    BluetoothStackOSX.this.deviceDiscoveryListenerReportedDevices.remove(listener);
                }
            }

            public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
                if (!BluetoothStackOSX.this.deviceDiscoveryListeners.contains(listener)) {
                    return;
                }
                RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(BluetoothStackOSX.this, deviceAddr, deviceName, paired);
                Vector reported = (Vector)BluetoothStackOSX.this.deviceDiscoveryListenerReportedDevices.get(listener);
                if (reported == null || reported.contains(remoteDevice)) {
                    return;
                }
                reported.addElement(remoteDevice);
                DeviceClass cod = new DeviceClass(deviceClass);
                DebugLog.debug("deviceDiscoveredCallback address", remoteDevice.getBluetoothAddress());
                DebugLog.debug("deviceDiscoveredCallback deviceClass", cod);
                listener.deviceDiscovered(remoteDevice, cod);
            }
        };
        return DeviceInquiryThread.startInquiry(this, inquiryRunnable, accessCode, listener);
    }

    private native boolean deviceInquiryCancelImpl();

    public boolean cancelInquiry(DiscoveryListener listener) {
        if (!this.deviceDiscoveryListeners.removeElement(listener)) {
            return false;
        }
        return this.deviceInquiryCancelImpl();
    }

    private native int runSearchServicesImpl(long var1, int var3) throws BluetoothStateException, SearchServicesException;

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        SearchServicesRunnable searchRunnable = new SearchServicesRunnable(){

            public int runSearchServices(SearchServicesThread sst, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
                int recordsSize;
                sst.searchServicesStartedCallback();
                try {
                    recordsSize = BluetoothStackOSX.this.runSearchServicesImpl(RemoteDeviceHelper.getAddress(device), sst.getTransID());
                }
                catch (SearchServicesDeviceNotReachableException e) {
                    return 6;
                }
                catch (SearchServicesTerminatedException e) {
                    return 2;
                }
                catch (SearchServicesException e) {
                    return 3;
                }
                if (sst.isTerminated()) {
                    return 2;
                }
                if (recordsSize == 0) {
                    return 4;
                }
                Vector<ServiceRecordImpl> records = new Vector<ServiceRecordImpl>();
                int[] uuidFilerAttrIDs = new int[]{1, 4};
                int[] requiredAttrIDs = new int[]{0, 2, 3};
                block6: for (int i = 0; i < recordsSize; ++i) {
                    ServiceRecordImpl sr = new ServiceRecordImpl(BluetoothStackOSX.this, device, i);
                    try {
                        sr.populateRecord(uuidFilerAttrIDs);
                        for (int u = 0; u < uuidSet.length; ++u) {
                            if (!sr.hasServiceClassUUID(uuidSet[u]) && !sr.hasProtocolClassUUID(uuidSet[u])) continue block6;
                        }
                        records.addElement(sr);
                        sr.populateRecord(requiredAttrIDs);
                        if (attrSet != null) {
                            sr.populateRecord(attrSet);
                        }
                        DebugLog.debug("ServiceRecord (" + i + ")", sr);
                    }
                    catch (Exception e) {
                        DebugLog.debug("populateRecord error", e);
                    }
                    if (!sst.isTerminated()) continue;
                    DebugLog.debug("SERVICE_SEARCH_TERMINATED " + sst.getTransID());
                    return 2;
                }
                if (records.size() != 0) {
                    DebugLog.debug("SERVICE_SEARCH_COMPLETED " + sst.getTransID());
                    ServiceRecord[] fileteredRecords = (ServiceRecord[])Utils.vector2toArray(records, new ServiceRecord[records.size()]);
                    listener.servicesDiscovered(sst.getTransID(), fileteredRecords);
                    return 1;
                }
                return 4;
            }
        };
        return SearchServicesThread.startSearchServices(this, searchRunnable, attrSet, uuidSet, device, listener);
    }

    private native void cancelServiceSearchImpl(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelServiceSearch(int transID) {
        SearchServicesThread sst = SearchServicesThread.getServiceSearchThread(transID);
        if (sst != null) {
            BluetoothStackOSX bluetoothStackOSX = this;
            synchronized (bluetoothStackOSX) {
                if (!sst.isTerminated()) {
                    sst.setTerminated();
                    this.cancelServiceSearchImpl(transID);
                    return true;
                }
            }
        }
        return false;
    }

    private native byte[] getServiceAttributeImpl(long var1, long var3, int var5);

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        if (attrIDs.length > 256) {
            throw new IllegalArgumentException();
        }
        boolean anyRetrived = false;
        long address = RemoteDeviceHelper.getAddress(serviceRecord.getHostDevice());
        for (int i = 0; i < attrIDs.length; ++i) {
            int id = attrIDs[i];
            try {
                byte[] blob = this.getServiceAttributeImpl(address, serviceRecord.getHandle(), id);
                if (blob == null) continue;
                DataElement element = new SDPInputStream(new ByteArrayInputStream(blob)).readElement();
                serviceRecord.populateAttributeValue(id, element);
                anyRetrived = true;
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return anyRetrived;
    }

    private native long connectionRfOpenClientConnectionImpl(long var1, int var3, boolean var4, boolean var5, int var6) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        RemoteDevice lock;
        if (params.encrypt) {
            throw new BluetoothConnectionException(2, "encrypt mode not supported");
        }
        RemoteDevice remoteDevice = lock = RemoteDeviceHelper.createRemoteDevice(this, params.address, null, false);
        synchronized (remoteDevice) {
            return this.connectionRfOpenClientConnectionImpl(params.address, params.channel, params.authenticate, params.encrypt, params.timeout);
        }
    }

    public native void connectionRfCloseClientConnection(long var1) throws IOException;

    public native int rfGetSecurityOpt(long var1, int var3) throws IOException;

    public boolean rfEncrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    private native long rfServerCreateImpl(byte[] var1, boolean var2, String var3, boolean var4, boolean var5) throws IOException;

    private native int rfServerGetChannelID(long var1) throws IOException;

    private native void rfServerCloseImpl(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        this.verifyDeviceReady();
        if (params.encrypt) {
            throw new BluetoothConnectionException(2, "encrypt mode not supported");
        }
        byte[] uuidValue = Utils.UUIDToByteArray(params.uuid);
        long handle = this.rfServerCreateImpl(uuidValue, params.obex, params.name, params.authenticate, params.encrypt);
        boolean success = false;
        try {
            int channel = this.rfServerGetChannelID(handle);
            serviceRecord.populateRFCOMMAttributes(handle, channel, params.uuid, params.name, params.obex);
            success = true;
        }
        finally {
            if (!success) {
                this.rfServerCloseImpl(handle);
            }
        }
        return handle;
    }

    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        this.rfServerCloseImpl(handle);
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.sdpServiceUpdateServiceRecord(handle, 'R', serviceRecord);
    }

    public native long rfServerAcceptAndOpenRfServerConnection(long var1) throws IOException;

    public void connectionRfCloseServerConnection(long handle) throws IOException {
        this.connectionRfCloseClientConnection(handle);
    }

    private native void sdpServiceUpdateServiceRecordPublish(long var1, char var3) throws ServiceRegistrationException;

    private native void sdpServiceAddAttribute(long var1, char var3, int var4, int var5, long var6, byte[] var8) throws ServiceRegistrationException;

    private native void sdpServiceSequenceAttributeStart(long var1, char var3, int var4, int var5) throws ServiceRegistrationException;

    private native void sdpServiceSequenceAttributeEnd(long var1, char var3, int var4) throws ServiceRegistrationException;

    private void sdpServiceAddAttribute(long handle, char handleType, int attrID, DataElement element) throws ServiceRegistrationException {
        int type = element.getDataType();
        switch (type) {
            case 0: {
                this.sdpServiceAddAttribute(handle, handleType, attrID, type, 0L, null);
                break;
            }
            case 40: {
                this.sdpServiceAddAttribute(handle, handleType, attrID, type, element.getBoolean() ? 1L : 0L, null);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.sdpServiceAddAttribute(handle, handleType, attrID, type, element.getLong(), null);
                break;
            }
            case 11: 
            case 12: 
            case 20: {
                this.sdpServiceAddAttribute(handle, handleType, attrID, type, 0L, (byte[])element.getValue());
                break;
            }
            case 24: {
                this.sdpServiceAddAttribute(handle, handleType, attrID, type, 0L, Utils.UUIDToByteArray((UUID)element.getValue()));
                break;
            }
            case 32: {
                byte[] bs = Utils.getUTF8Bytes((String)element.getValue());
                this.sdpServiceAddAttribute(handle, handleType, attrID, type, 0L, bs);
                break;
            }
            case 64: {
                byte[] bu = Utils.getASCIIBytes((String)element.getValue());
                this.sdpServiceAddAttribute(handle, handleType, attrID, type, 0L, bu);
                break;
            }
            case 48: 
            case 56: {
                this.sdpServiceSequenceAttributeStart(handle, handleType, attrID, type);
                Enumeration e = (Enumeration)element.getValue();
                while (e.hasMoreElements()) {
                    DataElement child = (DataElement)e.nextElement();
                    this.sdpServiceAddAttribute(handle, handleType, -1, child);
                }
                this.sdpServiceSequenceAttributeEnd(handle, handleType, attrID);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void sdpServiceUpdateServiceRecord(long handle, char handleType, ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        int[] ids = serviceRecord.getAttributeIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        block4: for (int i = 0; i < ids.length; ++i) {
            int attrID = ids[i];
            switch (attrID) {
                case 0: {
                    continue block4;
                }
                case 4: 
                case 256: {
                    continue block4;
                }
                default: {
                    this.sdpServiceAddAttribute(handle, handleType, attrID, serviceRecord.getAttributeValue(attrID));
                }
            }
        }
        this.sdpServiceUpdateServiceRecordPublish(handle, handleType);
    }

    public void connectionRfFlush(long handle) throws IOException {
    }

    public native int connectionRfRead(long var1) throws IOException;

    public native int connectionRfRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native int connectionRfReadAvailable(long var1) throws IOException;

    public void connectionRfWrite(long handle, int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.connectionRfWrite(handle, buf, 0, 1);
    }

    public native void connectionRfWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native long getConnectionRfRemoteAddress(long var1) throws IOException;

    private void validateMTU(int receiveMTU, int transmitMTU) {
        if (receiveMTU > this.receiveMTUMAX()) {
            throw new IllegalArgumentException("invalid ReceiveMTU value " + receiveMTU);
        }
    }

    private native long l2OpenClientConnectionImpl(long var1, int var3, boolean var4, boolean var5, int var6, int var7, int var8) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        RemoteDevice lock;
        this.validateMTU(receiveMTU, transmitMTU);
        if (params.encrypt) {
            throw new BluetoothConnectionException(2, "encrypt mode not supported");
        }
        RemoteDevice remoteDevice = lock = RemoteDeviceHelper.createRemoteDevice(this, params.address, null, false);
        synchronized (remoteDevice) {
            return this.l2OpenClientConnectionImpl(params.address, params.channel, params.authenticate, params.encrypt, receiveMTU, transmitMTU, params.timeout);
        }
    }

    public native void l2CloseClientConnection(long var1) throws IOException;

    private native long l2ServerOpenImpl(byte[] var1, boolean var2, boolean var3, String var4, int var5, int var6, int var7) throws IOException;

    public native int l2ServerPSM(long var1) throws IOException;

    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        this.verifyDeviceReady();
        this.validateMTU(receiveMTU, transmitMTU);
        if (params.encrypt) {
            throw new BluetoothConnectionException(2, "encrypt mode not supported");
        }
        byte[] uuidValue = Utils.UUIDToByteArray(params.uuid);
        long handle = this.l2ServerOpenImpl(uuidValue, params.authenticate, params.encrypt, params.name, receiveMTU, transmitMTU, params.bluecove_ext_psm);
        int channel = this.l2ServerPSM(handle);
        int serviceRecordHandle = (int)handle;
        serviceRecord.populateL2CAPAttributes(serviceRecordHandle, channel, params.uuid, params.name);
        return handle;
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.sdpServiceUpdateServiceRecord(handle, 'L', serviceRecord);
    }

    public native long l2ServerAcceptAndOpenServerConnection(long var1) throws IOException;

    public void l2CloseServerConnection(long handle) throws IOException {
        this.l2CloseClientConnection(handle);
    }

    private native void l2ServerCloseImpl(long var1) throws IOException;

    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        this.l2ServerCloseImpl(handle);
    }

    public native int l2GetSecurityOpt(long var1, int var3) throws IOException;

    public native boolean l2Ready(long var1) throws IOException;

    public native int l2Receive(long var1, byte[] var3) throws IOException;

    public native void l2Send(long var1, byte[] var3, int var4) throws IOException;

    public native int l2GetReceiveMTU(long var1) throws IOException;

    public native int l2GetTransmitMTU(long var1) throws IOException;

    public native long l2RemoteAddress(long var1) throws IOException;

    public boolean l2Encrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    private class MaintainDeviceServiceClassesThread
    extends Thread {
        MaintainDeviceServiceClassesThread() {
            super("MaintainDeviceServiceClassesThread");
        }

        public void run() {
            boolean updated = true;
            while (true) {
                try {
                    int delay = 120000;
                    if (!updated) {
                        delay = 1000;
                    }
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (BluetoothStackOSX.this.localDeviceServiceClasses != 0) {
                    updated = BluetoothStackOSX.this.setLocalDeviceServiceClassesImpl(BluetoothStackOSX.this.localDeviceServiceClasses);
                    continue;
                }
                if (updated) continue;
                updated = true;
            }
        }
    }
}

