/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothConsts;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.NotSupportedIOException;
import com.intel.bluetooth.NotSupportedRuntimeException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackBlueSoleil
implements BluetoothStack,
DeviceInquiryRunnable,
SearchServicesRunnable {
    private static BluetoothStackBlueSoleil singleInstance = null;
    private boolean initialized = false;
    private DiscoveryListener currentDeviceDiscoveryListener;

    BluetoothStackBlueSoleil() {
    }

    public String getStackID() {
        return "bluesoleil";
    }

    public String toString() {
        return this.getStackID();
    }

    public native boolean isNativeCodeLoaded();

    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        return BluetoothStack.LibraryInformation.library("intelbth");
    }

    public native int getLibraryVersion();

    public native int detectBluetoothStack();

    public native void enableNativeDebug(Class var1, boolean var2);

    public native boolean initializeImpl();

    public void initialize() throws BluetoothStateException {
        if (singleInstance != null) {
            throw new BluetoothStateException("Only one instance of " + this.getStackID() + " stack supported");
        }
        if (!this.initializeImpl()) {
            DebugLog.fatal("Can't initialize BlueSoleil");
            throw new BluetoothStateException("BlueSoleil BluetoothStack not found");
        }
        this.initialized = true;
        singleInstance = this;
    }

    private native void uninitialize();

    public void destroy() {
        if (singleInstance != this) {
            throw new RuntimeException("Destroy invalid instance");
        }
        if (this.initialized) {
            this.uninitialize();
            this.initialized = false;
            DebugLog.debug("BlueSoleil destroyed");
        }
        singleInstance = null;
    }

    protected void finalize() {
        this.destroy();
    }

    public native String getLocalDeviceBluetoothAddress();

    public native String getLocalDeviceName();

    public native int getDeviceClassImpl();

    public DeviceClass getLocalDeviceClass() {
        return new DeviceClass(this.getDeviceClassImpl());
    }

    public void setLocalDeviceServiceClasses(int classOfDevice) {
        throw new NotSupportedRuntimeException(this.getStackID());
    }

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        return true;
    }

    native boolean isBlueSoleilStarted(int var1);

    private native boolean isBluetoothReady(int var1);

    public int getLocalDeviceDiscoverable() {
        if (this.isBluetoothReady(2)) {
            return 10390323;
        }
        return 0;
    }

    public boolean isLocalDevicePowerOn() {
        return this.isBluetoothReady(15);
    }

    native int getStackVersionInfo();

    native int getDeviceVersion();

    native int getDeviceManufacturer();

    public int getFeatureSet() {
        return 0;
    }

    public String getLocalDeviceProperty(String property) {
        if ("bluetooth.connected.devices.max".equals(property)) {
            return "7";
        }
        if ("bluetooth.sd.trans.max".equals(property)) {
            return "1";
        }
        if ("bluetooth.connected.inquiry.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.inquiry".equals(property)) {
            return "true";
        }
        if ("bluetooth.sd.attr.retrievable.max".equals(property)) {
            return "0";
        }
        if ("bluecove.stack.version".equals(property)) {
            return String.valueOf(this.getStackVersionInfo());
        }
        return null;
    }

    public boolean isCurrentThreadInterruptedCallback() {
        return UtilsJavaSE.isCurrentThreadInterrupted();
    }

    public RemoteDevice[] retrieveDevices(int option) {
        return null;
    }

    public Boolean isRemoteDeviceTrusted(long address) {
        return null;
    }

    public Boolean isRemoteDeviceAuthenticated(long address) {
        return null;
    }

    public boolean authenticateRemoteDevice(long address) throws IOException {
        return false;
    }

    public boolean authenticateRemoteDevice(long address, String passkey) throws IOException {
        return false;
    }

    public void removeAuthenticationWithRemoteDevice(long address) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        if (this.currentDeviceDiscoveryListener != null) {
            throw new BluetoothStateException("Another inquiry already running");
        }
        this.currentDeviceDiscoveryListener = listener;
        return DeviceInquiryThread.startInquiry(this, this, accessCode, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        try {
            startedNotify.deviceInquiryStartedCallback();
            int n = this.runDeviceInquiryImpl(startedNotify, accessCode, listener);
            return n;
        }
        finally {
            this.currentDeviceDiscoveryListener = null;
        }
    }

    public native int runDeviceInquiryImpl(DeviceInquiryThread var1, int var2, DiscoveryListener var3) throws BluetoothStateException;

    public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
        DebugLog.debug("deviceDiscoveredCallback", deviceName);
        RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(this, deviceAddr, deviceName, paired);
        if (this.currentDeviceDiscoveryListener == null || this.currentDeviceDiscoveryListener != listener) {
            return;
        }
        listener.deviceDiscovered(remoteDevice, new DeviceClass(deviceClass));
    }

    public native boolean cancelInquirympl();

    public boolean cancelInquiry(DiscoveryListener listener) {
        if (this.currentDeviceDiscoveryListener != listener) {
            return false;
        }
        this.currentDeviceDiscoveryListener = null;
        return this.cancelInquirympl();
    }

    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        return null;
    }

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        return SearchServicesThread.startSearchServices(this, this, attrSet, uuidSet, device, listener);
    }

    public boolean cancelServiceSearch(int transID) {
        return false;
    }

    private native int runSearchServicesImpl(SearchServicesThread var1, DiscoveryListener var2, byte[] var3, long var4, RemoteDevice var6) throws BluetoothStateException;

    public int runSearchServices(SearchServicesThread startedNotify, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        startedNotify.searchServicesStartedCallback();
        UUID uuid = null;
        if (uuidSet != null && uuidSet.length > 0) {
            uuid = uuidSet[uuidSet.length - 1];
        }
        return this.runSearchServicesImpl(startedNotify, listener, Utils.UUIDToByteArray(uuid), RemoteDeviceHelper.getAddress(device), device);
    }

    public void servicesFoundCallback(SearchServicesThread startedNotify, DiscoveryListener listener, RemoteDevice device, String serviceName, byte[] uuidValue, int channel, long recordHanlde) {
        ServiceRecordImpl record = new ServiceRecordImpl(this, device, 0L);
        UUID uuid = new UUID(Utils.UUIDByteArrayToString(uuidValue), false);
        record.populateRFCOMMAttributes(recordHanlde, channel, uuid, serviceName, BluetoothConsts.obexUUIDs.contains(uuid));
        DebugLog.debug("servicesFoundCallback", record);
        RemoteDevice listedDevice = RemoteDeviceHelper.createRemoteDevice(this, device);
        RemoteDeviceHelper.setStackAttributes(this, listedDevice, "RFCOMM_channel" + channel, uuid);
        ServiceRecord[] records = new ServiceRecordImpl[]{record};
        listener.servicesDiscovered(startedNotify.getTransID(), records);
    }

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        return false;
    }

    private native long connectionRfOpenImpl(long var1, byte[] var3) throws IOException;

    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        if (params.authenticate || params.encrypt) {
            throw new IOException("authenticate not supported on BlueSoleil");
        }
        RemoteDevice listedDevice = RemoteDeviceHelper.getCashedDevice(this, params.address);
        if (listedDevice == null) {
            throw new IOException("Device not discovered");
        }
        UUID uuid = (UUID)RemoteDeviceHelper.getStackAttributes(this, listedDevice, "RFCOMM_channel" + params.channel);
        if (uuid == null) {
            throw new IOException("Device service not discovered");
        }
        DebugLog.debug("Connect to service UUID", uuid);
        return this.connectionRfOpenImpl(params.address, Utils.UUIDToByteArray(uuid));
    }

    public native void connectionRfCloseClientConnection(long var1) throws IOException;

    private native long rfServerOpenImpl(byte[] var1, String var2, boolean var3, boolean var4) throws IOException;

    private native int rfServerSCN(long var1) throws IOException;

    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        if (params.authenticate || params.encrypt) {
            throw new IOException("authenticate not supported on BlueSoleil");
        }
        byte[] uuidValue = Utils.UUIDToByteArray(params.uuid);
        long handle = this.rfServerOpenImpl(uuidValue, params.name, params.authenticate, params.encrypt);
        int channel = this.rfServerSCN(handle);
        DebugLog.debug("serverSCN", channel);
        int serviceRecordHandle = (int)handle;
        serviceRecord.populateRFCOMMAttributes(serviceRecordHandle, channel, params.uuid, params.name, false);
        return handle;
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        if (!acceptAndOpen) {
            throw new ServiceRegistrationException("Not Supported on " + this.getStackID());
        }
    }

    public native long rfServerAcceptAndOpenRfServerConnection(long var1) throws IOException;

    public void connectionRfCloseServerConnection(long handle) throws IOException {
        this.connectionRfCloseClientConnection(handle);
    }

    public native void rfServerClose(long var1, ServiceRecordImpl var3) throws IOException;

    public native long getConnectionRfRemoteAddress(long var1) throws IOException;

    public native int connectionRfRead(long var1) throws IOException;

    public native int connectionRfRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native int connectionRfReadAvailable(long var1) throws IOException;

    public native void connectionRfWrite(long var1, int var3) throws IOException;

    public native void connectionRfWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native void connectionRfFlush(long var1) throws IOException;

    public int rfGetSecurityOpt(long handle, int expected) throws IOException {
        return 0;
    }

    public boolean rfEncrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2CloseClientConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        throw new ServiceRegistrationException("Not Supported on" + this.getStackID());
    }

    public long l2ServerAcceptAndOpenServerConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2CloseServerConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public int l2GetSecurityOpt(long handle, int expected) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public boolean l2Ready(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public int l2Receive(long handle, byte[] inBuf) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2Send(long handle, byte[] data, int transmitMTU) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public int l2GetReceiveMTU(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public int l2GetTransmitMTU(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public long l2RemoteAddress(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public boolean l2Encrypt(long address, long handle, boolean on) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }
}

