'use strict';

exports.__esModule = true;
exports.default = hashify;
exports.hashArray = hashArray;
exports.hashObject = hashObject;
/**
 * utilities for hashing config objects.
 * basically iteratively updates hash with a JSON-like format
 */

var stringify = JSON.stringify;

function hashify(hash, value) {
  if (value instanceof Array) {
    hashArray(hash, value);
  } else if (value instanceof Object) {
    hashObject(hash, value);
  } else {
    hash.update(stringify(value) || 'undefined');
  }

  return hash;
}

function hashArray(hash, array) {
  hash.update('[');
  for (var i = 0; i < array.length; i++) {
    hashify(hash, array[i]);
    hash.update(',');
  }
  hash.update(']');

  return hash;
}

function hashObject(hash, object) {
  hash.update('{');
  Object.keys(object).sort().forEach(function (key) {
    hash.update(stringify(key));
    hash.update(':');
    hashify(hash, object[key]);
    hash.update(',');
  });
  hash.update('}');

  return hash;
}
//# sourceMappingURL=data:application/json;base64,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