/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.__builtin__;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonObjectInputStream
extends ObjectInputStream {
    public PythonObjectInputStream(InputStream istr) throws IOException {
        super(istr);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass v2) throws IOException, ClassNotFoundException {
        String clsName = v2.getName();
        if (clsName.startsWith("org.python.proxies")) {
            int idx = clsName.lastIndexOf(36);
            if (idx > 19) {
                clsName = clsName.substring(19, idx);
            }
            if ((idx = clsName.indexOf(36)) >= 0) {
                String mod2 = clsName.substring(0, idx);
                clsName = clsName.substring(idx + 1);
                PyObject module = PythonObjectInputStream.importModule(mod2);
                PyType pycls = (PyType)module.__getattr__(clsName.intern());
                return pycls.getProxyType();
            }
        }
        try {
            return super.resolveClass(v2);
        }
        catch (ClassNotFoundException exc) {
            PyObject m2 = PythonObjectInputStream.importModule(clsName);
            Object cls = m2.__tojava__(Class.class);
            if (cls != null && cls != Py.NoConversion) {
                return (Class)cls;
            }
            throw exc;
        }
    }

    private static PyObject importModule(String name) {
        PyTuple fromlist = new PyTuple(Py.newString("__doc__"));
        return __builtin__.__import__(name, null, null, fromlist);
    }
}

