/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GlobMatchingTask
extends MatchingTask {
    private Path src;
    protected File destDir;
    private Set<File> toExpose = Generic.set();

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.toExpose.clear();
        for (String srcEntry : this.src.list()) {
            File srcDir = this.getProject().resolveFile(srcEntry);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir '" + srcDir.getPath() + "' does not exist!", this.getLocation());
            }
            String[] files = this.getDirectoryScanner(srcDir).getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.process(this.toExpose);
    }

    protected abstract void process(Set<File> var1);

    protected abstract String getFrom();

    protected abstract String getTo();

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m2 = new GlobPatternMapper();
        m2.setFrom(this.getFrom());
        m2.setTo(this.getTo());
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        for (File file : sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m2)) {
            this.toExpose.add(file);
        }
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory '" + this.destDir + "' does not exist " + "or is not a directory", this.getLocation());
        }
    }
}

