/*
 * Decompiled with CFR 0.152.
 */
package org.python.objectweb.asm.util;

import java.util.HashMap;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.MethodVisitor;
import org.python.objectweb.asm.util.ASMifierAbstractVisitor;
import org.python.objectweb.asm.util.ASMifierAnnotationVisitor;

public class ASMifierMethodVisitor
extends ASMifierAbstractVisitor
implements MethodVisitor {
    public ASMifierMethodVisitor() {
        super("mv");
        this.labelNames = new HashMap();
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = mv.visitAnnotationDefault();\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string2, boolean bl2) {
        this.buf.setLength(0);
        this.buf.append("{\n").append("av0 = mv.visitParameterAnnotation(").append(n2).append(", ");
        this.appendConstant(string2);
        this.buf.append(", ").append(bl2).append(");\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public void visitCode() {
        this.text.add("mv.visitCode();\n");
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        this.buf.setLength(0);
        switch (n2) {
            case -1: 
            case 0: {
                this.declareFrameTypes(n3, objectArray);
                this.declareFrameTypes(n4, objectArray2);
                if (n2 == -1) {
                    this.buf.append("mv.visitFrame(Opcodes.F_NEW, ");
                } else {
                    this.buf.append("mv.visitFrame(Opcodes.F_FULL, ");
                }
                this.buf.append(n3).append(", new Object[] {");
                this.appendFrameTypes(n3, objectArray);
                this.buf.append("}, ").append(n4).append(", new Object[] {");
                this.appendFrameTypes(n4, objectArray2);
                this.buf.append('}');
                break;
            }
            case 1: {
                this.declareFrameTypes(n3, objectArray);
                this.buf.append("mv.visitFrame(Opcodes.F_APPEND,").append(n3).append(", new Object[] {");
                this.appendFrameTypes(n3, objectArray);
                this.buf.append("}, 0, null");
                break;
            }
            case 2: {
                this.buf.append("mv.visitFrame(Opcodes.F_CHOP,").append(n3).append(", null, 0, null");
                break;
            }
            case 3: {
                this.buf.append("mv.visitFrame(Opcodes.F_SAME, 0, null, 0, null");
                break;
            }
            case 4: {
                this.declareFrameTypes(1, objectArray2);
                this.buf.append("mv.visitFrame(Opcodes.F_SAME1, 0, null, 1, new Object[] {");
                this.appendFrameTypes(1, objectArray2);
                this.buf.append('}');
            }
        }
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitInsn(int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitInsn(").append(OPCODES[n2]).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitIntInsn(").append(OPCODES[n2]).append(", ").append(n2 == 188 ? TYPES[n3] : Integer.toString(n3)).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitVarInsn(").append(OPCODES[n2]).append(", ").append(n3).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTypeInsn(int n2, String string2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitTypeInsn(").append(OPCODES[n2]).append(", ");
        this.appendConstant(string2);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int n2, String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.buf.append("mv.visitFieldInsn(").append(OPCODES[n2]).append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int n2, String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMethodInsn(").append(OPCODES[n2]).append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int n2, Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.buf.append("mv.visitJumpInsn(").append(OPCODES[n2]).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.buf.append("mv.visitLabel(");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLdcInsn(");
        this.appendConstant(object);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitIincInsn(").append(n2).append(", ").append(n3).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label[] labelArray) {
        int n4;
        this.buf.setLength(0);
        for (n4 = 0; n4 < labelArray.length; ++n4) {
            this.declareLabel(labelArray[n4]);
        }
        this.declareLabel(label);
        this.buf.append("mv.visitTableSwitchInsn(").append(n2).append(", ").append(n3).append(", ");
        this.appendLabel(label);
        this.buf.append(", new Label[] {");
        for (n4 = 0; n4 < labelArray.length; ++n4) {
            this.buf.append(n4 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n4]);
        }
        this.buf.append(" });\n");
        this.text.add(this.buf.toString());
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n2;
        this.buf.setLength(0);
        for (n2 = 0; n2 < labelArray.length; ++n2) {
            this.declareLabel(labelArray[n2]);
        }
        this.declareLabel(label);
        this.buf.append("mv.visitLookupSwitchInsn(");
        this.appendLabel(label);
        this.buf.append(", new int[] {");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.buf.append(n2 == 0 ? " " : ", ").append(nArray[n2]);
        }
        this.buf.append(" }, new Label[] {");
        for (n2 = 0; n2 < labelArray.length; ++n2) {
            this.buf.append(n2 == 0 ? " " : ", ");
            this.appendLabel(labelArray[n2]);
        }
        this.buf.append(" });\n");
        this.text.add(this.buf.toString());
    }

    public void visitMultiANewArrayInsn(String string2, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMultiANewArrayInsn(");
        this.appendConstant(string2);
        this.buf.append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string2) {
        this.buf.setLength(0);
        this.declareLabel(label);
        this.declareLabel(label2);
        this.declareLabel(label3);
        this.buf.append("mv.visitTryCatchBlock(");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ");
        this.appendLabel(label3);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String string2, String string3, String string4, Label label, Label label2, int n2) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLocalVariable(");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(", ");
        this.appendLabel(label);
        this.buf.append(", ");
        this.appendLabel(label2);
        this.buf.append(", ").append(n2).append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitLineNumber(int n2, Label label) {
        this.buf.setLength(0);
        this.buf.append("mv.visitLineNumber(").append(n2).append(", ");
        this.appendLabel(label);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
    }

    public void visitMaxs(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append("mv.visitMaxs(").append(n2).append(", ").append(n3).append(");\n");
        this.text.add(this.buf.toString());
    }

    private void declareFrameTypes(int n2, Object[] objectArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(objectArray[i2] instanceof Label)) continue;
            this.declareLabel((Label)objectArray[i2]);
        }
    }

    private void appendFrameTypes(int n2, Object[] objectArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                this.buf.append(", ");
            }
            if (objectArray[i2] instanceof String) {
                this.appendConstant(objectArray[i2]);
                continue;
            }
            if (objectArray[i2] instanceof Integer) {
                switch ((Integer)objectArray[i2]) {
                    case 0: {
                        this.buf.append("Opcodes.TOP");
                        break;
                    }
                    case 1: {
                        this.buf.append("Opcodes.INTEGER");
                        break;
                    }
                    case 2: {
                        this.buf.append("Opcodes.FLOAT");
                        break;
                    }
                    case 3: {
                        this.buf.append("Opcodes.DOUBLE");
                        break;
                    }
                    case 4: {
                        this.buf.append("Opcodes.LONG");
                        break;
                    }
                    case 5: {
                        this.buf.append("Opcodes.NULL");
                        break;
                    }
                    case 6: {
                        this.buf.append("Opcodes.UNINITIALIZED_THIS");
                    }
                }
                continue;
            }
            this.appendLabel((Label)objectArray[i2]);
        }
    }

    private void declareLabel(Label label) {
        String string2 = (String)this.labelNames.get(label);
        if (string2 == null) {
            string2 = "l" + this.labelNames.size();
            this.labelNames.put(label, string2);
            this.buf.append("Label ").append(string2).append(" = new Label();\n");
        }
    }

    private void appendLabel(Label label) {
        this.buf.append((String)this.labelNames.get(label));
    }
}

