/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class math
implements ClassDictInit {
    public static PyFloat pi = new PyFloat(Math.PI);
    public static PyFloat e = new PyFloat(Math.E);

    public static void classDictInit(PyObject dict) {
    }

    private static double check(double v2) {
        if (Double.isNaN(v2)) {
            throw Py.ValueError("math domain error");
        }
        if (Double.isInfinite(v2)) {
            throw Py.OverflowError("math range error");
        }
        return v2;
    }

    public static double acos(double v2) {
        return math.check(Math.acos(v2));
    }

    public static double asin(double v2) {
        return math.check(Math.asin(v2));
    }

    public static double atan(double v2) {
        return math.check(Math.atan(v2));
    }

    public static double atan2(double v2, double w2) {
        return math.check(Math.atan2(v2, w2));
    }

    public static double ceil(double v2) {
        return math.check(Math.ceil(v2));
    }

    public static double cos(double v2) {
        return math.check(Math.cos(v2));
    }

    public static double exp(double v2) {
        return math.check(Math.exp(v2));
    }

    public static double floor(PyObject v2) {
        return math.floor(v2.asDouble());
    }

    public static double floor(double v2) {
        return math.check(Math.floor(v2));
    }

    public static double log(PyObject v2) {
        return math.log(v2, null);
    }

    public static double log(PyObject v2, PyObject base2) {
        double doubleValue = v2 instanceof PyLong ? math.calculateLongLog((PyLong)v2) : math.log(v2.asDouble());
        if (base2 != null) {
            return math.check(math.applyLoggedBase(doubleValue, base2));
        }
        return doubleValue;
    }

    private static double calculateLongLog(PyLong v2) {
        int[] e2 = new int[1];
        double x2 = v2.scaledDoubleValue(e2);
        if (x2 <= 0.0) {
            throw Py.ValueError("math domain error");
        }
        return math.log(x2) + (double)e2[0] * 8.0 * math.log(2.0);
    }

    private static double applyLoggedBase(double loggedValue, PyObject base2) {
        double loggedBase = base2 instanceof PyLong ? math.calculateLongLog((PyLong)base2) : math.log(base2.asDouble());
        return math.check(loggedValue / loggedBase);
    }

    private static double log(double v2) {
        return math.check(Math.log(v2));
    }

    public static double pow(double v2, double w2) {
        return math.check(Math.pow(v2, w2));
    }

    public static double sin(PyObject v2) {
        return math.sin(v2.asDouble());
    }

    public static double sin(double v2) {
        return math.check(Math.sin(v2));
    }

    public static double sqrt(PyObject v2) {
        return math.sqrt(v2.asDouble());
    }

    public static double sqrt(double v2) {
        return math.check(Math.sqrt(v2));
    }

    public static double tan(double v2) {
        return math.check(Math.tan(v2));
    }

    public static double log10(PyObject v2) {
        if (v2 instanceof PyLong) {
            int[] e2 = new int[1];
            double x2 = ((PyLong)v2).scaledDoubleValue(e2);
            if (x2 <= 0.0) {
                throw Py.ValueError("math domain error");
            }
            return math.log10(x2) + (double)e2[0] * 8.0 * math.log10(2.0);
        }
        return math.log10(v2.asDouble());
    }

    private static double log10(double v2) {
        return math.check(Math.log10(v2));
    }

    public static double sinh(double v2) {
        return math.check(0.5 * (Math.exp(v2) - Math.exp(-v2)));
    }

    public static double cosh(double v2) {
        return math.check(0.5 * (Math.exp(v2) + Math.exp(-v2)));
    }

    public static double tanh(double v2) {
        return math.check(math.sinh(v2) / math.cosh(v2));
    }

    public static double fabs(double v2) {
        return Math.abs(v2);
    }

    public static double fmod(double v2, double w2) {
        return v2 % w2;
    }

    public static PyTuple modf(double v2) {
        double w2 = v2 % 1.0;
        return new PyTuple(new PyFloat(w2), new PyFloat(v2 -= w2));
    }

    public static PyTuple frexp(double x2) {
        int exponent = 0;
        if (Double.isNaN(x2) || Double.isInfinite(x2) || x2 == 0.0) {
            exponent = 0;
        } else {
            int sign = 1;
            if (x2 < 0.0) {
                x2 = -x2;
                sign = -1;
            }
            while (x2 < 0.5) {
                x2 *= 2.0;
                --exponent;
            }
            while (x2 >= 1.0) {
                x2 *= 0.5;
                ++exponent;
            }
            x2 *= (double)sign;
        }
        return new PyTuple(new PyFloat(x2), new PyInteger(exponent));
    }

    public static double ldexp(double v2, PyObject wObj) {
        int w2 = wObj.asInt();
        return math.check(v2 * Math.pow(2.0, w2));
    }

    public static double hypot(double v2, double w2) {
        return math.check(Math.hypot(v2, w2));
    }

    public static double radians(double v2) {
        return math.check(Math.toRadians(v2));
    }

    public static double degrees(double v2) {
        return math.check(Math.toDegrees(v2));
    }
}

