/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyObject;
import org.python.modules.math;

public class cmath {
    public static PyFloat pi = new PyFloat(Math.PI);
    public static PyFloat e = new PyFloat(Math.E);
    private static PyComplex one = new PyComplex(1.0, 0.0);
    private static PyComplex half = new PyComplex(0.5, 0.0);
    private static PyComplex i = new PyComplex(0.0, 1.0);
    private static PyComplex half_i = new PyComplex(0.0, 0.5);

    private static PyComplex c_prodi(PyComplex x2) {
        return new PyComplex(-x2.imag, x2.real);
    }

    private static double hypot(double x2, double y2) {
        return Math.sqrt(x2 * x2 + y2 * y2);
    }

    private static PyComplex complexFromPyObject(PyObject obj) {
        if (obj instanceof PyComplex) {
            return (PyComplex)obj;
        }
        PyObject newObj = null;
        if (obj instanceof PyInstance) {
            if (obj.__findattr__("__complex__") != null) {
                newObj = obj.invoke("__complex__");
            }
        } else {
            PyObject complexFunc = obj.getType().lookup("__complex__");
            if (complexFunc != null) {
                newObj = complexFunc.__call__(obj);
            }
        }
        if (newObj != null) {
            if (!(newObj instanceof PyComplex)) {
                throw Py.TypeError("__complex__ should return a complex object");
            }
            return (PyComplex)newObj;
        }
        return new PyComplex(obj.asDouble(), 0.0);
    }

    public static PyObject acos(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        return cmath.c_prodi(cmath.log(x2.__add__(i.__mul__(cmath.sqrt(one.__sub__(x2.__mul__(x2))))))).__neg__();
    }

    public static PyComplex acosh(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = null;
        PyComplex a2 = cmath.sqrt(x2.__sub__(one));
        PyComplex b2 = cmath.sqrt(x2.__add__(one));
        PyComplex c2 = cmath.sqrt(half);
        r2 = cmath.log(c2.__mul__(b2.__add__(a2)));
        return (PyComplex)r2.__add__(r2);
    }

    public static PyComplex asin(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = null;
        PyComplex squared = (PyComplex)x2.__mul__(x2);
        PyComplex sq1_minus_xsq = cmath.sqrt(one.__sub__(squared));
        r2 = (PyComplex)cmath.c_prodi(cmath.log(sq1_minus_xsq.__add__(cmath.c_prodi(x2)))).__neg__();
        return r2;
    }

    public static PyComplex asinh(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = null;
        PyComplex a2 = cmath.sqrt(x2.__add__(i));
        PyComplex b2 = cmath.sqrt(x2.__sub__(i));
        PyComplex z2 = cmath.sqrt(half);
        r2 = cmath.log(z2.__mul__(a2.__add__(b2)));
        return (PyComplex)r2.__add__(r2);
    }

    public static PyComplex atan(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = (PyComplex)half_i.__mul__(cmath.log(i.__add__(x2).__div__(i.__sub__(x2))));
        return r2;
    }

    public static PyComplex atanh(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = (PyComplex)half.__mul__(cmath.log(one.__add__(x2).__div__(one.__sub__(x2))));
        return r2;
    }

    public static PyComplex cos(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = new PyComplex(Math.cos(x2.real) * math.cosh(x2.imag), -Math.sin(x2.real) * math.sinh(x2.imag));
        return r2;
    }

    public static PyComplex cosh(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = new PyComplex(Math.cos(x2.imag) * math.cosh(x2.real), Math.sin(x2.imag) * math.sinh(x2.real));
        return r2;
    }

    public static PyComplex exp(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = new PyComplex(0.0, 0.0);
        double l2 = Math.exp(x2.real);
        r2.real = l2 * Math.cos(x2.imag);
        r2.imag = l2 * Math.sin(x2.imag);
        return r2;
    }

    public static PyComplex log(PyObject in) {
        PyComplex r2 = new PyComplex(0.0, 0.0);
        PyComplex x2 = cmath.complexFromPyObject(in);
        r2.imag = Math.atan2(x2.imag, x2.real);
        r2.real = Math.log(cmath.hypot(x2.real, x2.imag));
        return r2;
    }

    public static PyComplex log10(PyObject in) {
        PyComplex r2 = new PyComplex(0.0, 0.0);
        PyComplex x2 = cmath.complexFromPyObject(in);
        double l2 = cmath.hypot(x2.real, x2.imag);
        r2.imag = Math.atan2(x2.imag, x2.real) / Math.log(10.0);
        r2.real = math.log10(new PyFloat(l2));
        return r2;
    }

    public static PyComplex log(PyObject in, PyObject base2) {
        return cmath.log(cmath.complexFromPyObject(in), base2.asDouble());
    }

    public static PyComplex log(PyComplex x2, double base2) {
        PyComplex r2 = new PyComplex(0.0, 0.0);
        double l2 = cmath.hypot(x2.real, x2.imag);
        double log_base = Math.log(base2);
        r2.imag = Math.atan2(x2.imag, x2.real) / log_base;
        r2.real = math.log(new PyFloat(l2)) / log_base;
        return r2;
    }

    public static PyComplex sin(PyObject in) {
        PyComplex r2 = new PyComplex(0.0, 0.0);
        PyComplex x2 = cmath.complexFromPyObject(in);
        r2.real = Math.sin(x2.real) * math.cosh(x2.imag);
        r2.imag = Math.cos(x2.real) * math.sinh(x2.imag);
        return r2;
    }

    public static PyComplex sinh(PyObject in) {
        PyComplex r2 = new PyComplex(0.0, 0.0);
        PyComplex x2 = cmath.complexFromPyObject(in);
        r2.real = Math.cos(x2.imag) * math.sinh(x2.real);
        r2.imag = Math.sin(x2.imag) * math.cosh(x2.real);
        return r2;
    }

    public static PyComplex sqrt(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = new PyComplex(0.0, 0.0);
        if (x2.real != 0.0 || x2.imag != 0.0) {
            double s2 = Math.sqrt(0.5 * (Math.abs(x2.real) + cmath.hypot(x2.real, x2.imag)));
            double d2 = 0.5 * x2.imag / s2;
            if (x2.real > 0.0) {
                r2.real = s2;
                r2.imag = d2;
            } else if (x2.imag >= 0.0) {
                r2.real = d2;
                r2.imag = s2;
            } else {
                r2.real = -d2;
                r2.imag = -s2;
            }
        }
        return r2;
    }

    public static PyComplex tan(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = new PyComplex(0.0, 0.0);
        double sr = Math.sin(x2.real);
        double cr2 = Math.cos(x2.real);
        double shi = math.sinh(x2.imag);
        double chi = math.cosh(x2.imag);
        double rs = sr * chi;
        double is = cr2 * shi;
        double rc = cr2 * chi;
        double ic = -sr * shi;
        double d2 = rc * rc + ic * ic;
        r2.real = (rs * rc + is * ic) / d2;
        r2.imag = (is * rc - rs * ic) / d2;
        return r2;
    }

    public static PyComplex tanh(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        PyComplex r2 = new PyComplex(0.0, 0.0);
        double si = Math.sin(x2.imag);
        double ci2 = Math.cos(x2.imag);
        double shr = math.sinh(x2.real);
        double chr = math.cosh(x2.real);
        double rs = ci2 * shr;
        double is = si * chr;
        double rc = ci2 * chr;
        double ic = si * shr;
        double d2 = rc * rc + ic * ic;
        r2.real = (rs * rc + is * ic) / d2;
        r2.imag = (is * rc - rs * ic) / d2;
        return r2;
    }
}

