/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._weakref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.modules._weakref.AbstractReference;
import org.python.util.Generic;

public class GlobalRef
extends WeakReference {
    private int hashCode;
    private int pythonHashCode;
    private boolean havePythonHashCode;
    private List references = new ArrayList();
    private static ReferenceQueue referenceQueue = new ReferenceQueue();
    private static RefReaperThread reaperThread;
    private static ConcurrentMap<GlobalRef, GlobalRef> objects;

    public GlobalRef(PyObject object) {
        super(object, referenceQueue);
        this.hashCode = System.identityHashCode(object);
    }

    public synchronized void add(AbstractReference ref) {
        WeakReference<AbstractReference> r2 = new WeakReference<AbstractReference>(ref);
        this.references.add(r2);
    }

    private final AbstractReference getReferenceAt(int idx) {
        WeakReference wref = (WeakReference)this.references.get(idx);
        return (AbstractReference)wref.get();
    }

    synchronized AbstractReference find(Class cls) {
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            AbstractReference r2 = this.getReferenceAt(i2);
            if (r2 == null) {
                this.references.remove(i2);
                continue;
            }
            if (r2.callback != null || r2.getClass() != cls) continue;
            return r2;
        }
        return null;
    }

    synchronized void call() {
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            AbstractReference r2 = this.getReferenceAt(i2);
            if (r2 == null) {
                this.references.remove(i2);
                continue;
            }
            r2.call();
        }
    }

    public synchronized int count() {
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            AbstractReference r2 = this.getReferenceAt(i2);
            if (r2 != null) continue;
            this.references.remove(i2);
        }
        return this.references.size();
    }

    public synchronized PyList refs() {
        ArrayList<AbstractReference> list = new ArrayList<AbstractReference>();
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            AbstractReference r2 = this.getReferenceAt(i2);
            if (r2 == null) {
                this.references.remove(i2);
                continue;
            }
            list.add(r2);
        }
        return new PyList(list);
    }

    public static GlobalRef newInstance(PyObject object) {
        GlobalRef ref = (GlobalRef)objects.get(new GlobalRef(object));
        if (ref == null) {
            ref = new GlobalRef(object);
            objects.put(ref, ref);
        }
        return ref;
    }

    public static int getCount(PyObject object) {
        GlobalRef ref = (GlobalRef)objects.get(new GlobalRef(object));
        return ref == null ? 0 : ref.count();
    }

    public static PyList getRefs(PyObject object) {
        GlobalRef ref = (GlobalRef)objects.get(new GlobalRef(object));
        return ref == null ? new PyList() : ref.refs();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GlobalRef)) {
            return false;
        }
        Object t2 = this.get();
        Object u2 = ((GlobalRef)o2).get();
        if (t2 == null || u2 == null) {
            return false;
        }
        return t2 == u2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int pythonHashCode() {
        if (this.havePythonHashCode) {
            return this.pythonHashCode;
        }
        Object referent = this.get();
        if (referent == null) {
            throw Py.TypeError("weak object has gone away");
        }
        this.pythonHashCode = referent.hashCode();
        this.havePythonHashCode = true;
        return this.pythonHashCode;
    }

    private static void initReaperThread() {
        reaperThread = new RefReaperThread();
        reaperThread.setDaemon(true);
        reaperThread.start();
    }

    static {
        objects = Generic.concurrentMap();
        GlobalRef.initReaperThread();
    }

    private static class RefReaperThread
    extends Thread {
        RefReaperThread() {
            super("weakref reaper");
        }

        public void collect() throws InterruptedException {
            GlobalRef gr = (GlobalRef)referenceQueue.remove();
            gr.call();
            objects.remove(gr);
            gr = null;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.collect();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

