/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.expose.ExposedType;
import org.python.modules._codecs$EncodingMap$PyExposer;

public class _codecs {
    public static void register(PyObject search_function) {
        codecs.register(search_function);
    }

    public static PyTuple lookup(String encoding) {
        return codecs.lookup(encoding);
    }

    public static PyObject lookup_error(String handlerName) {
        return codecs.lookup_error(handlerName);
    }

    public static void register_error(String name, PyObject errorHandler) {
        codecs.register_error(name, errorHandler);
    }

    public static PyObject charmap_build(PyUnicode map) {
        return EncodingMap.buildEncodingMap(map);
    }

    private static PyTuple decode_tuple(String s2, int len) {
        return new PyTuple(new PyUnicode(s2), Py.newInteger(len));
    }

    private static PyTuple decode_tuple_str(String s2, int len) {
        return new PyTuple(new PyString(s2), Py.newInteger(len));
    }

    private static PyTuple encode_tuple(String s2, int len) {
        return new PyTuple(new PyString(s2), Py.newInteger(len));
    }

    public static PyTuple utf_8_decode(String str) {
        return _codecs.utf_8_decode(str, null);
    }

    public static PyTuple utf_8_decode(String str, String errors2) {
        return _codecs.utf_8_decode(str, errors2, false);
    }

    public static PyTuple utf_8_decode(String str, String errors2, boolean final_) {
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF8Stateful(str, errors2, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_8_encode(String str) {
        return _codecs.utf_8_encode(str, null);
    }

    public static PyTuple utf_8_encode(String str, String errors2) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF8(str, errors2), size);
    }

    public static PyTuple utf_7_decode(String str) {
        return _codecs.utf_7_decode(str, null);
    }

    public static PyTuple utf_7_decode(String str, String errors2) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF7(str, errors2), size);
    }

    public static PyTuple utf_7_encode(String str) {
        return _codecs.utf_7_encode(str, null);
    }

    public static PyTuple utf_7_encode(String str, String errors2) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF7(str, false, false, errors2), size);
    }

    public static PyTuple escape_decode(String str) {
        return _codecs.escape_decode(str, null);
    }

    public static PyTuple escape_decode(String str, String errors2) {
        return _codecs.decode_tuple_str(PyString.decode_UnicodeEscape(str, 0, str.length(), errors2, true), str.length());
    }

    public static PyTuple escape_encode(String str) {
        return _codecs.escape_encode(str, null);
    }

    public static PyTuple escape_encode(String str, String errors2) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple charmap_decode(String str, String errors2, PyObject mapping) {
        return _codecs.charmap_decode(str, errors2, mapping, false);
    }

    public static PyTuple charmap_decode(String str, String errors2, PyObject mapping, boolean ignoreUnmapped) {
        int size = str.length();
        StringBuilder v2 = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            char ch2 = str.charAt(i2);
            if (ch2 > '\u00ff') {
                i2 = codecs.insertReplacementAndGetResume(v2, errors2, "charmap", str, i2, i2 + 1, "ordinal not in range(255)") - 1;
                continue;
            }
            PyInteger w2 = Py.newInteger(ch2);
            PyObject x2 = mapping.__finditem__(w2);
            if (x2 == null) {
                if (ignoreUnmapped) {
                    v2.append(ch2);
                    continue;
                }
                i2 = codecs.insertReplacementAndGetResume(v2, errors2, "charmap", str, i2, i2 + 1, "no mapping found") - 1;
                continue;
            }
            if (x2 instanceof PyInteger) {
                int value = ((PyInteger)x2).getValue();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError("character mapping must return integer greater than 0 and less than sys.maxunicode");
                }
                v2.append((char)value);
                continue;
            }
            if (x2 == Py.None) {
                i2 = codecs.insertReplacementAndGetResume(v2, errors2, "charmap", str, i2, i2 + 1, "character maps to <undefined>") - 1;
                continue;
            }
            if (x2 instanceof PyString) {
                v2.append(x2.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.decode_tuple(v2.toString(), size);
    }

    public static PyObject translateCharmap(PyUnicode str, String errors2, PyObject mapping) {
        StringBuilder buf = new StringBuilder(str.toString().length());
        Iterator<Integer> iter = str.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            PyObject result = mapping.__finditem__(Py.newInteger(codePoint));
            if (result == null) {
                buf.appendCodePoint(codePoint);
                continue;
            }
            if (result == Py.None) continue;
            if (result instanceof PyInteger) {
                int value = result.asInt();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError(String.format("character mapping must be in range(0x%x)", 0x110000));
                }
                buf.appendCodePoint(value);
                continue;
            }
            if (result instanceof PyUnicode) {
                buf.append(result.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return new PyUnicode(buf.toString());
    }

    public static PyTuple charmap_encode(String str, String errors2, PyObject mapping) {
        if (mapping == null) {
            return _codecs.latin_1_encode(str, errors2);
        }
        return _codecs.charmap_encode_internal(str, errors2, mapping, new StringBuilder(str.length()), true);
    }

    /*
     * WARNING - void declaration
     */
    private static PyTuple charmap_encode_internal(String str, String errors2, PyObject mapping, StringBuilder v2, boolean letLookupHandleError) {
        EncodingMap encodingMap = mapping instanceof EncodingMap ? (EncodingMap)mapping : null;
        int size = str.length();
        for (int i2 = 0; i2 < size; ++i2) {
            void var10_10;
            int x2;
            int n2;
            char ch2 = str.charAt(i2);
            Object result = encodingMap != null ? ((n2 = encodingMap.lookup(ch2)) == -1 ? null : Py.newInteger(x2)) : mapping.__finditem__(Py.newInteger(ch2));
            if (result == null) {
                if (letLookupHandleError) {
                    i2 = _codecs.handleBadMapping(str, errors2, mapping, v2, size, i2);
                    continue;
                }
                throw Py.UnicodeEncodeError("charmap", str, i2, i2 + 1, "character maps to <undefined>");
            }
            if (result instanceof PyInteger) {
                x2 = ((PyInteger)result).getValue();
                if (x2 < 0 || x2 > 255) {
                    throw Py.TypeError("character mapping must be in range(256)");
                }
                v2.append((char)x2);
                continue;
            }
            if (var10_10 instanceof PyString && !(var10_10 instanceof PyUnicode)) {
                v2.append(var10_10.toString());
                continue;
            }
            if (var10_10 instanceof PyNone) {
                i2 = _codecs.handleBadMapping(str, errors2, mapping, v2, size, i2);
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.encode_tuple(v2.toString(), size);
    }

    private static int handleBadMapping(String str, String errors2, PyObject mapping, StringBuilder v2, int size, int i2) {
        if (errors2 != null) {
            if (errors2.equals("ignore")) {
                return i2;
            }
            if (errors2.equals("replace")) {
                _codecs.charmap_encode_internal("?", errors2, mapping, v2, false);
                return i2;
            }
            if (errors2.equals("xmlcharrefreplace")) {
                _codecs.charmap_encode_internal(codecs.xmlcharrefreplace(i2, i2 + 1, str).toString(), errors2, mapping, v2, false);
                return i2;
            }
            if (errors2.equals("backslashreplace")) {
                _codecs.charmap_encode_internal(codecs.backslashreplace(i2, i2 + 1, str).toString(), errors2, mapping, v2, false);
                return i2;
            }
        }
        PyObject replacement = codecs.encoding_error(errors2, "charmap", str, i2, i2 + 1, "character maps to <undefined>");
        String replStr = replacement.__getitem__(0).toString();
        _codecs.charmap_encode_internal(replStr, errors2, mapping, v2, false);
        return codecs.calcNewPosition(size, replacement) - 1;
    }

    public static PyTuple ascii_decode(String str) {
        return _codecs.ascii_decode(str, null);
    }

    public static PyTuple ascii_decode(String str, String errors2) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeASCII(str, size, errors2), size);
    }

    public static PyTuple ascii_encode(String str) {
        return _codecs.ascii_encode(str, null);
    }

    public static PyTuple ascii_encode(String str, String errors2) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeASCII(str, size, errors2), size);
    }

    public static PyTuple latin_1_decode(String str) {
        return _codecs.latin_1_decode(str, null);
    }

    public static PyTuple latin_1_decode(String str, String errors2) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeLatin1(str, size, errors2), size);
    }

    public static PyTuple latin_1_encode(String str) {
        return _codecs.latin_1_encode(str, null);
    }

    public static PyTuple latin_1_encode(String str, String errors2) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeLatin1(str, size, errors2), size);
    }

    public static PyTuple utf_16_encode(String str) {
        return _codecs.utf_16_encode(str, null);
    }

    public static PyTuple utf_16_encode(String str, String errors2) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors2, 0), str.length());
    }

    public static PyTuple utf_16_encode(String str, String errors2, int byteorder) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors2, byteorder), str.length());
    }

    public static PyTuple utf_16_le_encode(String str) {
        return _codecs.utf_16_le_encode(str, null);
    }

    public static PyTuple utf_16_le_encode(String str, String errors2) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors2, -1), str.length());
    }

    public static PyTuple utf_16_be_encode(String str) {
        return _codecs.utf_16_be_encode(str, null);
    }

    public static PyTuple utf_16_be_encode(String str, String errors2) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors2, 1), str.length());
    }

    public static String encode_UTF16(String str, String errors2, int byteorder) {
        Charset utf16 = byteorder == 0 ? Charset.forName("UTF-16") : (byteorder == -1 ? Charset.forName("UTF-16LE") : Charset.forName("UTF-16BE"));
        ByteBuffer bbuf = utf16.encode(str);
        StringBuilder v2 = new StringBuilder(bbuf.limit());
        while (bbuf.remaining() > 0) {
            int val = bbuf.get();
            if (val < 0) {
                val = 256 + val;
            }
            v2.appendCodePoint(val);
        }
        return v2.toString();
    }

    public static PyTuple utf_16_decode(String str) {
        return _codecs.utf_16_decode(str, null);
    }

    public static PyTuple utf_16_decode(String str, String errors2) {
        return _codecs.utf_16_decode(str, errors2, false);
    }

    public static PyTuple utf_16_decode(String str, String errors2, boolean final_) {
        int[] bo2 = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors2, bo2, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_le_decode(String str) {
        return _codecs.utf_16_le_decode(str, null);
    }

    public static PyTuple utf_16_le_decode(String str, String errors2) {
        return _codecs.utf_16_le_decode(str, errors2, false);
    }

    public static PyTuple utf_16_le_decode(String str, String errors2, boolean final_) {
        int[] bo2 = new int[]{-1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors2, bo2, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_be_decode(String str) {
        return _codecs.utf_16_be_decode(str, null);
    }

    public static PyTuple utf_16_be_decode(String str, String errors2) {
        return _codecs.utf_16_be_decode(str, errors2, false);
    }

    public static PyTuple utf_16_be_decode(String str, String errors2, boolean final_) {
        int[] bo2 = new int[]{1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors2, bo2, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_ex_decode(String str) {
        return _codecs.utf_16_ex_decode(str, null);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors2) {
        return _codecs.utf_16_ex_decode(str, errors2, 0);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors2, int byteorder) {
        return _codecs.utf_16_ex_decode(str, errors2, byteorder, false);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors2, int byteorder, boolean final_) {
        int[] bo2 = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        String decoded = _codecs.decode_UTF16(str, errors2, bo2, consumed);
        return new PyTuple(Py.newString(decoded), Py.newInteger(final_ ? str.length() : consumed[0]), Py.newInteger(bo2[0]));
    }

    private static String decode_UTF16(String str, String errors2, int[] byteorder) {
        return _codecs.decode_UTF16(str, errors2, byteorder, null);
    }

    private static String decode_UTF16(String str, String errors2, int[] byteorder, int[] consumed) {
        int i2;
        int bo2 = 0;
        if (byteorder != null) {
            bo2 = byteorder[0];
        }
        int size = str.length();
        StringBuilder v2 = new StringBuilder(size / 2);
        for (i2 = 0; i2 < size; i2 += 2) {
            char ch1 = str.charAt(i2);
            if (i2 + 1 == size) {
                if (consumed != null) break;
                i2 = codecs.insertReplacementAndGetResume(v2, errors2, "utf-16", str, i2, i2 + 1, "truncated data");
                continue;
            }
            char ch2 = str.charAt(i2 + 1);
            if (ch1 == '\u00fe' && ch2 == '\u00ff') {
                bo2 = 1;
                continue;
            }
            if (ch1 == '\u00ff' && ch2 == '\u00fe') {
                bo2 = -1;
                continue;
            }
            int W1 = bo2 == -1 ? ch2 << 8 | ch1 : ch1 << 8 | ch2;
            if (W1 < 55296 || W1 > 57343) {
                v2.appendCodePoint(W1);
                continue;
            }
            if (W1 >= 55296 && W1 <= 56319 && i2 < size - 1) {
                char ch3 = str.charAt(i2 += 2);
                char ch4 = str.charAt(i2 + 1);
                int W2 = bo2 == -1 ? ch4 << 8 | ch3 : ch3 << 8 | ch4;
                if (W2 >= 56320 && W2 <= 57343) {
                    int U2 = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                    v2.appendCodePoint(U2);
                    continue;
                }
                i2 = codecs.insertReplacementAndGetResume(v2, errors2, "utf-16", str, i2, i2 + 1, "illegal UTF-16 surrogate");
                continue;
            }
            i2 = codecs.insertReplacementAndGetResume(v2, errors2, "utf-16", str, i2, i2 + 1, "illegal encoding");
        }
        if (byteorder != null) {
            byteorder[0] = bo2;
        }
        if (consumed != null) {
            consumed[0] = i2;
        }
        return v2.toString();
    }

    public static PyTuple raw_unicode_escape_encode(String str) {
        return _codecs.raw_unicode_escape_encode(str, null);
    }

    public static PyTuple raw_unicode_escape_encode(String str, String errors2) {
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeRawUnicodeEscape(str, errors2, false), str.length());
    }

    public static PyTuple raw_unicode_escape_decode(String str) {
        return _codecs.raw_unicode_escape_decode(str, null);
    }

    public static PyTuple raw_unicode_escape_decode(String str, String errors2) {
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeRawUnicodeEscape(str, errors2), str.length());
    }

    public static PyTuple unicode_escape_encode(String str) {
        return _codecs.unicode_escape_encode(str, null);
    }

    public static PyTuple unicode_escape_encode(String str, String errors2) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple unicode_escape_decode(String str) {
        return _codecs.unicode_escape_decode(str, null);
    }

    public static PyTuple unicode_escape_decode(String str, String errors2) {
        int n2 = str.length();
        return _codecs.decode_tuple(PyString.decode_UnicodeEscape(str, 0, n2, errors2, true), n2);
    }

    public static PyTuple unicode_internal_encode(String str) {
        return _codecs.unicode_internal_encode(str, null);
    }

    public static PyTuple unicode_internal_encode(String str, String errors2) {
        return _codecs.encode_tuple(str, str.length());
    }

    public static PyTuple unicode_internal_decode(String str) {
        return _codecs.unicode_internal_decode(str, null);
    }

    public static PyTuple unicode_internal_decode(String str, String errors2) {
        return _codecs.decode_tuple(str, str.length());
    }

    @ExposedType(name="EncodingMap", isBaseType=false)
    public static class EncodingMap
    extends PyObject {
        char[] level1;
        char[] level23;
        int count2;
        int count3;

        private EncodingMap(char[] level1, char[] level23, int count2, int count3) {
            this.level1 = level1;
            this.level23 = level23;
            this.count2 = count2;
            this.count3 = count3;
        }

        /*
         * WARNING - void declaration
         */
        public static PyObject buildEncodingMap(PyObject string2) {
            void result;
            int length3;
            void i2;
            int l22;
            int charAt;
            int decode;
            if (!(string2 instanceof PyUnicode) || string2.__len__() != 256) {
                throw Py.TypeError("bad argument type for built-in operation");
            }
            boolean needDict = false;
            char[] level1 = new char[32];
            char[] level23 = new char[512];
            boolean bl2 = false;
            int count2 = 0;
            String count3 = string2.toString();
            for (decode = 0; decode < level1.length; ++decode) {
                level1[decode] = 255;
            }
            for (decode = 0; decode < level23.length; ++decode) {
                level23[decode] = 255;
            }
            if (count3.charAt(0) != '\u0000') {
                needDict = true;
            }
            for (decode = 1; decode < 256; ++decode) {
                void l1;
                char c2 = count3.charAt(decode);
                if (c2 == '\u0000') {
                    needDict = true;
                }
                if (c2 == '\ufffe') continue;
                int n2 = c2 >> 11;
                charAt = l1 >> 7;
                if (level1[l22] == '\u00ff') {
                    level1[l22] = (char)(++i2);
                }
                if (level23[charAt] != '\u00ff') continue;
                level23[charAt] = (char)count2++;
            }
            if (i2 > 255 || count2 > 255) {
                needDict = true;
            }
            if (needDict) {
                PyDictionary l22 = new PyDictionary();
                for (decode = 0; decode < 256; ++decode) {
                    ((PyObject)l22).__setitem__(Py.newInteger(count3.charAt(decode)), (PyObject)Py.newInteger(decode));
                }
                return l22;
            }
            l22 = 16 * i2;
            charAt = 128 * count2;
            level23 = new char[length3 + charAt];
            EncodingMap length2 = new EncodingMap(level1, level23, (int)i2, count2);
            for (decode = 0; decode < length3; ++decode) {
                level23[decode] = 255;
            }
            for (decode = length3; decode < length3 + result; ++decode) {
                level23[decode] = '\u0000';
            }
            count2 = 0;
            for (decode = 1; decode < 256; ++decode) {
                void o2;
                void o1;
                char c3 = count3.charAt(decode);
                if (c3 == '\ufffe') continue;
                int n3 = c3 >> 11;
                int n4 = o1 >> 7 & 0xF;
                int i22 = 16 * level1[o2] + n4;
                if (level23[i22] == '\u00ff') {
                    level23[i22] = (char)count2++;
                }
                int n5 = o1 & 0x7F;
                int charAt2 = 128 * level23[i22] + n5;
                level23[length3 + charAt2] = (char)decode;
            }
            return length2;
        }

        public int lookup(char c2) {
            int l1 = c2 >> 11;
            int l2 = c2 >> 7 & 0xF;
            int l3 = c2 & 0x7F;
            if (c2 == '\u0000') {
                return 0;
            }
            char i2 = this.level1[l1];
            if (i2 == '\u00ff') {
                return -1;
            }
            if ((i2 = this.level23[16 * i2 + l2]) == '\u00ff') {
                return -1;
            }
            if ((i2 = this.level23[16 * this.count2 + 128 * i2 + l3]) == '\u0000') {
                return -1;
            }
            return i2;
        }

        static {
            PyType.addBuilder(EncodingMap.class, new _codecs$EncodingMap$PyExposer());
        }
    }
}

