/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.Outliner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlOutline {
    private Indexer indexer;
    private StringBuilder buffer;

    public HtmlOutline(Indexer idx) {
        this.indexer = idx;
    }

    public String generate(String path) throws Exception {
        this.buffer = new StringBuilder(1024);
        List<Outliner.Entry> entries = this.indexer.generateOutline(path);
        this.addOutline(entries);
        String html = this.buffer.toString();
        this.buffer = null;
        return html;
    }

    private void addOutline(List<Outliner.Entry> entries) {
        this.add("<ul>\n");
        for (Outliner.Entry e2 : entries) {
            this.addEntry(e2);
        }
        this.add("</ul>\n");
    }

    private void addEntry(Outliner.Entry e2) {
        this.add("<li>");
        String style = null;
        switch (e2.getKind()) {
            case FUNCTION: 
            case METHOD: 
            case CONSTRUCTOR: {
                style = "function";
                break;
            }
            case CLASS: {
                style = "type-name";
                break;
            }
            case PARAMETER: {
                style = "parameter";
                break;
            }
            case VARIABLE: 
            case SCOPE: {
                style = "identifier";
            }
        }
        this.add("<a href='#");
        this.add(e2.getQname());
        this.add("'>");
        if (style != null) {
            this.add("<span class='");
            this.add(style);
            this.add("'>");
        }
        this.add(e2.getName());
        if (style != null) {
            this.add("</span>");
        }
        this.add("</a>");
        if (e2.isBranch()) {
            this.addOutline(e2.getChildren());
        }
        this.add("</li>");
    }

    private void add(String text2) {
        this.buffer.append(text2);
    }
}

