/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.Scope;
import org.python.indexer.StyleRun;
import org.python.indexer.ast.NStr;
import org.python.indexer.demos.Linker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocStringParser {
    private static final int MIN_TYPE_NAME_LENGTH = 4;
    private static final String IDENT = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final Pattern TYPE_NAME = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*\\.[a-zA-Z_][a-zA-Z0-9_]*(?:\\.[a-zA-Z_][a-zA-Z0-9_]*)*\\b|\\b[A-Z][a-zA-Z0-9_]*?[a-z][a-zA-Z0-9_]*\\b|(?<![a-zA-Z0-9_])?__[a-zA-Z][a-zA-Z_]*?__");
    private boolean resolveReferences = true;
    private int docOffset;
    private String docString;
    private NStr docNode;
    private Scope scope;
    private String file;
    private Set<Integer> offsets = new HashSet<Integer>();
    private List<StyleRun> styles = new ArrayList<StyleRun>();
    private Linker linker;

    public DocStringParser(String comment, NStr node, Linker linker) {
        this.docOffset = node.start();
        this.docString = comment;
        this.docNode = node;
        this.scope = node.getEnclosingNamespace();
        this.file = node.getFile();
        this.linker = linker;
    }

    public void setResolveReferences(boolean resolve) {
        this.resolveReferences = resolve;
    }

    public boolean isResolvingReferences() {
        return this.resolveReferences;
    }

    public List<StyleRun> highlight() {
        if (this.resolveReferences) {
            this.scanCommentForTypeNames();
        }
        return this.styles;
    }

    private void scanCommentForTypeNames() {
        Matcher m2 = TYPE_NAME.matcher(this.docString);
        while (m2.find()) {
            String qname = m2.group();
            int beg = m2.start() + this.docOffset;
            if (this.offsets.contains(beg) || qname.length() < 4) continue;
            this.checkForReference(beg, qname);
        }
    }

    private void checkForReference(int offset, String qname) {
        NBinding nb;
        if (qname.indexOf(46) == -1) {
            nb = this.scope.lookup(qname);
            if (nb == null) {
                nb = Indexer.idx.globaltable.lookup(qname);
            }
        } else {
            nb = Indexer.idx.lookupQname(qname);
        }
        if (nb != null) {
            this.linker.processRef(new Ref(this.file, offset, qname), nb);
        }
    }

    private void addStyle(int beg, int len, NBinding nb) {
        this.addStyle(beg, len, StyleRun.Type.TYPE_NAME);
        this.offsets.add(beg);
    }

    private void addStyle(int beg, int len, StyleRun.Type type) {
        this.styles.add(new StyleRun(type, beg, len));
        this.offsets.add(beg);
    }
}

