/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NList
extends NSequence {
    static final long serialVersionUID = 6623743056841822992L;

    public NList(List<NNode> elts) {
        this(elts, 0, 1);
    }

    public NList(List<NNode> elts, int start, int end) {
        super(elts, start, end);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        if (this.elts.size() == 0) {
            return this.setType(new NListType());
        }
        NListType listType = null;
        for (NNode elt : this.elts) {
            if (listType == null) {
                listType = new NListType(NList.resolveExpr(elt, s2));
                continue;
            }
            listType.add(NList.resolveExpr(elt, s2));
        }
        if (listType != null) {
            this.setType(listType);
        }
        return this.getType();
    }

    public String toString() {
        return "<List:" + this.start() + ":" + this.elts + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNodeList(this.elts, v2);
        }
    }
}

