/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NDict
extends NNode {
    static final long serialVersionUID = 318144953740238374L;
    public List<NNode> keys;
    public List<NNode> values;

    public NDict(List<NNode> keys, List<NNode> values) {
        this(keys, values, 0, 1);
    }

    public NDict(List<NNode> keys, List<NNode> values, int start, int end) {
        super(start, end);
        this.keys = keys;
        this.values = values;
        this.addChildren(keys);
        this.addChildren(values);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NType keyType = this.resolveListAsUnion(this.keys, s2);
        NType valType = this.resolveListAsUnion(this.values, s2);
        return this.setType(new NDictType(keyType, valType));
    }

    public String toString() {
        return "<Dict>";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNodeList(this.keys, v2);
            this.visitNodeList(this.values, v2);
        }
    }
}

