/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCompare
extends NNode {
    static final long serialVersionUID = 1013460919393985064L;
    public NNode left;
    public List<NNode> ops;
    public List<NNode> comparators;

    public NCompare(NNode left, List<NNode> ops, List<NNode> comparators) {
        this(left, ops, comparators, 0, 1);
    }

    public NCompare(NNode left, List<NNode> ops, List<NNode> comparators, int start, int end) {
        super(start, end);
        this.left = left;
        this.ops = ops;
        this.comparators = comparators;
        this.addChildren(left);
        this.addChildren(ops);
        this.addChildren(comparators);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        this.setType(Indexer.idx.builtins.BaseNum);
        NCompare.resolveExpr(this.left, s2);
        this.resolveList(this.comparators, s2);
        return this.getType();
    }

    public String toString() {
        return "<Compare:" + this.left + ":" + this.ops + ":" + this.comparators + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.left, v2);
            this.visitNodeList(this.ops, v2);
            this.visitNodeList(this.comparators, v2);
        }
    }
}

