/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NKeyword;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCall
extends NNode {
    static final long serialVersionUID = 5212954751978100639L;
    public NNode func;
    public List<NNode> args;
    public List<NKeyword> keywords;
    public NNode kwargs;
    public NNode starargs;

    public NCall(NNode func, List<NNode> args, List<NKeyword> keywords, NNode kwargs, NNode starargs) {
        this(func, args, keywords, kwargs, starargs, 0, 1);
    }

    public NCall(NNode func, List<NNode> args, List<NKeyword> keywords, NNode kwargs, NNode starargs, int start, int end) {
        super(start, end);
        this.func = func;
        this.args = args;
        this.keywords = keywords;
        this.kwargs = kwargs;
        this.starargs = starargs;
        this.addChildren(func, kwargs, starargs);
        this.addChildren(args);
        this.addChildren(keywords);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NType ft = NCall.resolveExpr(this.func, s2);
        ArrayList<NType> argTypes = new ArrayList<NType>();
        for (NNode a2 : this.args) {
            argTypes.add(NCall.resolveExpr(a2, s2));
        }
        this.resolveList(this.keywords, s2);
        NCall.resolveExpr(this.starargs, s2);
        NCall.resolveExpr(this.kwargs, s2);
        if (ft.isClassType()) {
            return this.setType(ft);
        }
        if (ft.isFuncType()) {
            return this.setType(ft.asFuncType().getReturnType().follow());
        }
        if (ft.isUnknownType()) {
            NUnknownType to = new NUnknownType();
            NFuncType at2 = new NFuncType(to);
            NUnionType.union(ft, at2);
            return this.setType(to);
        }
        this.addWarning("calling non-function " + ft);
        return this.setType(new NUnknownType());
    }

    public String toString() {
        return "<Call:" + this.func + ":" + this.args + ":" + this.start() + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.func, v2);
            this.visitNodeList(this.args, v2);
            this.visitNodeList(this.keywords, v2);
            this.visitNode(this.kwargs, v2);
            this.visitNode(this.starargs, v2);
        }
    }
}

