/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBoolOp
extends NNode {
    static final long serialVersionUID = -5261954056600388069L;
    OpType op;
    public List<NNode> values;

    public NBoolOp(OpType op, List<NNode> values) {
        this(op, values, 0, 1);
    }

    public NBoolOp(OpType op, List<NNode> values, int start, int end) {
        super(start, end);
        this.op = op;
        this.values = values;
        this.addChildren(values);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        if (this.op == OpType.AND) {
            NType last = null;
            for (NNode e2 : this.values) {
                last = NBoolOp.resolveExpr(e2, s2);
            }
            return this.setType(last == null ? new NUnknownType() : last);
        }
        return this.setType(this.resolveListAsUnion(this.values, s2));
    }

    public String toString() {
        return "<BoolOp:" + (Object)((Object)this.op) + ":" + this.values + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNodeList(this.values, v2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpType {
        AND,
        OR,
        UNDEFINED;

    }
}

