/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.BindingFinder;
import org.python.indexer.ast.DefaultNodeVisitor;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NClassDef;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NGlobal;
import org.python.indexer.ast.NLambda;
import org.python.indexer.ast.NNode;
import org.python.indexer.types.NType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBody
extends NBlock {
    static final long serialVersionUID = 1518962862898927516L;

    public NBody(NBlock block) {
        this(block == null ? null : block.seq);
    }

    public NBody(List<NNode> seq) {
        super(seq);
    }

    public NBody(List<NNode> seq, int start, int end) {
        super(seq, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NType resolve(Scope scope) throws Exception {
        try {
            scope.setNameBindingPhase(true);
            this.visit(new GlobalFinder(scope));
            this.visit(new BindingFinder(scope));
        }
        finally {
            scope.setNameBindingPhase(false);
        }
        return super.resolve(scope);
    }

    private class GlobalFinder
    extends DefaultNodeVisitor {
        private Scope scope;

        public GlobalFinder(Scope scope) {
            this.scope = scope;
        }

        public boolean visit(NGlobal n2) {
            NNode.resolveExpr(n2, this.scope);
            return false;
        }

        public boolean visit(NFunctionDef n2) {
            return false;
        }

        public boolean visit(NLambda n2) {
            return false;
        }

        public boolean visit(NClassDef n2) {
            return false;
        }
    }
}

