/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.Util;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NUrl;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private static Set<Scope> looked = new HashSet<Scope>();
    private Map<String, NBinding> table;
    private Scope parent;
    private List<Scope> supers;
    private Set<String> globalNames;
    private Type scopeType;
    private String path = "";
    private int lambdaCounter = 0;
    private boolean isBindingPhase = false;

    public Scope(Scope parent, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("'type' param cannot be null");
        }
        this.setParent(parent);
        this.setScopeType(type);
    }

    public void setTable(Map<String, NBinding> table) {
        this.table = table;
    }

    public Map<String, NBinding> getTable() {
        if (this.table != null) {
            return Collections.unmodifiableMap(this.table);
        }
        Map<String, NBinding> map = Collections.emptyMap();
        return map;
    }

    public void setParent(Scope parent) {
        this.parent = parent;
    }

    public Scope getParent() {
        return this.parent;
    }

    public void addSuper(Scope sup) {
        if (this.supers == null) {
            this.supers = new ArrayList<Scope>();
        }
        this.supers.add(sup);
    }

    public void setSupers(List<Scope> supers) {
        this.supers = supers;
    }

    public List<Scope> getSupers() {
        if (this.supers != null) {
            return Collections.unmodifiableList(this.supers);
        }
        List<Scope> list = Collections.emptyList();
        return list;
    }

    public void setScopeType(Type type) {
        this.scopeType = type;
    }

    public Type getScopeType() {
        return this.scopeType;
    }

    public boolean isFunctionScope() {
        return this.scopeType == Type.FUNCTION;
    }

    public void addGlobalName(String name) {
        if (name == null) {
            return;
        }
        if (this.globalNames == null) {
            this.globalNames = new HashSet<String>();
        }
        this.globalNames.add(name);
    }

    public boolean isGlobalName(String name) {
        if (this.globalNames != null) {
            return this.globalNames.contains(name);
        }
        return this.parent == null ? false : this.parent.isGlobalName(name);
    }

    public void put(String id, NBinding b2) {
        this.putBinding(id, b2);
    }

    public NBinding put(String id, NNode loc, NType type, NBinding.Kind kind) {
        if (type == null) {
            throw new IllegalArgumentException("Null type: id=" + id + ", loc=" + loc);
        }
        NBinding b2 = this.lookupScope(id);
        return this.insertOrUpdate(b2, id, loc, type, kind);
    }

    public NBinding putAttr(String id, NNode loc, NType type, NBinding.Kind kind) {
        if (type == null) {
            throw new IllegalArgumentException("Null type: id=" + id + ", loc=" + loc);
        }
        if ("".equals(this.path)) {
            Indexer.idx.reportFailedAssertion("Attempting to set attr '" + id + "' at location " + loc + (loc != null ? loc.getFile() : "") + " in scope with no path (qname) set: " + this.toShortString());
            return null;
        }
        NBinding b2 = this.lookupAttr(id);
        return this.insertOrUpdate(b2, id, loc, type, kind);
    }

    private NBinding insertOrUpdate(NBinding b2, String id, NNode loc, NType t2, NBinding.Kind k2) {
        if (b2 == null) {
            b2 = this.insertBinding(new NBinding(id, loc, t2, k2));
        } else {
            this.updateType(b2, loc, t2, k2);
        }
        return b2;
    }

    public NBinding update(String id, NNode loc, NType type, NBinding.Kind kind) {
        if (type == null) {
            throw new IllegalArgumentException("Null type: id=" + id + ", loc=" + loc);
        }
        return this.update(id, new Def(loc), type, kind);
    }

    public NBinding update(String id, Def loc, NType type, NBinding.Kind kind) {
        if (type == null) {
            throw new IllegalArgumentException("Null type: id=" + id + ", loc=" + loc);
        }
        NBinding b2 = this.lookupScope(id);
        if (b2 == null) {
            return this.insertBinding(new NBinding(id, loc, type, kind));
        }
        b2.getDefs().clear();
        b2.addDef(loc);
        b2.setType(type);
        if (b2.getType().isUnknownType()) {
            b2.setKind(kind);
        }
        return b2;
    }

    private NBinding insertBinding(NBinding b2) {
        switch (b2.getKind()) {
            case MODULE: {
                b2.setQname(b2.getType().getTable().path);
                break;
            }
            case PARAMETER: {
                b2.setQname(this.extendPathForParam(b2.getName()));
                break;
            }
            default: {
                b2.setQname(this.extendPath(b2.getName()));
            }
        }
        b2 = Indexer.idx.putBinding(b2);
        this.putBinding(b2.getName(), b2);
        return b2;
    }

    private void putBinding(String id, NBinding b2) {
        this.ensureTable();
        this.table.put(id, b2);
    }

    private void updateType(NBinding b2, NNode loc, NType type, NBinding.Kind kind) {
        NType t2;
        NType t1;
        NType btype;
        NType curType = b2.followType();
        if (!this.isNewType(curType, type)) {
            if (loc != null && !(loc instanceof NUrl) && !b2.getDefs().contains(loc)) {
                Indexer.idx.putLocation(loc, b2);
            }
            return;
        }
        if (loc != null && !b2.getRefs().contains(loc)) {
            b2.addDef(loc);
            b2.setProvisional(false);
        }
        if ((btype = b2.getType()).isUnknownType() && !btype.getTable().isEmpty()) {
            t1 = type;
            t2 = btype;
        } else {
            t1 = btype;
            t2 = type;
        }
        NType newType = NUnionType.union(t1, t2);
        b2.setType(newType);
        if (curType.isUnknownType()) {
            b2.setKind(kind);
        }
        this.retargetReferences(b2, curType);
    }

    private void retargetReferences(NBinding b2, NType curType) {
        Scope newScope = b2.followType().getTable();
        for (Map.Entry<String, NBinding> e2 : curType.getTable().entrySet()) {
            String attr = e2.getKey();
            NBinding oldBinding = e2.getValue();
            if (!oldBinding.isProvisional()) continue;
            Indexer.idx.removeBinding(oldBinding);
            NBinding newBinding = newScope.lookupAttr(attr);
            if (newBinding == null) continue;
            ArrayList<Ref> refs = new ArrayList<Ref>();
            refs.addAll(oldBinding.getRefs());
            for (Ref ref : refs) {
                Indexer.idx.updateLocation(ref, newBinding);
            }
        }
    }

    private boolean isNewType(NType curType, NType type) {
        if (this.isBindingPhase) {
            return false;
        }
        if (curType.isUnionType()) {
            return !curType.asUnionType().contains(type);
        }
        return curType != type;
    }

    public void remove(String id) {
        if (this.table != null) {
            this.table.remove(id);
        }
    }

    public Scope copy(Type tableType) {
        Scope ret = new Scope(null, tableType);
        if (this.table != null) {
            ret.ensureTable();
            ret.table.putAll(this.table);
        }
        return ret;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("'path' param cannot be null");
        }
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String a2, String b2) {
        NBinding b1 = this.lookup(a2);
        NBinding b22 = this.lookup(b2);
        if (b1 != null && b22 != null) {
            b1.setQname(b22.getQname());
        }
    }

    public NBinding lookup(String name) {
        NBinding ent;
        NBinding b2 = this.getModuleBindingIfGlobal(name);
        if (b2 != null) {
            return b2;
        }
        if (this.table != null && (ent = this.table.get(name)) != null) {
            return ent;
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().lookup(name);
    }

    public NBinding lookup(NNode n2) {
        if (n2 instanceof NName) {
            return this.lookup(((NName)n2).id);
        }
        return null;
    }

    public NBinding lookupLocal(String name) {
        NBinding b2 = this.getModuleBindingIfGlobal(name);
        if (b2 != null) {
            return b2;
        }
        return this.table == null ? null : this.table.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBinding lookupAttr(String name, boolean supersOnly) {
        NBinding b2;
        if (looked.contains(this)) {
            return null;
        }
        if (this.table != null && !supersOnly && (b2 = this.table.get(name)) != null) {
            return b2;
        }
        if (this.supers == null || this.supers.isEmpty()) {
            return null;
        }
        looked.add(this);
        try {
            for (Scope p2 : this.supers) {
                NBinding b3 = p2.lookupAttr(name);
                if (b3 == null) continue;
                NBinding nBinding = b3;
                return nBinding;
            }
            NBinding nBinding = null;
            return nBinding;
        }
        finally {
            looked.remove(this);
        }
    }

    public NBinding lookupAttr(String name) {
        return this.lookupAttr(name, false);
    }

    public NType lookupType(String name) {
        return this.lookupType(name, false);
    }

    public NType lookupType(String name, boolean localOnly) {
        NBinding b2;
        NBinding nBinding = b2 = localOnly ? this.lookupLocal(name) : this.lookup(name);
        if (b2 == null) {
            return null;
        }
        NType ret = b2.followType();
        if (this == Indexer.idx.moduleTable) {
            if (ret.isModuleType()) {
                return ret;
            }
            if (ret.isUnionType()) {
                for (NType t2 : ret.asUnionType().getTypes()) {
                    NType realType = t2.follow();
                    if (!realType.isModuleType()) continue;
                    return realType;
                }
            }
            Indexer.idx.warn("Found non-module type in module table: " + b2);
            return null;
        }
        return ret;
    }

    public NType lookupTypeAttr(String name) {
        NBinding b2 = this.lookupAttr(name);
        if (b2 != null) {
            return b2.followType();
        }
        return null;
    }

    public NBinding lookupBounded(String name, Type typebound) {
        if (this.scopeType == typebound) {
            return this.table == null ? null : this.table.get(name);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().lookupBounded(name, typebound);
    }

    public boolean isScope() {
        switch (this.scopeType) {
            case CLASS: 
            case INSTANCE: 
            case FUNCTION: 
            case MODULE: 
            case GLOBAL: {
                return true;
            }
        }
        return false;
    }

    public Scope getScopeSymtab() {
        if (this.isScope()) {
            return this;
        }
        if (this.getParent() == null) {
            Indexer.idx.reportFailedAssertion("No binding scope found for " + this.toShortString());
            return this;
        }
        return this.getParent().getScopeSymtab();
    }

    public NBinding lookupScope(String name) {
        NBinding b2 = this.getModuleBindingIfGlobal(name);
        if (b2 != null) {
            return b2;
        }
        Scope st = this.getScopeSymtab();
        if (st != null) {
            return st.lookupLocal(name);
        }
        return null;
    }

    public Scope getSymtabOfType(Type type) {
        if (this.scopeType == type) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getSymtabOfType(type);
    }

    public Scope getGlobalTable() {
        Scope result = this.getSymtabOfType(Type.MODULE);
        if (result == null) {
            Indexer.idx.reportFailedAssertion("No module table found for " + this);
            result = this;
        }
        return result;
    }

    public Scope getEnclosingLexicalScope() {
        if (this.scopeType == Type.FUNCTION || this.scopeType == Type.MODULE) {
            return this;
        }
        if (this.parent == null) {
            Indexer.idx.reportFailedAssertion("No lexical scope found for " + this);
            return this;
        }
        return this.parent.getEnclosingLexicalScope();
    }

    private NBinding getModuleBindingIfGlobal(String name) {
        Scope module;
        if (this.isGlobalName(name) && (module = this.getGlobalTable()) != null && module != this) {
            return module.lookupLocal(name);
        }
        return null;
    }

    public boolean isNameBindingPhase() {
        return this.isBindingPhase;
    }

    public void setNameBindingPhase(boolean isBindingPhase) {
        this.isBindingPhase = isBindingPhase;
    }

    public void merge(Scope other) {
        this.ensureTable();
        this.table.putAll(other.table);
    }

    public Set<String> keySet() {
        if (this.table != null) {
            return this.table.keySet();
        }
        Set<String> result = Collections.emptySet();
        return result;
    }

    public Collection<NBinding> values() {
        if (this.table != null) {
            return this.table.values();
        }
        Set<NBinding> result = Collections.emptySet();
        return result;
    }

    public Set<Map.Entry<String, NBinding>> entrySet() {
        if (this.table != null) {
            return this.table.entrySet();
        }
        Set<Map.Entry<String, NBinding>> result = Collections.emptySet();
        return result;
    }

    public boolean isEmpty() {
        return this.table == null ? true : this.table.isEmpty();
    }

    public void clear() {
        if (this.table != null) {
            this.table.clear();
            this.table = null;
        }
        this.parent = null;
        if (this.supers != null) {
            this.supers.clear();
            this.supers = null;
        }
        if (this.globalNames != null) {
            this.globalNames.clear();
            this.globalNames = null;
        }
    }

    public String newLambdaName() {
        return "lambda%" + ++this.lambdaCounter;
    }

    public String extendPathForParam(String name) {
        if (this.path.equals("")) {
            throw new IllegalStateException("Not inside a function");
        }
        return this.path + "@" + name;
    }

    public String extendPath(String name) {
        if (name.endsWith(".py")) {
            name = Util.moduleNameFor(name);
        }
        if (this.path.equals("")) {
            return name;
        }
        String sep = null;
        switch (this.scopeType) {
            case CLASS: 
            case INSTANCE: 
            case MODULE: 
            case SCOPE: {
                sep = ".";
                break;
            }
            case FUNCTION: {
                sep = "&";
                break;
            }
            default: {
                System.err.println("unsupported context for extendPath: " + (Object)((Object)this.scopeType));
                return this.path;
            }
        }
        return this.path + sep + name;
    }

    private void ensureTable() {
        if (this.table == null) {
            this.table = new LinkedHashMap<String, NBinding>();
        }
    }

    public String toString() {
        return "<Scope:" + (Object)((Object)this.getScopeType()) + ":" + this.path + ":" + (this.table == null ? "{}" : this.table.keySet()) + ">";
    }

    public String toShortString() {
        return "<Scope:" + (Object)((Object)this.getScopeType()) + ":" + this.path + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CLASS,
        INSTANCE,
        FUNCTION,
        MODULE,
        GLOBAL,
        SCOPE;

    }
}

