/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;

    private Splitter(Strategy strategy) {
        this(strategy, false, CharMatcher.NONE);
    }

    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer) {
        this.strategy = strategy;
        this.omitEmptyStrings = omitEmptyStrings;
        this.trimmer = trimmer;
    }

    public static Splitter on(char separator) {
        return Splitter.on(CharMatcher.is(separator));
    }

    public static Splitter on(final CharMatcher separatorMatcher) {
        Preconditions.checkNotNull(separatorMatcher);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    int separatorStart(int start) {
                        return separatorMatcher.indexIn(this.toSplit, start);
                    }

                    int separatorEnd(int separatorPosition) {
                        return separatorPosition + 1;
                    }
                };
            }
        });
    }

    public static Splitter on(final String separator) {
        Preconditions.checkArgument(separator.length() != 0, "The separator may not be the empty string.");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    public int separatorStart(int start) {
                        int delimeterLength = separator.length();
                        int last = this.toSplit.length() - delimeterLength;
                        block0: for (int p2 = start; p2 <= last; ++p2) {
                            for (int i2 = 0; i2 < delimeterLength; ++i2) {
                                if (this.toSplit.charAt(i2 + p2) != separator.charAt(i2)) continue block0;
                            }
                            return p2;
                        }
                        return -1;
                    }

                    public int separatorEnd(int separatorPosition) {
                        return separatorPosition + separator.length();
                    }
                };
            }
        });
    }

    @GwtIncompatible(value="java.util.regex")
    public static Splitter on(final Pattern separatorPattern) {
        Preconditions.checkNotNull(separatorPattern);
        Preconditions.checkArgument(!separatorPattern.matcher("").matches(), "The pattern may not match the empty string: %s", separatorPattern);
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                final Matcher matcher = separatorPattern.matcher(toSplit);
                return new SplittingIterator(splitter, toSplit){

                    public int separatorStart(int start) {
                        return matcher.find(start) ? matcher.start() : -1;
                    }

                    public int separatorEnd(int separatorPosition) {
                        return matcher.end();
                    }
                };
            }
        });
    }

    @GwtIncompatible(value="java.util.regex")
    public static Splitter onPattern(String separatorPattern) {
        return Splitter.on(Pattern.compile(separatorPattern));
    }

    public static Splitter fixedLength(final int length) {
        Preconditions.checkArgument(length > 0, "The length may not be less than 1");
        return new Splitter(new Strategy(){

            public SplittingIterator iterator(Splitter splitter, CharSequence toSplit) {
                return new SplittingIterator(splitter, toSplit){

                    public int separatorStart(int start) {
                        int nextChunkStart = start + length;
                        return nextChunkStart < this.toSplit.length() ? nextChunkStart : -1;
                    }

                    public int separatorEnd(int separatorPosition) {
                        return separatorPosition;
                    }
                };
            }
        });
    }

    public Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer);
    }

    public Splitter trimResults() {
        return this.trimResults(CharMatcher.WHITESPACE);
    }

    public Splitter trimResults(CharMatcher trimmer) {
        Preconditions.checkNotNull(trimmer);
        return new Splitter(this.strategy, this.omitEmptyStrings, trimmer);
    }

    public Iterable<String> split(final CharSequence sequence) {
        Preconditions.checkNotNull(sequence);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Splitter.this.strategy.iterator(Splitter.this, sequence);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractIterator<T>
    implements Iterator<T> {
        State state = State.NOT_READY;
        T next;

        private AbstractIterator() {
        }

        protected abstract T computeNext();

        protected final T endOfData() {
            this.state = State.DONE;
            return null;
        }

        @Override
        public final boolean hasNext() {
            Preconditions.checkState(this.state != State.FAILED);
            switch (this.state) {
                case DONE: {
                    return false;
                }
                case READY: {
                    return true;
                }
            }
            return this.tryToComputeNext();
        }

        boolean tryToComputeNext() {
            this.state = State.FAILED;
            this.next = this.computeNext();
            if (this.state != State.DONE) {
                this.state = State.READY;
                return true;
            }
            return false;
        }

        @Override
        public final T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.state = State.NOT_READY;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            READY,
            NOT_READY,
            DONE,
            FAILED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        final CharMatcher trimmer;
        final boolean omitEmptyStrings;
        int offset = 0;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        protected SplittingIterator(Splitter splitter, CharSequence toSplit) {
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.toSplit = toSplit;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected String computeNext() {
            while (this.offset != -1) {
                int separatorPosition;
                int start = this.offset;
                int n2 = this.separatorStart(this.offset);
                if (n2 == -1) {
                    separatorPosition = this.toSplit.length();
                    this.offset = -1;
                } else {
                    void end;
                    separatorPosition = end;
                    this.offset = this.separatorEnd((int)end);
                }
                while (start < separatorPosition && this.trimmer.matches(this.toSplit.charAt(start))) {
                    ++start;
                }
                while (separatorPosition > start && this.trimmer.matches(this.toSplit.charAt(separatorPosition - 1))) {
                    --separatorPosition;
                }
                if (this.omitEmptyStrings && start == separatorPosition) continue;
                return ((Object)this.toSplit.subSequence(start, separatorPosition)).toString();
            }
            return (String)this.endOfData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Strategy {
        public Iterator<String> iterator(Splitter var1, CharSequence var2);
    }
}

