/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.python.core.Py;
import org.python.core.io.RawIOBase;
import org.python.modules.posix.PosixModule;

public class StreamIO
extends RawIOBase {
    private ReadableByteChannel readChannel;
    private WritableByteChannel writeChannel;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean closefd;

    public StreamIO(ReadableByteChannel readChannel, boolean closefd) {
        this.readChannel = readChannel;
        this.closefd = closefd;
    }

    public StreamIO(ReadableByteChannel readChannel) {
        this(readChannel, true);
    }

    public StreamIO(WritableByteChannel writeChannel, boolean closefd) {
        this.writeChannel = writeChannel;
        this.closefd = closefd;
    }

    public StreamIO(WritableByteChannel writeChannel) {
        this(writeChannel, true);
    }

    public StreamIO(InputStream inputStream, boolean closefd) {
        this(StreamIO.newChannel(inputStream), closefd);
        this.inputStream = inputStream;
    }

    public StreamIO(OutputStream outputStream, boolean closefd) {
        this(Channels.newChannel(outputStream), closefd);
        this.outputStream = outputStream;
    }

    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.readChannel.read(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.writeChannel.write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public void flush() {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        if (this.closefd) {
            try {
                if (this.readChannel != null) {
                    this.readChannel.close();
                    if (this.writeChannel != null && this.readChannel != this.writeChannel) {
                        this.writeChannel.close();
                    }
                } else {
                    this.writeChannel.close();
                }
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileDescriptor getInputFileDescriptor(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        if (stream instanceof FileInputStream) {
            return ((FileInputStream)stream).getFD();
        }
        if (stream instanceof FilterInputStream) {
            Field inField = null;
            try {
                inField = FilterInputStream.class.getDeclaredField("in");
                inField.setAccessible(true);
                FileDescriptor fileDescriptor = StreamIO.getInputFileDescriptor((InputStream)inField.get(stream));
                return fileDescriptor;
            }
            catch (Exception exception) {
            }
            finally {
                if (inField != null && inField.isAccessible()) {
                    inField.setAccessible(false);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileDescriptor getOutputFileDescriptor(OutputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        if (stream instanceof FileOutputStream) {
            return ((FileOutputStream)stream).getFD();
        }
        if (stream instanceof FilterOutputStream) {
            Field outField = null;
            try {
                outField = FilterOutputStream.class.getDeclaredField("out");
                outField.setAccessible(true);
                FileDescriptor fileDescriptor = StreamIO.getOutputFileDescriptor((OutputStream)outField.get(stream));
                return fileDescriptor;
            }
            catch (Exception exception) {
            }
            finally {
                if (outField != null && outField.isAccessible()) {
                    outField.setAccessible(false);
                }
            }
        }
        return null;
    }

    public boolean isatty() {
        FileDescriptor fd;
        this.checkClosed();
        try {
            fd = StreamIO.getInputFileDescriptor(this.inputStream);
            if (fd == null && (fd = StreamIO.getOutputFileDescriptor(this.outputStream)) == null) {
                return false;
            }
        }
        catch (IOException e2) {
            return false;
        }
        return PosixModule.getPOSIX().isatty(fd);
    }

    public boolean readable() {
        return this.readChannel != null;
    }

    public boolean writable() {
        return this.writeChannel != null;
    }

    public OutputStream asOutputStream() {
        if (this.writable()) {
            if (this.outputStream == null) {
                return Channels.newOutputStream(this.writeChannel);
            }
            return this.outputStream;
        }
        return super.asOutputStream();
    }

    public InputStream asInputStream() {
        if (this.readable()) {
            if (this.inputStream == null) {
                return Channels.newInputStream(this.readChannel);
            }
            return this.inputStream;
        }
        return super.asInputStream();
    }

    public Channel getChannel() {
        return this.readable() ? this.readChannel : this.writeChannel;
    }

    private static ReadableByteChannel newChannel(InputStream in) {
        return new InternalReadableByteChannel(in);
    }

    private static class InternalReadableByteChannel
    extends AbstractInterruptibleChannel
    implements ReadableByteChannel {
        private InputStream in;
        private boolean open = true;

        InternalReadableByteChannel(InputStream in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer dst) throws IOException {
            int totalRead;
            int CHUNK = 8192;
            int len = dst.remaining();
            int bytesRead = 0;
            byte[] buf = new byte[]{};
            for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
                int bytesToRead = Math.min(len - totalRead, 8192);
                if (buf.length < bytesToRead) {
                    buf = new byte[bytesToRead];
                }
                try {
                    this.begin();
                    bytesRead = this.in.read(buf, 0, bytesToRead);
                    this.end(bytesRead > 0);
                }
                catch (Throwable throwable) {
                    this.end(bytesRead > 0);
                    throw throwable;
                }
                if (bytesRead < 0) break;
                dst.put(buf, 0, bytesRead);
            }
            if (bytesRead < 0 && totalRead == 0) {
                return -1;
            }
            return totalRead;
        }

        protected void implCloseChannel() throws IOException {
            if (this.open) {
                this.in.close();
                this.open = false;
            }
        }
    }
}

