/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PySystemState;
import org.python.core.ThreadState;

class ThreadStateMapping {
    private static final ThreadLocal<ThreadState> cachedThreadState = new ThreadLocal();

    ThreadStateMapping() {
    }

    public ThreadState getThreadState(PySystemState newSystemState) {
        ThreadState ts = cachedThreadState.get();
        if (ts != null) {
            return ts;
        }
        Thread t2 = Thread.currentThread();
        if (newSystemState == null) {
            Py.writeDebug("threadstate", "no current system state");
            if (Py.defaultSystemState == null) {
                PySystemState.initialize();
            }
            newSystemState = Py.defaultSystemState;
        }
        ts = new ThreadState(t2, newSystemState);
        cachedThreadState.set(ts);
        return ts;
    }
}

