/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString$PyExposer;
import org.python.core.PyStringDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StringFormatter;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.ucnhashAPI;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="str", doc="str(object) -> string\n\nReturn a nice string representation of the object.\nIf the argument is a string, the return value is the same object.")
public class PyString
extends PyBaseString {
    public static final PyType TYPE;
    protected String string;
    protected transient boolean interned = false;
    private static char[] hexdigit;
    private static ucnhashAPI pucnHash;

    public String getString() {
        return this.string;
    }

    public PyString() {
        this(TYPE, "");
    }

    public PyString(PyType subType, String string2) {
        super(subType);
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot create PyString from null!");
        }
        this.string = string2;
    }

    public PyString(String string2) {
        this(TYPE, string2);
    }

    public PyString(char c2) {
        this(TYPE, String.valueOf(c2));
    }

    PyString(StringBuilder buffer) {
        this(TYPE, new String(buffer));
    }

    public static PyString fromInterned(String interned) {
        PyString str = new PyString(TYPE, interned);
        str.interned = true;
        return str;
    }

    @ExposedNew
    static PyObject str_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap2 = new ArgParser("str", args, keywords, new String[]{"object"}, 0);
        PyObject S2 = ap2.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (S2 == null) {
                return new PyString("");
            }
            return new PyString(S2.__str__().toString());
        }
        if (S2 == null) {
            return new PyStringDerived(subtype, "");
        }
        return new PyStringDerived(subtype, S2.__str__().toString());
    }

    public int[] toCodePoints() {
        int n2 = this.getString().length();
        int[] codePoints = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            codePoints[i2] = this.getString().charAt(i2);
        }
        return codePoints;
    }

    public String substring(int start, int end) {
        return this.getString().substring(start, end);
    }

    @Override
    public PyString __str__() {
        return this.str___str__();
    }

    final PyString str___str__() {
        if (this.getClass() == PyString.class) {
            return this;
        }
        return new PyString(this.getString());
    }

    @Override
    public PyUnicode __unicode__() {
        return new PyUnicode(this);
    }

    @Override
    public int __len__() {
        return this.str___len__();
    }

    final int str___len__() {
        return this.getString().length();
    }

    @Override
    public String toString() {
        return this.getString();
    }

    public String internedString() {
        if (this.interned) {
            return this.getString();
        }
        this.string = this.getString().intern();
        this.interned = true;
        return this.getString();
    }

    @Override
    public PyString __repr__() {
        return this.str___repr__();
    }

    final PyString str___repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.getString(), true));
    }

    public static String encode_UnicodeEscape(String str, boolean use_quotes) {
        int size = str.length();
        StringBuilder v2 = new StringBuilder(str.length());
        char quote = '\u0000';
        if (use_quotes) {
            quote = str.indexOf(39) >= 0 && str.indexOf(34) == -1 ? (char)'\"' : '\'';
            v2.append(quote);
        }
        int i2 = 0;
        while (size-- > 0) {
            char ch2 = str.charAt(i2++);
            if (use_quotes && ch2 == quote || ch2 == '\\') {
                v2.append('\\');
                v2.append(ch2);
                continue;
            }
            if (ch2 >= '\ud800' && ch2 < '\udc00') {
                char ch22 = str.charAt(i2++);
                --size;
                if (ch22 >= '\udc00' && ch22 <= '\udfff') {
                    int ucs = ((ch2 & 0x3FF) << 10 | ch22 & 0x3FF) + 65536;
                    v2.append('\\');
                    v2.append('U');
                    v2.append(hexdigit[ucs >> 28 & 0xF]);
                    v2.append(hexdigit[ucs >> 24 & 0xF]);
                    v2.append(hexdigit[ucs >> 20 & 0xF]);
                    v2.append(hexdigit[ucs >> 16 & 0xF]);
                    v2.append(hexdigit[ucs >> 12 & 0xF]);
                    v2.append(hexdigit[ucs >> 8 & 0xF]);
                    v2.append(hexdigit[ucs >> 4 & 0xF]);
                    v2.append(hexdigit[ucs & 0xF]);
                    continue;
                }
                --i2;
                ++size;
            }
            if (ch2 >= '\u0100') {
                v2.append('\\');
                v2.append('u');
                v2.append(hexdigit[ch2 >> 12 & 0xF]);
                v2.append(hexdigit[ch2 >> 8 & 0xF]);
                v2.append(hexdigit[ch2 >> 4 & 0xF]);
                v2.append(hexdigit[ch2 & 0xF]);
                continue;
            }
            if (ch2 == '\t') {
                v2.append("\\t");
                continue;
            }
            if (ch2 == '\n') {
                v2.append("\\n");
                continue;
            }
            if (ch2 == '\r') {
                v2.append("\\r");
                continue;
            }
            if (ch2 < ' ' || ch2 >= '\u007f') {
                v2.append('\\');
                v2.append('x');
                v2.append(hexdigit[ch2 >> 4 & 0xF]);
                v2.append(hexdigit[ch2 & 0xF]);
                continue;
            }
            v2.append(ch2);
        }
        if (use_quotes) {
            v2.append(quote);
        }
        return v2.toString();
    }

    public static String decode_UnicodeEscape(String str, int start, int end, String errors2, boolean unicode) {
        StringBuilder v2 = new StringBuilder(end - start);
        int s2 = start;
        while (s2 < end) {
            char ch2 = str.charAt(s2);
            if (ch2 != '\\') {
                v2.append(ch2);
                ++s2;
                continue;
            }
            int loopStart = s2++;
            if (s2 == end) {
                s2 = codecs.insertReplacementAndGetResume(v2, errors2, "unicodeescape", str, loopStart, s2 + 1, "\\ at end of string");
                continue;
            }
            ch2 = str.charAt(s2++);
            switch (ch2) {
                case '\n': {
                    break;
                }
                case '\\': {
                    v2.append('\\');
                    break;
                }
                case '\'': {
                    v2.append('\'');
                    break;
                }
                case '\"': {
                    v2.append('\"');
                    break;
                }
                case 'b': {
                    v2.append('\b');
                    break;
                }
                case 'f': {
                    v2.append('\f');
                    break;
                }
                case 't': {
                    v2.append('\t');
                    break;
                }
                case 'n': {
                    v2.append('\n');
                    break;
                }
                case 'r': {
                    v2.append('\r');
                    break;
                }
                case 'v': {
                    v2.append('\u000b');
                    break;
                }
                case 'a': {
                    v2.append('\u0007');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int x2 = Character.digit(ch2, 8);
                    for (int j2 = 0; j2 < 2 && s2 < end && (ch2 = str.charAt(s2)) >= '0' && ch2 <= '7'; ++j2, ++s2) {
                        x2 = (x2 << 3) + Character.digit(ch2, 8);
                    }
                    v2.append((char)x2);
                    break;
                }
                case 'x': {
                    s2 = PyString.hexescape(v2, errors2, 2, s2, str, end, "truncated \\xXX");
                    break;
                }
                case 'u': {
                    if (!unicode) {
                        v2.append('\\');
                        v2.append('u');
                        break;
                    }
                    s2 = PyString.hexescape(v2, errors2, 4, s2, str, end, "truncated \\uXXXX");
                    break;
                }
                case 'U': {
                    if (!unicode) {
                        v2.append('\\');
                        v2.append('U');
                        break;
                    }
                    s2 = PyString.hexescape(v2, errors2, 8, s2, str, end, "truncated \\UXXXXXXXX");
                    break;
                }
                case 'N': {
                    if (!unicode) {
                        v2.append('\\');
                        v2.append('N');
                        break;
                    }
                    if (pucnHash == null) {
                        PyObject mod2 = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(mod2 = mod2.__call__()).__tojava__(Object.class);
                        if (pucnHash.getCchMax() < 0) {
                            throw Py.UnicodeError("Unicode names not loaded");
                        }
                    }
                    if (str.charAt(s2) == '{') {
                        int startName;
                        int endBrace;
                        int maxLen = pucnHash.getCchMax();
                        for (endBrace = startName = s2 + 1; endBrace < end && str.charAt(endBrace) != '}' && endBrace - startName <= maxLen; ++endBrace) {
                        }
                        if (endBrace != end && str.charAt(endBrace) == '}') {
                            int value = pucnHash.getValue(str, startName, endBrace);
                            if (PyString.storeUnicodeCharacter(value, v2)) {
                                s2 = endBrace + 1;
                                break;
                            }
                            s2 = codecs.insertReplacementAndGetResume(v2, errors2, "unicodeescape", str, loopStart, endBrace + 1, "illegal Unicode character");
                            break;
                        }
                        s2 = codecs.insertReplacementAndGetResume(v2, errors2, "unicodeescape", str, loopStart, endBrace, "malformed \\N character escape");
                        break;
                    }
                    s2 = codecs.insertReplacementAndGetResume(v2, errors2, "unicodeescape", str, loopStart, s2 + 1, "malformed \\N character escape");
                    break;
                }
                default: {
                    v2.append('\\');
                    v2.append(str.charAt(s2 - 1));
                }
            }
        }
        return v2.toString();
    }

    private static int hexescape(StringBuilder partialDecode, String errors2, int digits, int hexDigitStart, String str, int size, String errorMessage) {
        int i2;
        if (hexDigitStart + digits > size) {
            return codecs.insertReplacementAndGetResume(partialDecode, errors2, "unicodeescape", str, hexDigitStart - 2, size, errorMessage);
        }
        int x2 = 0;
        for (i2 = 0; i2 < digits; ++i2) {
            char c2 = str.charAt(hexDigitStart + i2);
            int d2 = Character.digit(c2, 16);
            if (d2 == -1) {
                return codecs.insertReplacementAndGetResume(partialDecode, errors2, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i2 + 1, errorMessage);
            }
            x2 = x2 << 4 & 0xFFFFFFF0;
            if (c2 >= '0' && c2 <= '9') {
                x2 += c2 - 48;
                continue;
            }
            if (c2 >= 'a' && c2 <= 'f') {
                x2 += 10 + c2 - 97;
                continue;
            }
            x2 += 10 + c2 - 65;
        }
        if (PyString.storeUnicodeCharacter(x2, partialDecode)) {
            return hexDigitStart + i2;
        }
        return codecs.insertReplacementAndGetResume(partialDecode, errors2, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i2 + 1, "illegal Unicode character");
    }

    private static boolean storeUnicodeCharacter(int value, StringBuilder partialDecode) {
        if (value < 0 || value >= 55296 && value <= 57343) {
            return false;
        }
        if (value <= 0x10FFFF) {
            partialDecode.appendCodePoint(value);
            return true;
        }
        return false;
    }

    final PyObject str___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("string index out of range");
        }
        return ret;
    }

    final PyObject str___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final int str___cmp__(PyObject other) {
        if (!(other instanceof PyString)) {
            return -2;
        }
        int c2 = this.getString().compareTo(((PyString)other).getString());
        return c2 < 0 ? -1 : (c2 > 0 ? 1 : 0);
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject str___eq__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().equals(s2) ? Py.True : Py.False;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final PyObject str___ne__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().equals(s2) ? Py.False : Py.True;
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.str___lt__(other);
    }

    final PyObject str___lt__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.str___le__(other);
    }

    final PyObject str___le__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) <= 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.str___gt__(other);
    }

    final PyObject str___gt__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) > 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.str___ge__(other);
    }

    final PyObject str___ge__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) >= 0 ? Py.True : Py.False;
    }

    private static String coerce(PyObject o2) {
        if (o2 instanceof PyString) {
            return o2.toString();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.str___hash__();
    }

    final int str___hash__() {
        return this.getString().hashCode();
    }

    public byte[] toBytes() {
        return StringUtil.toBytes(this.getString());
    }

    @Override
    public Object __tojava__(Class<?> c2) {
        if (c2.isAssignableFrom(String.class)) {
            return this.getString();
        }
        if ((c2 == Character.TYPE || c2 == Character.class) && this.getString().length() == 1) {
            return new Character(this.getString().charAt(0));
        }
        if (c2.isArray()) {
            if (c2.getComponentType() == Byte.TYPE) {
                return this.toBytes();
            }
            if (c2.getComponentType() == Character.TYPE) {
                return this.getString().toCharArray();
            }
        }
        if (c2.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    protected PyObject pyget(int i2) {
        return Py.newString(this.getString().charAt(i2));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            return this.fromSubstring(start, stop);
        }
        int n2 = PyString.sliceLength(start, stop, step);
        char[] new_chars = new char[n2];
        int j2 = 0;
        int i2 = start;
        while (j2 < n2) {
            new_chars[j2++] = this.getString().charAt(i2);
            i2 += step;
        }
        return this.createInstance(new String(new_chars), true);
    }

    public PyString createInstance(String str) {
        return new PyString(str);
    }

    protected PyString createInstance(String str, boolean isBasic) {
        return new PyString(str);
    }

    @Override
    public boolean __contains__(PyObject o2) {
        return this.str___contains__(o2);
    }

    final boolean str___contains__(PyObject o2) {
        if (!(o2 instanceof PyString)) {
            throw Py.TypeError("'in <string>' requires string as left operand");
        }
        PyString other = (PyString)o2;
        return this.getString().indexOf(other.getString()) >= 0;
    }

    @Override
    protected PyObject repeat(int count) {
        int s2;
        if (count < 0) {
            count = 0;
        }
        if ((long)(s2 = this.getString().length()) * (long)count > Integer.MAX_VALUE) {
            throw Py.OverflowError("max str len is 2147483647");
        }
        char[] new_chars = new char[s2 * count];
        for (int i2 = 0; i2 < count; ++i2) {
            this.getString().getChars(0, s2, new_chars, i2 * s2);
        }
        return this.createInstance(new String(new_chars));
    }

    @Override
    public PyObject __mul__(PyObject o2) {
        return this.str___mul__(o2);
    }

    final PyObject str___mul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o2) {
        return this.str___rmul__(o2);
    }

    final PyObject str___rmul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.str___add__(other);
    }

    final PyObject str___add__(PyObject other) {
        if (other instanceof PyUnicode) {
            return this.decode().__add__(other);
        }
        if (other instanceof PyString) {
            PyString otherStr = (PyString)other;
            return new PyString(this.getString().concat(otherStr.getString()));
        }
        return null;
    }

    final PyTuple str___getnewargs__() {
        return new PyTuple(new PyString(this.getString()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.str___getnewargs__();
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.str___mod__(other);
    }

    public PyObject str___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.getString(), false);
        return fmt.format(other);
    }

    @Override
    public PyObject __int__() {
        try {
            return Py.newInteger(this.atoi(10));
        }
        catch (PyException e2) {
            if (e2.match(Py.OverflowError)) {
                return this.atol(10);
            }
            throw e2;
        }
    }

    @Override
    public PyObject __long__() {
        return this.atol(10);
    }

    @Override
    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    @Override
    public PyObject __pos__() {
        throw Py.TypeError("bad operand type for unary +");
    }

    @Override
    public PyObject __neg__() {
        throw Py.TypeError("bad operand type for unary -");
    }

    @Override
    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    @Override
    public PyComplex __complex__() {
        int s2;
        boolean got_re = false;
        boolean got_im = false;
        boolean done = false;
        boolean sw_error = false;
        int n2 = this.getString().length();
        for (s2 = 0; s2 < n2 && Character.isSpaceChar(this.getString().charAt(s2)); ++s2) {
        }
        if (s2 == n2) {
            throw Py.ValueError("empty string for complex()");
        }
        double z2 = -1.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int sign = 1;
        block7: do {
            char c2 = this.getString().charAt(s2);
            switch (c2) {
                case '-': {
                    sign = -1;
                }
                case '+': {
                    if (done || s2 + 1 == n2) {
                        sw_error = true;
                        break;
                    }
                    c2 = this.getString().charAt(++s2);
                    if (Character.isDigit(c2) || c2 == 'J' || c2 == 'j') continue block7;
                    sw_error = true;
                    break;
                }
                case 'J': 
                case 'j': {
                    if (got_im || done) {
                        sw_error = true;
                        break;
                    }
                    y2 = z2 < 0.0 ? (double)sign : (double)sign * z2;
                    got_im = true;
                    done = got_re;
                    sign = 1;
                    ++s2;
                    break;
                }
                case ' ': {
                    while (s2 < n2 && Character.isSpaceChar(this.getString().charAt(s2))) {
                        ++s2;
                    }
                    if (s2 == n2) continue block7;
                    sw_error = true;
                    break;
                }
                default: {
                    boolean digit_or_dot;
                    boolean bl2 = digit_or_dot = c2 == '.' || Character.isDigit(c2);
                    if (!digit_or_dot) {
                        sw_error = true;
                        break;
                    }
                    int end = this.endDouble(this.getString(), s2);
                    z2 = Double.valueOf(this.getString().substring(s2, end));
                    if (z2 == Double.POSITIVE_INFINITY) {
                        throw Py.ValueError(String.format("float() out of range: %.150s", this.getString()));
                    }
                    s2 = end;
                    if (s2 < n2 && ((c2 = this.getString().charAt(s2)) == 'J' || c2 == 'j')) continue block7;
                    if (got_re) {
                        sw_error = true;
                        break;
                    }
                    x2 = (double)sign * z2;
                    got_re = true;
                    done = got_im;
                    z2 = -1.0;
                    sign = 1;
                }
            }
        } while (s2 < n2 && !sw_error);
        if (sw_error) {
            throw Py.ValueError("malformed string for complex() " + this.getString().substring(s2));
        }
        return new PyComplex(x2, y2);
    }

    private int endDouble(String string2, int s2) {
        int n2 = string2.length();
        while (s2 < n2) {
            char c2;
            if (Character.isDigit(c2 = string2.charAt(s2++)) || c2 == '.') continue;
            if ((c2 == 'e' || c2 == 'E') && s2 < n2) {
                c2 = string2.charAt(s2);
                if (c2 != '+' && c2 != '-') continue;
                ++s2;
                continue;
            }
            return s2 - 1;
        }
        return s2;
    }

    public String lower() {
        return this.str_lower();
    }

    final String str_lower() {
        return this.getString().toLowerCase();
    }

    public String upper() {
        return this.str_upper();
    }

    final String str_upper() {
        return this.getString().toUpperCase();
    }

    public String title() {
        return this.str_title();
    }

    final String str_title() {
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        boolean previous_is_cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = chars[i2];
            chars[i2] = previous_is_cased ? Character.toLowerCase(ch2) : Character.toTitleCase(ch2);
            previous_is_cased = Character.isLowerCase(ch2) || Character.isUpperCase(ch2) || Character.isTitleCase(ch2);
        }
        return new String(chars);
    }

    public String swapcase() {
        return this.str_swapcase();
    }

    final String str_swapcase() {
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = chars[i2];
            if (Character.isUpperCase(c2)) {
                chars[i2] = Character.toLowerCase(c2);
                continue;
            }
            if (!Character.isLowerCase(c2)) continue;
            chars[i2] = Character.toUpperCase(c2);
        }
        return new String(chars);
    }

    public String strip() {
        return this.str_strip(null);
    }

    public String strip(String sep) {
        return this.str_strip(sep);
    }

    final String str_strip(String sep) {
        int end;
        int start;
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        if (sep == null) {
            for (start = 0; start < n2 && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n2 && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        if (sep == null) {
            for (end = n2 - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        if (end >= start) {
            return end < n2 - 1 || start > 0 ? this.getString().substring(start, end + 1) : this.getString();
        }
        return "";
    }

    public String lstrip() {
        return this.str_lstrip(null);
    }

    public String lstrip(String sep) {
        return this.str_lstrip(sep);
    }

    final String str_lstrip(String sep) {
        int start;
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        if (sep == null) {
            for (start = 0; start < n2 && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n2 && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        return start > 0 ? this.getString().substring(start, n2) : this.getString();
    }

    public String rstrip(String sep) {
        return this.str_rstrip(sep);
    }

    final String str_rstrip(String sep) {
        int end;
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        if (sep == null) {
            for (end = n2 - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        return end < n2 - 1 ? this.getString().substring(0, end + 1) : this.getString();
    }

    public PyList split() {
        return this.str_split(null, -1);
    }

    public PyList split(String sep) {
        return this.str_split(sep, -1);
    }

    public PyList split(String sep, int maxsplit) {
        return this.str_split(sep, maxsplit);
    }

    final PyList str_split(String sep, int maxsplit) {
        if (sep != null) {
            if (sep.length() == 0) {
                throw Py.ValueError("empty separator");
            }
            return this.splitfields(sep, maxsplit);
        }
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        if (maxsplit < 0) {
            maxsplit = n2;
        }
        int index = 0;
        for (int splits = 0; index < n2 && splits < maxsplit; ++splits) {
            while (index < n2 && Character.isWhitespace(chars[index])) {
                ++index;
            }
            if (index == n2) break;
            int start = index;
            while (index < n2 && !Character.isWhitespace(chars[index])) {
                ++index;
            }
            list.append(this.fromSubstring(start, index));
        }
        while (index < n2 && Character.isWhitespace(chars[index])) {
            ++index;
        }
        if (index < n2) {
            list.append(this.fromSubstring(index, n2));
        }
        return list;
    }

    public PyList rsplit() {
        return this.str_rsplit(null, -1);
    }

    public PyList rsplit(String sep) {
        return this.str_rsplit(sep, -1);
    }

    public PyList rsplit(String sep, int maxsplit) {
        return this.str_rsplit(sep, maxsplit);
    }

    final PyList str_rsplit(String sep, int maxsplit) {
        int i2;
        if (sep != null) {
            if (sep.length() == 0) {
                throw Py.ValueError("empty separator");
            }
            PyList list = this.rsplitfields(sep, maxsplit);
            list.reverse();
            return list;
        }
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        if (maxsplit < 0) {
            maxsplit = chars.length;
        }
        int splits = 0;
        for (i2 = chars.length - 1; i2 > -1 && Character.isWhitespace(chars[i2]); --i2) {
        }
        if (i2 == -1) {
            return list;
        }
        while (splits < maxsplit) {
            int nextWsChar;
            while (i2 > -1 && Character.isWhitespace(chars[i2])) {
                --i2;
            }
            if (i2 == -1) break;
            for (nextWsChar = i2; nextWsChar > -1 && !Character.isWhitespace(chars[nextWsChar]); --nextWsChar) {
            }
            if (nextWsChar == -1) break;
            ++splits;
            list.add(this.fromSubstring(nextWsChar + 1, i2 + 1));
            i2 = nextWsChar;
        }
        while (i2 > -1 && Character.isWhitespace(chars[i2])) {
            --i2;
        }
        if (i2 > -1) {
            list.add(this.fromSubstring(0, i2 + 1));
        }
        list.reverse();
        return list;
    }

    public PyTuple partition(PyObject sepObj) {
        return this.str_partition(sepObj);
    }

    final PyTuple str_partition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodePartition(sepObj);
        }
        if (!(sepObj instanceof PyString)) {
            throw Py.TypeError("expected a character buffer object");
        }
        String sep = ((PyString)sepObj).getString();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().indexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(this, Py.EmptyString, Py.EmptyString);
    }

    final PyTuple unicodePartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.indexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(this, emptyUnicode, emptyUnicode);
    }

    public PyTuple rpartition(PyObject sepObj) {
        return this.str_rpartition(sepObj);
    }

    final PyTuple str_rpartition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodeRpartition(sepObj);
        }
        if (!(sepObj instanceof PyString)) {
            throw Py.TypeError("expected a character buffer object");
        }
        String sep = ((PyString)sepObj).getString();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(Py.EmptyString, Py.EmptyString, this);
    }

    final PyTuple unicodeRpartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(emptyUnicode, emptyUnicode, this);
    }

    private PyList splitfields(String sep, int maxsplit) {
        int index;
        PyList list = new PyList();
        int length = this.getString().length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        int lastbreak = 0;
        int splits = 0;
        int sepLength = sep.length();
        if (sep.length() == 0 && maxsplit != 0) {
            index = this.getString().indexOf(sep, lastbreak);
            list.append(this.fromSubstring(lastbreak, index));
            ++splits;
        }
        while (splits < maxsplit && (index = this.getString().indexOf(sep, lastbreak)) != -1) {
            if (sep.length() == 0) {
                ++index;
            }
            ++splits;
            list.append(this.fromSubstring(lastbreak, index));
            lastbreak = index + sepLength;
        }
        if (lastbreak <= length) {
            list.append(this.fromSubstring(lastbreak, length));
        }
        return list;
    }

    private PyList rsplitfields(String sep, int maxsplit) {
        PyList list = new PyList();
        int length = this.getString().length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        int lastbreak = length;
        int index = length;
        int sepLength = sep.length();
        for (int splits = 0; index > 0 && splits < maxsplit; ++splits) {
            int i2 = this.getString().lastIndexOf(sep, index - sepLength);
            if (i2 == index) {
                i2 -= sepLength;
            }
            if (i2 < 0) break;
            list.append(this.fromSubstring(i2 + sepLength, lastbreak));
            lastbreak = i2;
            index = i2;
        }
        list.append(this.fromSubstring(0, lastbreak));
        return list;
    }

    public PyList splitlines() {
        return this.str_splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        return this.str_splitlines(keepends);
    }

    final PyList str_splitlines(boolean keepends) {
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        int j2 = 0;
        int i2 = 0;
        while (i2 < n2) {
            while (i2 < n2 && chars[i2] != '\n' && chars[i2] != '\r' && Character.getType(chars[i2]) != 13) {
                ++i2;
            }
            int eol = i2;
            if (i2 < n2) {
                i2 = chars[i2] == '\r' && i2 + 1 < n2 && chars[i2 + 1] == '\n' ? (i2 += 2) : ++i2;
                if (keepends) {
                    eol = i2;
                }
            }
            list.append(this.fromSubstring(j2, eol));
            j2 = i2;
        }
        if (j2 < n2) {
            list.append(this.fromSubstring(j2, n2));
        }
        return list;
    }

    protected PyString fromSubstring(int begin, int end) {
        return this.createInstance(this.getString().substring(begin, end), true);
    }

    public int index(String sub) {
        return this.str_index(sub, 0, null);
    }

    public int index(String sub, int start) {
        return this.str_index(sub, start, null);
    }

    public int index(String sub, int start, int end) {
        return this.str_index(sub, start, Py.newInteger(end));
    }

    final int str_index(String sub, int start, PyObject end) {
        int index = this.str_find(sub, start, end);
        if (index == -1) {
            throw Py.ValueError("substring not found in string.index");
        }
        return index;
    }

    public int rindex(String sub) {
        return this.str_rindex(sub, 0, null);
    }

    public int rindex(String sub, int start) {
        return this.str_rindex(sub, start, null);
    }

    public int rindex(String sub, int start, int end) {
        return this.str_rindex(sub, start, Py.newInteger(end));
    }

    final int str_rindex(String sub, int start, PyObject end) {
        int index = this.str_rfind(sub, start, end);
        if (index == -1) {
            throw Py.ValueError("substring not found in string.rindex");
        }
        return index;
    }

    public int count(String sub) {
        return this.str_count(sub, 0, null);
    }

    public int count(String sub, int start) {
        return this.str_count(sub, start, null);
    }

    public int count(String sub, int start, int end) {
        return this.str_count(sub, start, Py.newInteger(end));
    }

    final int str_count(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int n2 = sub.length();
        if (n2 == 0) {
            if (start > this.getString().length()) {
                return 0;
            }
            return indices[1] - indices[0] + 1;
        }
        int count = 0;
        while (true) {
            int index = this.getString().indexOf(sub, indices[0]);
            indices[0] = index + n2;
            if (indices[0] > indices[1] || index == -1) break;
            ++count;
        }
        return count;
    }

    public int find(String sub) {
        return this.str_find(sub, 0, null);
    }

    public int find(String sub, int start) {
        return this.str_find(sub, start, null);
    }

    public int find(String sub, int start, int end) {
        return this.str_find(sub, start, Py.newInteger(end));
    }

    final int str_find(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int index = this.getString().indexOf(sub, indices[0]);
        if (index < start || index > indices[1]) {
            return -1;
        }
        return index;
    }

    public int rfind(String sub) {
        return this.str_rfind(sub, 0, null);
    }

    public int rfind(String sub, int start) {
        return this.str_rfind(sub, start, null);
    }

    public int rfind(String sub, int start, int end) {
        return this.str_rfind(sub, start, Py.newInteger(end));
    }

    final int str_rfind(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int index = this.getString().lastIndexOf(sub, indices[1] - sub.length());
        if (index < start) {
            return -1;
        }
        return index;
    }

    public double atof() {
        StringBuilder s2 = null;
        int n2 = this.getString().length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (ch2 == '\u0000') {
                throw Py.ValueError("null byte in argument for float()");
            }
            if (!Character.isDigit(ch2)) continue;
            if (s2 == null) {
                s2 = new StringBuilder(this.getString());
            }
            int val = Character.digit(ch2, 10);
            s2.setCharAt(i2, Character.forDigit(val, 10));
        }
        String sval = this.getString();
        if (s2 != null) {
            sval = s2.toString();
        }
        try {
            String lowSval = sval.toLowerCase();
            if (lowSval.equals("nan")) {
                return Double.NaN;
            }
            if (lowSval.equals("inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (lowSval.equals("-inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (lowSval.endsWith("d") || lowSval.endsWith("f")) {
                throw new NumberFormatException("format specifiers not allowed");
            }
            return Double.valueOf(sval);
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for __float__: " + this.getString());
        }
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int base2) {
        int b2;
        if (base2 != 0 && base2 < 2 || base2 > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        int e2 = this.getString().length();
        for (b2 = 0; b2 < e2 && Character.isWhitespace(this.getString().charAt(b2)); ++b2) {
        }
        while (e2 > b2 && Character.isWhitespace(this.getString().charAt(e2 - 1))) {
            --e2;
        }
        char sign = '\u0000';
        if (b2 < e2) {
            sign = this.getString().charAt(b2);
            if (sign == '-' || sign == '+') {
                ++b2;
                while (b2 < e2 && Character.isWhitespace(this.getString().charAt(b2))) {
                    ++b2;
                }
            }
            if ((base2 == 0 || base2 == 16) && this.getString().charAt(b2) == '0') {
                if (b2 < e2 - 1 && Character.toUpperCase(this.getString().charAt(b2 + 1)) == 'X') {
                    base2 = 16;
                    b2 += 2;
                } else if (base2 == 0) {
                    base2 = 8;
                }
            }
        }
        if (base2 == 0) {
            base2 = 10;
        }
        String s2 = this.getString();
        if (b2 > 0 || e2 < this.getString().length()) {
            s2 = this.getString().substring(b2, e2);
        }
        try {
            BigInteger bi2 = sign == '-' ? new BigInteger("-" + s2, base2) : new BigInteger(s2, base2);
            if (bi2.compareTo(PyInteger.MAX_INT) > 0 || bi2.compareTo(PyInteger.MIN_INT) < 0) {
                throw Py.OverflowError("long int too large to convert to int");
            }
            return bi2.intValue();
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base2 + ": " + this.getString());
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base2 + ": " + this.getString());
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int base2) {
        int b2;
        String str = this.getString();
        int e2 = str.length();
        for (b2 = 0; b2 < e2 && Character.isWhitespace(str.charAt(b2)); ++b2) {
        }
        while (e2 > b2 && Character.isWhitespace(str.charAt(e2 - 1))) {
            --e2;
        }
        char sign = '\u0000';
        if (b2 < e2) {
            sign = this.getString().charAt(b2);
            if (sign == '-' || sign == '+') {
                ++b2;
                while (b2 < e2 && Character.isWhitespace(str.charAt(b2))) {
                    ++b2;
                }
            }
            if ((base2 == 0 || base2 == 16) && this.getString().charAt(b2) == '0') {
                if (b2 < e2 - 1 && Character.toUpperCase(this.getString().charAt(b2 + 1)) == 'X') {
                    base2 = 16;
                    b2 += 2;
                } else if (base2 == 0) {
                    base2 = 8;
                }
            }
        }
        if (base2 == 0) {
            base2 = 10;
        }
        if (base2 < 2 || base2 > 36) {
            throw Py.ValueError("invalid base for long literal:" + base2);
        }
        if (base2 < 22 && e2 > b2 && (str.charAt(e2 - 1) == 'L' || str.charAt(e2 - 1) == 'l')) {
            --e2;
        }
        if (b2 > 0 || e2 < str.length()) {
            str = str.substring(b2, e2);
        }
        try {
            BigInteger bi2 = null;
            bi2 = sign == '-' ? new BigInteger("-" + str, base2) : new BigInteger(str, base2);
            return new PyLong(bi2);
        }
        catch (NumberFormatException exc) {
            if (this instanceof PyUnicode) {
                throw Py.UnicodeEncodeError("decimal", "codec can't encode character", 0, 0, "invalid decimal Unicode string");
            }
            throw Py.ValueError("invalid literal for long() with base " + base2 + ": " + this.getString());
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for long() with base " + base2 + ": " + this.getString());
        }
    }

    private static String padding(int n2, char pad) {
        char[] chars = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            chars[i2] = pad;
        }
        return new String(chars);
    }

    private static char parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return ' ';
        }
        if (fillchar.length() != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.charAt(0);
    }

    public String ljust(int width) {
        return this.str_ljust(width, null);
    }

    public String ljust(int width, String padding) {
        return this.str_ljust(width, padding);
    }

    final String str_ljust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("ljust", fillchar);
        int n2 = width - this.getString().length();
        if (n2 <= 0) {
            return this.getString();
        }
        return this.getString() + PyString.padding(n2, pad);
    }

    public String rjust(int width) {
        return this.str_rjust(width, null);
    }

    final String str_rjust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("rjust", fillchar);
        int n2 = width - this.getString().length();
        if (n2 <= 0) {
            return this.getString();
        }
        return PyString.padding(n2, pad) + this.getString();
    }

    public String center(int width) {
        return this.str_center(width, null);
    }

    final String str_center(int width, String fillchar) {
        char pad = PyString.parse_fillchar("center", fillchar);
        int n2 = width - this.getString().length();
        if (n2 <= 0) {
            return this.getString();
        }
        int half = n2 / 2;
        if (n2 % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        return PyString.padding(half, pad) + this.getString() + PyString.padding(n2 - half, pad);
    }

    public String zfill(int width) {
        return this.str_zfill(width);
    }

    final String str_zfill(int width) {
        char start;
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 >= width) {
            return s2;
        }
        char[] chars = new char[width];
        int nzeros = width - n2;
        int i2 = 0;
        int sStart = 0;
        if (n2 > 0 && ((start = s2.charAt(0)) == '+' || start == '-')) {
            chars[0] = start;
            ++i2;
            ++nzeros;
            sStart = 1;
        }
        while (i2 < nzeros) {
            chars[i2] = 48;
            ++i2;
        }
        s2.getChars(sStart, s2.length(), chars, i2);
        return new String(chars);
    }

    public String expandtabs() {
        return this.str_expandtabs(8);
    }

    public String expandtabs(int tabsize) {
        return this.str_expandtabs(tabsize);
    }

    final String str_expandtabs(int tabsize) {
        String s2 = this.getString();
        StringBuilder buf = new StringBuilder((int)((double)s2.length() * 1.5));
        char[] chars = s2.toCharArray();
        int n2 = chars.length;
        int position = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = chars[i2];
            if (c2 == '\t') {
                int spaces = tabsize - position % tabsize;
                position += spaces;
                while (spaces-- > 0) {
                    buf.append(' ');
                }
                continue;
            }
            if (c2 == '\n' || c2 == '\r') {
                position = -1;
            }
            buf.append(c2);
            ++position;
        }
        return buf.toString();
    }

    public String capitalize() {
        return this.str_capitalize();
    }

    final String str_capitalize() {
        if (this.getString().length() == 0) {
            return this.getString();
        }
        String first = this.getString().substring(0, 1).toUpperCase();
        return first.concat(this.getString().substring(1).toLowerCase());
    }

    final PyString str_replace(PyObject oldPiece, PyObject newPiece, PyObject maxsplit) {
        if (!(oldPiece instanceof PyString) || !(newPiece instanceof PyString)) {
            throw Py.TypeError("str or unicode required for replace");
        }
        return this.replace((PyString)oldPiece, (PyString)newPiece, maxsplit == null ? -1 : maxsplit.asInt());
    }

    protected PyString replace(PyString oldPiece, PyString newPiece, int maxsplit) {
        int len = this.getString().length();
        int old_len = oldPiece.getString().length();
        if (len == 0) {
            if (maxsplit == -1 && old_len == 0) {
                return this.createInstance(newPiece.getString(), true);
            }
            return this.createInstance(this.getString(), true);
        }
        if (old_len == 0 && newPiece.getString().length() != 0 && maxsplit != 0) {
            int i2;
            StringBuilder buffer = new StringBuilder();
            buffer.append(newPiece.getString());
            for (i2 = 0; i2 < len && (i2 < maxsplit - 1 || maxsplit == -1); ++i2) {
                buffer.append(this.getString().charAt(i2));
                buffer.append(newPiece.getString());
            }
            buffer.append(this.getString().substring(i2));
            return this.createInstance(buffer.toString(), true);
        }
        if (maxsplit == -1) {
            maxsplit = old_len == 0 ? len + 1 : len;
        }
        return newPiece.join(this.splitfields(oldPiece.getString(), maxsplit));
    }

    public PyString join(PyObject seq) {
        return this.str_join(seq);
    }

    final PyString str_join(PyObject obj) {
        int i2;
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return Py.EmptyString;
        }
        if (seqLen == 1 && ((item = seq.pyget(0)).getType() == TYPE || item.getType() == PyUnicode.TYPE)) {
            return (PyString)item;
        }
        long size = 0L;
        int sepLen = this.getString().length();
        for (i2 = 0; i2 < seqLen; ++i2) {
            item = seq.pyget(i2);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string, %.80s found", i2, item.getType().fastGetName()));
            }
            if (item instanceof PyUnicode) {
                return this.unicodeJoin(seq);
            }
            if (i2 != 0) {
                size += (long)sepLen;
            }
            if ((size += (long)((PyString)item).getString().length()) <= Integer.MAX_VALUE) continue;
            throw Py.OverflowError("join() result is too long for a Python string");
        }
        StringBuilder buf = new StringBuilder((int)size);
        for (i2 = 0; i2 < seqLen; ++i2) {
            item = seq.pyget(i2);
            if (i2 != 0) {
                buf.append(this.getString());
            }
            buf.append(((PyString)item).getString());
        }
        return new PyString(buf.toString());
    }

    /*
     * WARNING - void declaration
     */
    final PyUnicode unicodeJoin(PyObject obj) {
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return new PyUnicode();
        }
        if (seqLen == 1 && (item = seq.pyget(0)).getType() == PyUnicode.TYPE) {
            return (PyUnicode)item;
        }
        String sep = null;
        if (seqLen > 1) {
            if (this instanceof PyUnicode) {
                sep = this.getString();
            } else {
                sep = ((PyUnicode)this.decode()).getString();
                seqLen = seq.__len__();
            }
        }
        long size = 0L;
        int sepLen = this.getString().length();
        StringBuilder buf = new StringBuilder();
        int n2 = 0;
        while (n2 < seqLen) {
            void itemString;
            item = seq.pyget(n2);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string or Unicode, %.80s found", n2, item.getType().fastGetName()));
            }
            if (!(item instanceof PyUnicode)) {
                item = ((PyString)item).decode();
                seqLen = seq.__len__();
            }
            String i2 = ((PyUnicode)item).getString();
            if (itemString != false) {
                size += (long)sepLen;
                buf.append(sep);
            }
            if ((size += (long)i2.length()) > Integer.MAX_VALUE) {
                throw Py.OverflowError("join() result is too long for a Python string");
            }
            buf.append(i2);
            ++itemString;
        }
        return new PyUnicode(buf.toString());
    }

    public boolean startswith(PyObject prefix) {
        return this.str_startswith(prefix, 0, null);
    }

    public boolean startswith(PyObject prefix, int offset) {
        return this.str_startswith(prefix, offset, null);
    }

    public boolean startswith(PyObject prefix, int start, int end) {
        return this.str_startswith(prefix, start, Py.newInteger(end));
    }

    final boolean str_startswith(PyObject prefix, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        if (prefix instanceof PyString) {
            String strPrefix = ((PyString)prefix).getString();
            if (indices[1] - indices[0] < strPrefix.length()) {
                return false;
            }
            return this.getString().startsWith(strPrefix, indices[0]);
        }
        if (prefix instanceof PyTuple) {
            PyObject[] prefixes = ((PyTuple)prefix).getArray();
            for (int i2 = 0; i2 < prefixes.length; ++i2) {
                if (!(prefixes[i2] instanceof PyString)) {
                    throw Py.TypeError("expected a character buffer object");
                }
                String strPrefix = ((PyString)prefixes[i2]).getString();
                if (indices[1] - indices[0] < strPrefix.length() || !this.getString().startsWith(strPrefix, indices[0])) continue;
                return true;
            }
            return false;
        }
        throw Py.TypeError("expected a character buffer object or tuple");
    }

    public boolean endswith(PyObject suffix) {
        return this.str_endswith(suffix, 0, null);
    }

    public boolean endswith(PyObject suffix, int start) {
        return this.str_endswith(suffix, start, null);
    }

    public boolean endswith(PyObject suffix, int start, int end) {
        return this.str_endswith(suffix, start, Py.newInteger(end));
    }

    final boolean str_endswith(PyObject suffix, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        String substr = this.getString().substring(indices[0], indices[1]);
        if (suffix instanceof PyString) {
            return substr.endsWith(((PyString)suffix).getString());
        }
        if (suffix instanceof PyTuple) {
            PyObject[] suffixes = ((PyTuple)suffix).getArray();
            for (int i2 = 0; i2 < suffixes.length; ++i2) {
                if (!(suffixes[i2] instanceof PyString)) {
                    throw Py.TypeError("expected a character buffer object");
                }
                if (!substr.endsWith(((PyString)suffixes[i2]).getString())) continue;
                return true;
            }
            return false;
        }
        throw Py.TypeError("expected a character buffer object or tuple");
    }

    protected int[] translateIndices(int start, PyObject end) {
        int iEnd = end == null ? this.getString().length() : end.asInt();
        int n2 = this.getString().length();
        if (iEnd < 0) {
            if ((iEnd = n2 + iEnd) < 0) {
                iEnd = 0;
            }
        } else if (iEnd > n2) {
            iEnd = n2;
        }
        if (start < 0 && (start = n2 + start) < 0) {
            start = 0;
        }
        if (start > iEnd) {
            start = iEnd;
        }
        return new int[]{start, iEnd};
    }

    public String translate(String table) {
        return this.str_translate(table, null);
    }

    public String translate(String table, String deletechars) {
        return this.str_translate(table, deletechars);
    }

    final String str_translate(String table, String deletechars) {
        if (table.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuilder buf = new StringBuilder(this.getString().length());
        for (int i2 = 0; i2 < this.getString().length(); ++i2) {
            char c2 = this.getString().charAt(i2);
            if (deletechars != null && deletechars.indexOf(c2) >= 0) continue;
            try {
                buf.append(table.charAt(c2));
                continue;
            }
            catch (IndexOutOfBoundsException e2) {
                throw Py.TypeError("translate() only works for 8-bit character strings");
            }
        }
        return buf.toString();
    }

    public String translate(PyObject table) {
        StringBuilder v2 = new StringBuilder(this.getString().length());
        for (int i2 = 0; i2 < this.getString().length(); ++i2) {
            char ch2 = this.getString().charAt(i2);
            PyInteger w2 = Py.newInteger(ch2);
            PyObject x2 = table.__finditem__(w2);
            if (x2 == null) {
                v2.append(ch2);
                continue;
            }
            if (x2 instanceof PyInteger) {
                int value = ((PyInteger)x2).getValue();
                v2.append((char)value);
                continue;
            }
            if (x2 == Py.None) continue;
            if (x2 instanceof PyString) {
                if (x2.__len__() != 1) {
                    throw new PyException(Py.NotImplementedError, "1-n mappings are currently not implemented");
                }
                v2.append(x2.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return v2.toString();
    }

    public boolean islower() {
        return this.str_islower();
    }

    final boolean str_islower() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return Character.isLowerCase(this.getString().charAt(0));
        }
        boolean cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (Character.isUpperCase(ch2) || Character.isTitleCase(ch2)) {
                return false;
            }
            if (cased || !Character.isLowerCase(ch2)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isupper() {
        return this.str_isupper();
    }

    final boolean str_isupper() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return Character.isUpperCase(this.getString().charAt(0));
        }
        boolean cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (Character.isLowerCase(ch2) || Character.isTitleCase(ch2)) {
                return false;
            }
            if (cased || !Character.isUpperCase(ch2)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isalpha() {
        return this.str_isalpha();
    }

    final boolean str_isalpha() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return Character.isLetter(this.getString().charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (Character.isLetter(ch2)) continue;
            return false;
        }
        return true;
    }

    public boolean isalnum() {
        return this.str_isalnum();
    }

    final boolean str_isalnum() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return this._isalnum(this.getString().charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (this._isalnum(ch2)) continue;
            return false;
        }
        return true;
    }

    private boolean _isalnum(char ch2) {
        return Character.isLetterOrDigit(ch2) || Character.getType(ch2) == 10;
    }

    public boolean isdecimal() {
        return this.str_isdecimal();
    }

    final boolean str_isdecimal() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            char ch2 = this.getString().charAt(0);
            return this._isdecimal(ch2);
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch3 = this.getString().charAt(i2);
            if (this._isdecimal(ch3)) continue;
            return false;
        }
        return true;
    }

    private boolean _isdecimal(char ch2) {
        return Character.getType(ch2) == 9;
    }

    public boolean isdigit() {
        return this.str_isdigit();
    }

    final boolean str_isdigit() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return Character.isDigit(this.getString().charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (Character.isDigit(ch2)) continue;
            return false;
        }
        return true;
    }

    public boolean isnumeric() {
        return this.str_isnumeric();
    }

    final boolean str_isnumeric() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return this._isnumeric(this.getString().charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (this._isnumeric(ch2)) continue;
            return false;
        }
        return true;
    }

    private boolean _isnumeric(char ch2) {
        int type = Character.getType(ch2);
        return type == 9 || type == 10 || type == 11;
    }

    public boolean istitle() {
        return this.str_istitle();
    }

    final boolean str_istitle() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return Character.isTitleCase(this.getString().charAt(0)) || Character.isUpperCase(this.getString().charAt(0));
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (Character.isUpperCase(ch2) || Character.isTitleCase(ch2)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(ch2)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    public boolean isspace() {
        return this.str_isspace();
    }

    final boolean str_isspace() {
        int n2 = this.getString().length();
        if (n2 == 1) {
            return Character.isWhitespace(this.getString().charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (Character.isWhitespace(ch2)) continue;
            return false;
        }
        return true;
    }

    public boolean isunicode() {
        return this.str_isunicode();
    }

    final boolean str_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        int n2 = this.getString().length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch2 = this.getString().charAt(i2);
            if (ch2 <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public String encode() {
        return this.str_encode(null, null);
    }

    public String encode(String encoding) {
        return this.str_encode(encoding, null);
    }

    public String encode(String encoding, String errors2) {
        return this.str_encode(encoding, errors2);
    }

    final String str_encode(String encoding, String errors2) {
        return codecs.encode(this, encoding, errors2);
    }

    public PyObject decode() {
        return this.str_decode(null, null);
    }

    public PyObject decode(String encoding) {
        return this.str_decode(encoding, null);
    }

    public PyObject decode(String encoding, String errors2) {
        return this.str_decode(encoding, errors2);
    }

    final PyObject str_decode(String encoding, String errors2) {
        return codecs.decode(this, encoding, errors2);
    }

    @Override
    public String asString(int index) throws PyObject.ConversionException {
        return this.getString();
    }

    @Override
    public String asString() {
        return this.getString();
    }

    @Override
    public int asInt() {
        this.asNumberCheck("__int__", "an integer");
        return super.asInt();
    }

    @Override
    public long asLong() {
        this.asNumberCheck("__long__", "an integer");
        return super.asLong();
    }

    @Override
    public double asDouble() {
        this.asNumberCheck("__float__", "a float");
        return super.asDouble();
    }

    private void asNumberCheck(String methodName, String description) {
        PyType type = this.getType();
        if (type == TYPE || type == PyUnicode.TYPE || type.lookup(methodName) == null) {
            throw Py.TypeError(description + " is required");
        }
    }

    @Override
    public String asName(int index) throws PyObject.ConversionException {
        return this.internedString();
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "cannot concatenate ''{1}'' and ''{2}'' objects";
        }
        return super.unsupportedopMessage(op, o2);
    }

    static {
        PyType.addBuilder(PyString.class, new PyString$PyExposer());
        TYPE = PyType.fromClass(PyString.class);
        hexdigit = "0123456789abcdef".toCharArray();
        pucnHash = null;
    }
}

