/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyJavaType;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.core.PyType;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.core.ThreadState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyReflectedConstructor
extends PyReflectedFunction {
    public PyReflectedConstructor(String name) {
        super(name);
    }

    public PyReflectedConstructor(Constructor<?> c2) {
        this(c2.getDeclaringClass().getName());
        this.addConstructor(c2);
    }

    private ReflectedArgs makeArgs(Constructor<?> m2) {
        return new ReflectedArgs(m2, m2.getParameterTypes(), m2.getDeclaringClass(), true);
    }

    public void addConstructor(Constructor<?> m2) {
        int mods = m2.getModifiers();
        if (!Modifier.isPublic(mods) && Options.respectJavaAccessibility) {
            return;
        }
        this.addArgs(this.makeArgs(m2));
    }

    PyObject make(PyObject[] args, String[] keywords) {
        PyObject obj;
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        boolean consumes_keywords = false;
        PyObject[] allArgs = null;
        if (this.nargs > 0) {
            if (this.argslist[0].matches(null, args, keywords, callData)) {
                method = this.argslist[0].data;
                consumes_keywords = this.argslist[0].flags == 2;
            } else {
                allArgs = args;
                int i2 = 1;
                if (keywords.length > 0) {
                    args = new PyObject[allArgs.length - keywords.length];
                    System.arraycopy(allArgs, 0, args, 0, args.length);
                    i2 = 0;
                }
                while (i2 < this.nargs) {
                    if (this.argslist[i2].matches(null, args, Py.NoKeywords, callData)) {
                        method = this.argslist[i2].data;
                        break;
                    }
                    ++i2;
                }
            }
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, true, false);
        }
        try {
            obj = (PyObject)((Constructor)method).newInstance(callData.getArgsArray());
        }
        catch (Throwable t2) {
            throw Py.JavaError(t2);
        }
        if (!consumes_keywords) {
            int offset = args.length;
            for (int i3 = 0; i3 < keywords.length; ++i3) {
                obj.__setattr__(keywords[i3], allArgs[i3 + offset]);
            }
        }
        return obj;
    }

    @Override
    public PyObject __call__(PyObject self, PyObject[] args, String[] keywords) {
        int i2;
        int n2;
        Class<?> declaringClass;
        if (self == null) {
            throw Py.TypeError("invalid self argument to constructor");
        }
        Class<?> javaClass = self.getType().getProxyType();
        if (javaClass == null) {
            throw Py.TypeError("self invalid - must be a Java subclass [self=" + self + "]");
        }
        Class<?> clazz = declaringClass = this.argslist[0] == null ? null : this.argslist[0].declaringClass;
        if (!(declaringClass != null && PyProxy.class.isAssignableFrom(declaringClass) || self.getType() instanceof PyJavaType)) {
            return PyType.fromClass(javaClass).lookup("__init__").__call__(self, args, keywords);
        }
        if (this.nargs == 0) {
            throw Py.TypeError("No visible constructors for class (" + javaClass.getName() + ")");
        }
        if (!declaringClass.isAssignableFrom(javaClass)) {
            throw Py.TypeError("self invalid - must implement: " + declaringClass.getName());
        }
        int mods = declaringClass.getModifiers();
        if (Modifier.isInterface(mods)) {
            throw Py.TypeError("can't instantiate interface (" + declaringClass.getName() + ")");
        }
        if (Modifier.isAbstract(mods)) {
            throw Py.TypeError("can't instantiate abstract class (" + declaringClass.getName() + ")");
        }
        if (self.javaProxy != null) {
            Class<?> sup = javaClass;
            if (PyProxy.class.isAssignableFrom(sup)) {
                sup = sup.getSuperclass();
            }
            throw Py.TypeError("instance already instantiated for " + sup.getName());
        }
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        int nkeywords = keywords.length;
        ReflectedArgs rargs = null;
        PyObject[] allArgs = args;
        boolean usingKeywordArgsCtor = false;
        if (nkeywords > 0) {
            n2 = this.nargs;
            for (i2 = 0; i2 < n2; ++i2) {
                rargs = this.argslist[i2];
                if (!rargs.matches(null, args, keywords, callData)) continue;
                method = rargs.data;
                break;
            }
            if (method != null) {
                usingKeywordArgsCtor = true;
            } else {
                args = new PyObject[allArgs.length - nkeywords];
                System.arraycopy(allArgs, 0, args, 0, args.length);
                for (i2 = 0; i2 < n2; ++i2) {
                    rargs = this.argslist[i2];
                    if (!rargs.matches(null, args, Py.NoKeywords, callData)) continue;
                    method = rargs.data;
                    break;
                }
            }
        } else {
            n2 = this.nargs;
            for (i2 = 0; i2 < n2; ++i2) {
                rargs = this.argslist[i2];
                if (!rargs.matches(null, args, Py.NoKeywords, callData)) continue;
                method = rargs.data;
                break;
            }
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, false, false);
        }
        this.constructProxy(self, (Constructor)method, callData.getArgsArray(), javaClass);
        if (!usingKeywordArgsCtor) {
            int offset = args.length;
            for (i2 = 0; i2 < nkeywords; ++i2) {
                self.__setattr__(keywords[i2], allArgs[i2 + offset]);
            }
        }
        return Py.None;
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        if (args.length < 1) {
            throw Py.TypeError("constructor requires self argument");
        }
        PyObject[] newArgs = new PyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return this.__call__(args[0], newArgs, keywords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constructProxy(PyObject obj, Constructor<?> ctor, Object[] args, Class<?> proxy) {
        Object jself = null;
        ThreadState ts = Py.getThreadState();
        try {
            ts.pushInitializingProxy(obj);
            try {
                jself = ctor.newInstance(args);
            }
            catch (InvocationTargetException e2) {
                if (e2.getTargetException() instanceof InstantiationException) {
                    Class<?> sup = proxy.getSuperclass();
                    String msg = "Constructor failed for Java superclass";
                    if (sup != null) {
                        msg = msg + " " + sup.getName();
                    }
                    throw Py.TypeError(msg);
                }
                throw Py.JavaError(e2);
            }
            catch (Throwable t2) {
                throw Py.JavaError(t2);
            }
        }
        finally {
            ts.popInitializingProxy();
        }
        obj.javaProxy = jself;
    }

    @Override
    public PyObject _doget(PyObject container, PyObject wherefound) {
        if (container == null) {
            return this;
        }
        return new PyMethod(this, container, wherefound);
    }

    @Override
    public String toString() {
        return "<java constructor " + this.__name__ + " " + Py.idstr(this) + ">";
    }
}

