/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.CodeFlag;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyCell;
import org.python.core.PyException;
import org.python.core.PyFrame$PyExposer;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PythonTraceFunction;
import org.python.core.TraceFunction;
import org.python.expose.ExposedType;

@ExposedType(name="frame", isBaseType=false)
public class PyFrame
extends PyObject {
    public static final PyType TYPE;
    public PyFrame f_back;
    public PyBaseCode f_code;
    public PyObject f_builtins;
    public PyObject f_globals;
    public PyObject f_locals;
    public int f_lineno;
    public PyObject[] f_fastlocals;
    public PyCell[] f_env;
    private int env_j = 0;
    public int f_ncells;
    public int f_nfreevars;
    public int f_lasti;
    public Object[] f_savedlocals;
    private Object generatorInput = Py.None;
    public PyObject[] f_exits;
    public TraceFunction tracefunc;
    private static final String NAME_ERROR_MSG = "name '%.200s' is not defined";
    private static final String GLOBAL_NAME_ERROR_MSG = "global name '%.200s' is not defined";
    private static final String UNBOUNDLOCAL_ERROR_MSG = "local variable '%.200s' referenced before assignment";

    public PyFrame(PyBaseCode code2, PyObject locals, PyObject globals, PyObject builtins) {
        super(TYPE);
        this.f_code = code2;
        this.f_locals = locals;
        this.f_globals = globals;
        this.f_builtins = builtins;
        if (locals == null && code2 != null) {
            if (code2.co_flags.isFlagSet(CodeFlag.CO_OPTIMIZED) || code2.nargs > 0) {
                if (code2.co_nlocals > 0) {
                    this.f_fastlocals = new PyObject[code2.co_nlocals - code2.jy_npurecell];
                }
            } else {
                this.f_locals = new PyStringMap();
            }
        }
        if (code2 != null) {
            int env_sz = 0;
            if (code2.co_freevars != null) {
                this.f_nfreevars = code2.co_freevars.length;
                env_sz += this.f_nfreevars;
            }
            if (code2.co_cellvars != null) {
                this.f_ncells = code2.co_cellvars.length;
                env_sz += this.f_ncells;
            }
            if (env_sz > 0) {
                this.f_env = new PyCell[env_sz];
            }
        }
    }

    public PyFrame(PyBaseCode code2, PyObject globals) {
        this(code2, null, globals, null);
    }

    void setupEnv(PyTuple freevars) {
        int ntotal = this.f_ncells + this.f_nfreevars;
        while (this.env_j < this.f_ncells) {
            this.f_env[this.env_j] = new PyCell();
            ++this.env_j;
        }
        int i2 = 0;
        while (this.env_j < ntotal) {
            this.f_env[this.env_j] = (PyCell)freevars.pyget(i2);
            ++i2;
            ++this.env_j;
        }
    }

    void setGeneratorInput(Object value) {
        this.generatorInput = value;
    }

    public Object getGeneratorInput() {
        Object input = this.generatorInput;
        this.generatorInput = Py.None;
        return input;
    }

    public Object checkGeneratorInput() {
        return this.generatorInput;
    }

    public PyObject getLocals() {
        if (this.f_locals == null) {
            this.f_locals = new PyStringMap();
        }
        if (this.f_code != null && (this.f_code.co_nlocals > 0 || this.f_nfreevars > 0)) {
            PyObject v2;
            int i2;
            if (this.f_fastlocals != null) {
                for (i2 = 0; i2 < this.f_fastlocals.length; ++i2) {
                    PyObject o2 = this.f_fastlocals[i2];
                    if (o2 == null) continue;
                    this.f_locals.__setitem__(this.f_code.co_varnames[i2], o2);
                }
                if (!this.f_code.co_flags.isFlagSet(CodeFlag.CO_OPTIMIZED)) {
                    this.f_fastlocals = null;
                }
            }
            int j2 = 0;
            i2 = 0;
            while (i2 < this.f_ncells) {
                v2 = this.f_env[j2].ob_ref;
                if (v2 != null) {
                    this.f_locals.__setitem__(this.f_code.co_cellvars[i2], v2);
                }
                ++i2;
                ++j2;
            }
            i2 = 0;
            while (i2 < this.f_nfreevars) {
                v2 = this.f_env[j2].ob_ref;
                if (v2 != null) {
                    this.f_locals.__setitem__(this.f_code.co_freevars[i2], v2);
                }
                ++i2;
                ++j2;
            }
        }
        return this.f_locals;
    }

    public PyObject getTrace() {
        return this.tracefunc instanceof PythonTraceFunction ? ((PythonTraceFunction)this.tracefunc).tracefunc : Py.None;
    }

    public void setTrace(PyObject trace2) {
        this.tracefunc = new PythonTraceFunction(trace2);
    }

    public void delTrace() {
        this.tracefunc = null;
    }

    public PyObject getf_locals() {
        return this.f_locals;
    }

    public void setline(int line) {
        this.f_lineno = line;
        if (this.tracefunc != null) {
            this.tracefunc = this.tracefunc.traceLine(this, line);
        }
    }

    public int getline() {
        return this.tracefunc != null ? this.f_lineno : this.f_code.getline(this);
    }

    public PyObject getlocal(int index) {
        PyObject ret;
        PyObject ret2;
        if (this.f_fastlocals != null && (ret2 = this.f_fastlocals[index]) != null) {
            return ret2;
        }
        String name = this.f_code.co_varnames[index];
        if (this.f_locals != null && (ret = this.f_locals.__finditem__(name)) != null) {
            return ret;
        }
        throw Py.UnboundLocalError(String.format(UNBOUNDLOCAL_ERROR_MSG, name));
    }

    public PyObject getname(String index) {
        PyObject ret;
        if (this.f_locals == null || this.f_locals == this.f_globals) {
            ret = this.doGetglobal(index);
        } else {
            ret = this.f_locals.__finditem__(index);
            if (ret != null) {
                return ret;
            }
            ret = this.doGetglobal(index);
        }
        if (ret != null) {
            return ret;
        }
        throw Py.NameError(String.format(NAME_ERROR_MSG, index));
    }

    public PyObject getglobal(String index) {
        PyObject ret = this.doGetglobal(index);
        if (ret != null) {
            return ret;
        }
        throw Py.NameError(String.format(GLOBAL_NAME_ERROR_MSG, index));
    }

    private PyObject doGetglobal(String index) {
        PyObject ret = this.f_globals.__finditem__(index);
        if (ret != null) {
            return ret;
        }
        if (this.f_builtins == null) {
            this.f_builtins = PySystemState.builtins;
        }
        return this.f_builtins.__finditem__(index);
    }

    public void setlocal(int index, PyObject value) {
        if (this.f_fastlocals != null) {
            this.f_fastlocals[index] = value;
        } else {
            this.setlocal(this.f_code.co_varnames[index], value);
        }
    }

    public void setlocal(String index, PyObject value) {
        if (this.f_locals == null) {
            throw Py.SystemError(String.format("no locals found when storing '%s'", value));
        }
        this.f_locals.__setitem__(index, value);
    }

    public void setglobal(String index, PyObject value) {
        this.f_globals.__setitem__(index, value);
    }

    public void dellocal(int index) {
        if (this.f_fastlocals != null) {
            if (this.f_fastlocals[index] == null) {
                throw Py.UnboundLocalError(String.format(UNBOUNDLOCAL_ERROR_MSG, this.f_code.co_varnames[index]));
            }
            this.f_fastlocals[index] = null;
        } else {
            this.dellocal(this.f_code.co_varnames[index]);
        }
    }

    public void dellocal(String index) {
        if (this.f_locals != null) {
            try {
                this.f_locals.__delitem__(index);
            }
            catch (PyException pye) {
                if (pye.match(Py.KeyError)) {
                    throw Py.NameError(String.format(NAME_ERROR_MSG, index));
                }
                throw pye;
            }
        } else {
            throw Py.SystemError(String.format("no locals when deleting '%s'", index));
        }
    }

    public void delglobal(String index) {
        try {
            this.f_globals.__delitem__(index);
        }
        catch (PyException pye) {
            if (pye.match(Py.KeyError)) {
                throw Py.NameError(String.format(GLOBAL_NAME_ERROR_MSG, index));
            }
            throw pye;
        }
    }

    public PyObject getclosure(int index) {
        return this.f_env[index];
    }

    public PyObject getderef(int index) {
        PyObject obj = this.f_env[index].ob_ref;
        if (obj != null) {
            return obj;
        }
        String name = index >= this.f_ncells ? this.f_code.co_freevars[index - this.f_ncells] : this.f_code.co_cellvars[index];
        throw Py.UnboundLocalError(String.format(UNBOUNDLOCAL_ERROR_MSG, name));
    }

    public void setderef(int index, PyObject value) {
        this.f_env[index].ob_ref = value;
    }

    public void to_cell(int parm_index, int env_index) {
        this.f_env[env_index].ob_ref = this.f_fastlocals[parm_index];
    }

    static {
        PyType.addBuilder(PyFrame.class, new PyFrame$PyExposer());
        TYPE = PyType.fromClass(PyFrame.class);
    }
}

