/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBaseException;
import org.python.core.PyClass;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyInstance;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.__builtin__;

public class PyException
extends RuntimeException {
    public PyObject type;
    public PyObject value = Py.None;
    public PyTraceback traceback;
    private boolean isReRaise = false;
    private boolean normalized = false;
    private boolean printingStackTrace = false;

    public PyException() {
        this(Py.None, Py.None);
    }

    public PyException(PyObject type) {
        this(type, Py.None);
    }

    public PyException(PyObject type, PyObject value) {
        this(type, value, null);
    }

    public PyException(PyObject type, PyObject value, PyTraceback traceback2) {
        this.type = type;
        this.value = value;
        if (traceback2 != null) {
            this.traceback = traceback2;
            this.isReRaise = true;
        } else {
            PyFrame frame = Py.getFrame();
            if (frame != null && frame.tracefunc != null) {
                frame.tracefunc = frame.tracefunc.traceException(frame, this);
            }
        }
    }

    public PyException(PyObject type, String value) {
        this(type, new PyString(value));
    }

    public void printStackTrace() {
        Py.printException(this);
    }

    public Throwable fillInStackTrace() {
        return Options.includeJavaStackInExceptions ? super.fillInStackTrace() : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintStream s2) {
        if (this.printingStackTrace) {
            super.printStackTrace(s2);
        } else {
            try {
                this.printingStackTrace = true;
                Py.displayException(this.type, this.value, this.traceback, new PyFile(s2));
            }
            finally {
                this.printingStackTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void super__printStackTrace(PrintWriter w2) {
        try {
            this.printingStackTrace = true;
            super.printStackTrace(w2);
        }
        finally {
            this.printingStackTrace = false;
        }
    }

    public synchronized String toString() {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (!this.printingStackTrace) {
            this.printStackTrace(new PrintStream(buf));
        }
        return buf.toString();
    }

    public void normalize() {
        if (this.normalized) {
            return;
        }
        PyObject inClass = null;
        if (PyException.isExceptionInstance(this.value)) {
            inClass = this.value.fastGetClass();
        }
        if (PyException.isExceptionClass(this.type)) {
            if (inClass == null || !Py.isSubClass(inClass, this.type)) {
                PyObject[] args = this.value == Py.None ? Py.EmptyObjects : (this.value instanceof PyTuple && this.type != Py.KeyError ? ((PyTuple)this.value).getArray() : new PyObject[]{this.value});
                this.value = this.type.__call__(args);
            } else if (inClass != this.type) {
                this.type = inClass;
            }
        }
        this.normalized = true;
    }

    public void tracebackHere(PyFrame here) {
        this.tracebackHere(here, false);
    }

    public void tracebackHere(PyFrame here, boolean isFinally) {
        if (!this.isReRaise && here != null) {
            this.traceback = new PyTraceback(this.traceback, here);
        }
        this.isReRaise = isFinally;
    }

    public static PyException doRaise(PyObject type, PyObject value, PyObject traceback2) {
        if (type == null) {
            ThreadState state = Py.getThreadState();
            type = state.exception.type;
            value = state.exception.value;
            traceback2 = state.exception.traceback;
        }
        if (traceback2 == Py.None) {
            traceback2 = null;
        } else if (traceback2 != null && !(traceback2 instanceof PyTraceback)) {
            throw Py.TypeError("raise: arg 3 must be a traceback or None");
        }
        if (value == null) {
            value = Py.None;
        }
        while (type instanceof PyTuple && ((PyTuple)type).size() > 0) {
            type = type.__getitem__(0);
        }
        if (type.getType() == PyString.TYPE) {
            Py.warning(Py.DeprecationWarning, "raising a string exception is deprecated");
        } else {
            if (PyException.isExceptionClass(type)) {
                PyException pye = new PyException(type, value, (PyTraceback)traceback2);
                pye.normalize();
                return pye;
            }
            if (PyException.isExceptionInstance(type)) {
                if (value != Py.None) {
                    throw Py.TypeError("instance exception may not have a separate value");
                }
                value = type;
                type = type.fastGetClass();
            } else {
                throw Py.TypeError("exceptions must be classes, instances, or strings (deprecated), not " + type.getType().fastGetName());
            }
        }
        return new PyException(type, value, (PyTraceback)traceback2);
    }

    public boolean match(PyObject exc) {
        if (exc instanceof PyTuple) {
            for (PyObject item : ((PyTuple)exc).getArray()) {
                if (!this.match(item)) continue;
                return true;
            }
            return false;
        }
        this.normalize();
        if (exc == Py.IOError && __builtin__.isinstance(this.value, PyType.fromClass(IOException.class))) {
            return true;
        }
        if (exc == Py.MemoryError && __builtin__.isinstance(this.value, PyType.fromClass(OutOfMemoryError.class))) {
            return true;
        }
        if (PyException.isExceptionClass(this.type) && PyException.isExceptionClass(exc)) {
            return Py.isSubClass(this.type, exc);
        }
        return this.type == exc;
    }

    public static boolean isExceptionClass(PyObject obj) {
        if (obj instanceof PyClass) {
            return true;
        }
        if (!(obj instanceof PyType)) {
            return false;
        }
        PyType type = (PyType)obj;
        if (type.isSubType(PyBaseException.TYPE)) {
            return true;
        }
        return type.getProxyType() != null && Throwable.class.isAssignableFrom(type.getProxyType());
    }

    public static boolean isExceptionInstance(PyObject obj) {
        return obj instanceof PyInstance || obj instanceof PyBaseException || obj.getJavaProxy() instanceof Throwable;
    }

    public static String exceptionClassName(PyObject obj) {
        return obj instanceof PyClass ? ((PyClass)obj).__name__ : ((PyType)obj).fastGetName();
    }
}

