/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.python.core.PyObject;
import org.python.util.Generic;

public class IdImpl {
    private WeakIdentityMap idMap = new WeakIdentityMap();
    private long sequentialId;

    public synchronized long id(PyObject o2) {
        Object javaProxy = o2.getJavaProxy();
        if (javaProxy != null) {
            return this.java_obj_id(javaProxy);
        }
        return this.java_obj_id(o2);
    }

    public String idstr(PyObject o2) {
        return String.format("0x%x", this.id(o2));
    }

    public synchronized long java_obj_id(Object o2) {
        Long cand = (Long)this.idMap.get(o2);
        if (cand == null) {
            long new_id = ++this.sequentialId;
            this.idMap.put(o2, new_id);
            return new_id;
        }
        return cand;
    }

    public static class WeakIdentityMap {
        private transient ReferenceQueue<Object> idKeys = new ReferenceQueue();
        private Map<WeakIdKey, Object> objHashcodeToPyId = Generic.map();

        private void cleanup() {
            Reference<Object> k2;
            while ((k2 = this.idKeys.poll()) != null) {
                this.objHashcodeToPyId.remove(k2);
            }
        }

        public int _internal_map_size() {
            return this.objHashcodeToPyId.size();
        }

        public void put(Object key, Object val) {
            this.cleanup();
            this.objHashcodeToPyId.put(new WeakIdKey(key), val);
        }

        public Object get(Object key) {
            this.cleanup();
            return this.objHashcodeToPyId.get(new WeakIdKey(key));
        }

        public void remove(Object key) {
            this.cleanup();
            this.objHashcodeToPyId.remove(new WeakIdKey(key));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WeakIdKey
        extends WeakReference<Object> {
            private final int hashcode;

            WeakIdKey(Object obj) {
                super(obj, WeakIdentityMap.this.idKeys);
                this.hashcode = System.identityHashCode(obj);
            }

            public int hashCode() {
                return this.hashcode;
            }

            public boolean equals(Object other) {
                Object obj = this.get();
                if (obj != null) {
                    return obj == ((WeakIdKey)other).get();
                }
                return this == other;
            }
        }
    }
}

