/*
 * Decompiled with CFR 0.152.
 */
package org.python.constantine;

import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.python.constantine.Constant;
import org.python.constantine.Platform;
import org.python.constantine.platform.Errno;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantSet
extends AbstractSet<Constant> {
    private final ConcurrentMap<String, Constant> nameToConstant;
    private final ConcurrentMap<Integer, Constant> valueToConstant;
    private final Set<Constant> constants;
    private final Class<Enum> enumClass;
    private volatile Long minValue;
    private volatile Long maxValue;
    private static final ConcurrentMap<String, ConstantSet> constantSets = new ConcurrentHashMap<String, ConstantSet>();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantSet getConstantSet(String name) {
        ConstantSet constants = (ConstantSet)constantSets.get(name);
        if (constants == null) {
            Object object = lock;
            synchronized (object) {
                if (!constantSets.containsKey(name)) {
                    Class<Enum> enumClass = ConstantSet.getEnumClass(name);
                    if (enumClass == null) {
                        return null;
                    }
                    if (!Constant.class.isAssignableFrom(enumClass)) {
                        throw new ClassCastException("class for " + name + " does not implement Constant interface");
                    }
                    constants = new ConstantSet(enumClass);
                    constantSets.put(name, constants);
                }
            }
        }
        return constants;
    }

    private static final Class<Enum> getEnumClass(String name) {
        String[] prefixes;
        for (String prefix : prefixes = new String[]{Platform.getPlatform().getPackageName(), Platform.getPlatform().getOSPackageName(), Platform.class.getPackage().getName() + ".platform.fake"}) {
            try {
                return Class.forName(prefix + "." + name).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    private ConstantSet(Class<Enum> enumClass) {
        this.enumClass = enumClass;
        this.nameToConstant = new ConcurrentHashMap<String, Constant>();
        this.valueToConstant = new ConcurrentHashMap<Integer, Constant>();
        this.constants = EnumSet.allOf(enumClass);
    }

    public Constant getConstant(String name) {
        Constant c2 = (Constant)this.nameToConstant.get(name);
        if (c2 == null) {
            try {
                c2 = (Constant)Constant.class.cast(Enum.valueOf(this.enumClass, name));
                this.nameToConstant.put(name, c2);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return c2;
    }

    public Constant getConstant(int value) {
        Constant c2 = (Constant)this.valueToConstant.get(value);
        if (c2 == null && c2 == null) {
            for (Constant c22 : this.constants) {
                if (c22.value() != value) continue;
                c2 = c22;
                break;
            }
            if (c2 != null) {
                this.valueToConstant.put(value, c2);
            }
        }
        return c2;
    }

    public int getValue(String name) {
        Constant c2 = this.getConstant(name);
        return c2 != null ? c2.value() : 0;
    }

    public String getName(int value) {
        Constant c2 = this.getConstant(value);
        return c2 != null ? c2.name() : "unknown";
    }

    private Long getLongField(String name, long defaultValue) {
        try {
            Field f2 = this.enumClass.getField("MIN_VALUE");
            return (Long)f2.get(this.enumClass);
        }
        catch (NoSuchFieldException ex) {
            return defaultValue;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long minValue() {
        if (this.minValue == null) {
            this.minValue = this.getLongField("MIN_VALUE", Integer.MIN_VALUE);
        }
        return this.minValue.intValue();
    }

    public long maxValue() {
        if (this.maxValue == null) {
            this.maxValue = this.getLongField("MAX_VALUE", Integer.MAX_VALUE);
        }
        return this.maxValue.intValue();
    }

    @Override
    public Iterator<Constant> iterator() {
        return new ConstantIterator(this.constants);
    }

    @Override
    public int size() {
        return this.constants.size();
    }

    @Override
    public boolean contains(Object o2) {
        return o2 != null && o2.getClass().equals(this.enumClass);
    }

    public static void main(String[] args) {
        ConstantSet errnos = ConstantSet.getConstantSet("Errno");
        for (Constant c2 : errnos) {
            System.out.println(c2.name() + "=" + c2.value());
        }
        Errno errno2 = Errno.valueOf(22);
        System.out.println("errno for 22=" + errno2);
        System.out.println("errno for 101=" + Errno.valueOf(101));
        System.out.println("errno for 22=" + Errno.valueOf(22));
        System.out.println("EINVAL.value() = " + Errno.EINVAL.value());
        System.out.println("E2BIG.value() = " + Errno.E2BIG.value());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConstantIterator
    implements Iterator<Constant> {
        private final Iterator<Constant> it;

        ConstantIterator(Collection<Constant> constants) {
            this.it = constants.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Constant next() {
            return this.it.next();
        }
    }
}

