/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.python.compiler.Code;
import org.python.core.imp;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.ClassWriter;
import org.python.objectweb.asm.FieldVisitor;
import org.python.objectweb.asm.MethodVisitor;

public class ClassFile {
    ClassWriter cw;
    int access;
    long mtime;
    public String name;
    String superclass;
    String sfilename;
    String[] interfaces;
    List<MethodVisitor> methodVisitors;
    List<FieldVisitor> fieldVisitors;

    public static String fixName(String n2) {
        if (n2.indexOf(46) == -1) {
            return n2;
        }
        char[] c2 = n2.toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (c2[i2] != '.') continue;
            c2[i2] = 47;
        }
        return new String(c2);
    }

    public ClassFile(String name) {
        this(name, "java/lang/Object", 33, -1L);
    }

    public ClassFile(String name, String superclass, int access) {
        this(name, superclass, access, -1L);
    }

    public ClassFile(String name, String superclass, int access, long mtime) {
        this.name = ClassFile.fixName(name);
        this.superclass = ClassFile.fixName(superclass);
        this.interfaces = new String[0];
        this.access = access;
        this.mtime = mtime;
        this.cw = new ClassWriter(2);
        this.methodVisitors = Collections.synchronizedList(new ArrayList());
        this.fieldVisitors = Collections.synchronizedList(new ArrayList());
    }

    public void setSource(String name) {
        this.sfilename = name;
    }

    public void addInterface(String name) throws IOException {
        String[] new_interfaces = new String[this.interfaces.length + 1];
        System.arraycopy(this.interfaces, 0, new_interfaces, 0, this.interfaces.length);
        new_interfaces[this.interfaces.length] = name;
        this.interfaces = new_interfaces;
    }

    public Code addMethod(String name, String type, int access) throws IOException {
        MethodVisitor mv = this.cw.visitMethod(access, name, type, null, null);
        Code pmv = new Code(mv, type, access);
        this.methodVisitors.add(pmv);
        return pmv;
    }

    public void addField(String name, String type, int access) throws IOException {
        FieldVisitor fv = this.cw.visitField(access, name, type, null, null);
        this.fieldVisitors.add(fv);
    }

    public void endFields() throws IOException {
        for (FieldVisitor fv : this.fieldVisitors) {
            fv.visitEnd();
        }
    }

    public void endMethods() throws IOException {
        for (int i2 = 0; i2 < this.methodVisitors.size(); ++i2) {
            MethodVisitor mv = this.methodVisitors.get(i2);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    public void write(OutputStream stream) throws IOException {
        this.cw.visit(49, 33, this.name, null, this.superclass, this.interfaces);
        AnnotationVisitor av2 = this.cw.visitAnnotation("Lorg/python/compiler/APIVersion;", true);
        av2.visit("value", new Integer(imp.getAPIVersion()));
        av2.visitEnd();
        av2 = this.cw.visitAnnotation("Lorg/python/compiler/MTime;", true);
        av2.visit("value", new Long(this.mtime));
        av2.visitEnd();
        if (this.sfilename != null) {
            this.cw.visitSource(this.sfilename, null);
        }
        this.endFields();
        this.endMethods();
        byte[] ba2 = this.cw.toByteArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(ba2.length);
        baos.write(ba2, 0, ba2.length);
        baos.writeTo(stream);
        baos.close();
    }
}

