/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.xinclude;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import org.python.apache.xerces.impl.XMLEntityManager;
import org.python.apache.xerces.impl.XMLErrorReporter;
import org.python.apache.xerces.impl.io.ASCIIReader;
import org.python.apache.xerces.impl.io.Latin1Reader;
import org.python.apache.xerces.impl.io.UTF8Reader;
import org.python.apache.xerces.util.EncodingMap;
import org.python.apache.xerces.util.HTTPInputSource;
import org.python.apache.xerces.util.XMLChar;
import org.python.apache.xerces.xinclude.XIncludeHandler;
import org.python.apache.xerces.xni.XMLString;
import org.python.apache.xerces.xni.parser.XMLInputSource;

public class XIncludeTextReader {
    private Reader fReader;
    private final XIncludeHandler fHandler;
    private XMLInputSource fSource;
    private XMLErrorReporter fErrorReporter;
    private XMLString fTempString = new XMLString();

    public XIncludeTextReader(XMLInputSource xMLInputSource, XIncludeHandler xIncludeHandler, int n2) throws IOException {
        this.fHandler = xIncludeHandler;
        this.fSource = xMLInputSource;
        this.fTempString = new XMLString(new char[n2 + 1], 0, 0);
    }

    public void setErrorReporter(XMLErrorReporter xMLErrorReporter) {
        this.fErrorReporter = xMLErrorReporter;
    }

    protected Reader getReader(XMLInputSource xMLInputSource) throws IOException {
        Object object;
        Object object2;
        String string2;
        if (xMLInputSource.getCharacterStream() != null) {
            return xMLInputSource.getCharacterStream();
        }
        InputStream inputStream = null;
        String string3 = xMLInputSource.getEncoding();
        if (string3 == null) {
            string3 = "UTF-8";
        }
        if (xMLInputSource.getByteStream() != null) {
            inputStream = xMLInputSource.getByteStream();
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream, this.fTempString.ch.length);
            }
        } else {
            Object object3;
            Object object4;
            string2 = XMLEntityManager.expandSystemId(xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId(), false);
            object2 = new URL(string2);
            object = ((URL)object2).openConnection();
            if (object instanceof HttpURLConnection && xMLInputSource instanceof HTTPInputSource) {
                object4 = (HttpURLConnection)object;
                HTTPInputSource hTTPInputSource = (HTTPInputSource)xMLInputSource;
                object3 = hTTPInputSource.getHTTPRequestProperties();
                while (object3.hasNext()) {
                    Map.Entry entry = (Map.Entry)object3.next();
                    ((URLConnection)object4).setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                boolean bl2 = hTTPInputSource.getFollowHTTPRedirects();
                if (!bl2) {
                    XMLEntityManager.setInstanceFollowRedirects((HttpURLConnection)object4, bl2);
                }
            }
            inputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
            object4 = ((URLConnection)object).getContentType();
            int n2 = object4 != null ? ((String)object4).indexOf(59) : -1;
            object3 = null;
            String string4 = null;
            if (n2 != -1) {
                object3 = ((String)object4).substring(0, n2).trim();
                string4 = ((String)object4).substring(n2 + 1).trim();
                if (string4.startsWith("charset=")) {
                    if ((string4 = string4.substring(8).trim()).charAt(0) == '\"' && string4.charAt(string4.length() - 1) == '\"' || string4.charAt(0) == '\'' && string4.charAt(string4.length() - 1) == '\'') {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                } else {
                    string4 = null;
                }
            } else {
                object3 = ((String)object4).trim();
            }
            String string5 = null;
            if (((String)object3).equals("text/xml")) {
                string5 = string4 != null ? string4 : "US-ASCII";
            } else if (((String)object3).equals("application/xml")) {
                string5 = string4 != null ? string4 : this.getEncodingName(inputStream);
            } else if (((String)object3).endsWith("+xml")) {
                string5 = this.getEncodingName(inputStream);
            }
            if (string5 != null) {
                string3 = string5;
            }
        }
        string3 = string3.toUpperCase(Locale.ENGLISH);
        if ((string3 = this.consumeBOM(inputStream, string3)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fTempString.ch.length, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        string2 = EncodingMap.getIANA2JavaMapping(string3);
        if (string2 == null) {
            object2 = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210");
            object = this.fErrorReporter.getLocale();
            throw new IOException(object2.formatMessage((Locale)object, "EncodingDeclInvalid", new Object[]{string3}));
        }
        if (string2.equals("ASCII")) {
            return new ASCIIReader(inputStream, this.fTempString.ch.length, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string2.equals("ISO8859_1")) {
            return new Latin1Reader(inputStream, this.fTempString.ch.length);
        }
        return new InputStreamReader(inputStream, string2);
    }

    protected String getEncodingName(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        String string2 = null;
        inputStream.mark(4);
        int n2 = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        if (n2 == 4) {
            string2 = this.getEncodingName(byArray);
        }
        return string2;
    }

    protected String consumeBOM(InputStream inputStream, String string2) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        inputStream.mark(3);
        if (string2.equals("UTF-8")) {
            n2 = inputStream.read(byArray, 0, 3);
            if (n2 == 3) {
                int n3 = byArray[0] & 0xFF;
                int n4 = byArray[1] & 0xFF;
                int n5 = byArray[2] & 0xFF;
                if (n3 != 239 || n4 != 187 || n5 != 191) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        } else if (string2.startsWith("UTF-16")) {
            n2 = inputStream.read(byArray, 0, 2);
            if (n2 == 2) {
                int n6 = byArray[0] & 0xFF;
                int n7 = byArray[1] & 0xFF;
                if (n6 == 254 && n7 == 255) {
                    return "UTF-16BE";
                }
                if (n6 == 255 && n7 == 254) {
                    return "UTF-16LE";
                }
            }
            inputStream.reset();
        }
        return string2;
    }

    protected String getEncodingName(byte[] byArray) {
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return "UTF-16BE";
        }
        if (n2 == 255 && n3 == 254) {
            return "UTF-16LE";
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return "UTF-8";
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return "UTF-16BE";
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return "UTF-16LE";
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return "CP037";
        }
        return null;
    }

    public void parse() throws IOException {
        this.fReader = this.getReader(this.fSource);
        this.fSource = null;
        int n2 = this.fReader.read(this.fTempString.ch, 0, this.fTempString.ch.length - 1);
        this.fHandler.fHasIncludeReportedContent = true;
        while (n2 != -1) {
            int n3 = 0;
            while (n3 < n2) {
                char c2 = this.fTempString.ch[n3];
                if (!this.isValid(c2)) {
                    if (XMLChar.isHighSurrogate(c2)) {
                        int n4;
                        if (++n3 < n2) {
                            n4 = this.fTempString.ch[n3];
                        } else {
                            n4 = this.fReader.read();
                            if (n4 != -1) {
                                this.fTempString.ch[n2++] = (char)n4;
                            }
                        }
                        if (XMLChar.isLowSurrogate(n4)) {
                            int n5 = XMLChar.supplemental(c2, (char)n4);
                            if (!this.isValid(n5)) {
                                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n5, 16)}, (short)2);
                            }
                        } else {
                            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n4, 16)}, (short)2);
                        }
                    } else {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(c2, 16)}, (short)2);
                    }
                }
                ++n3;
            }
            if (this.fHandler != null && n2 > 0) {
                this.fTempString.offset = 0;
                this.fTempString.length = n2;
                this.fHandler.characters(this.fTempString, this.fHandler.modifyAugmentations(null, true));
            }
            n2 = this.fReader.read(this.fTempString.ch, 0, this.fTempString.ch.length - 1);
        }
    }

    public void setInputSource(XMLInputSource xMLInputSource) {
        this.fSource = xMLInputSource;
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
            this.fReader = null;
        }
    }

    protected boolean isValid(int n2) {
        return XMLChar.isValid(n2);
    }

    protected void setBufferSize(int n2) {
        if (this.fTempString.ch.length != ++n2) {
            this.fTempString.ch = new char[n2];
        }
    }
}

