/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.util;

public class SymbolTable {
    protected static final int TABLE_SIZE = 101;
    protected Entry[] fBuckets = null;
    protected int fTableSize;
    protected transient int fCount;
    protected int fThreshold;
    protected float fLoadFactor;

    public SymbolTable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.fLoadFactor = f2;
        this.fTableSize = n2;
        this.fBuckets = new Entry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * f2);
        this.fCount = 0;
    }

    public SymbolTable(int n2) {
        this(n2, 0.75f);
    }

    public SymbolTable() {
        this(101, 0.75f);
    }

    public String addSymbol(String string2) {
        Entry entry;
        int n2 = this.hash(string2) % this.fTableSize;
        Entry entry2 = this.fBuckets[n2];
        while (entry2 != null) {
            if (entry2.symbol.equals(string2)) {
                return entry2.symbol;
            }
            entry2 = entry2.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n2 = this.hash(string2) % this.fTableSize;
        }
        this.fBuckets[n2] = entry = new Entry(string2, this.fBuckets[n2]);
        ++this.fCount;
        return entry.symbol;
    }

    public String addSymbol(char[] cArray, int n2, int n3) {
        Entry entry;
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry2 = this.fBuckets[n4];
        while (entry2 != null) {
            block5: {
                if (n3 == entry2.characters.length) {
                    int n5 = 0;
                    while (n5 < n3) {
                        if (cArray[n2 + n5] == entry2.characters[n5]) {
                            ++n5;
                            continue;
                        }
                        break block5;
                    }
                    return entry2.symbol;
                }
            }
            entry2 = entry2.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        }
        this.fBuckets[n4] = entry = new Entry(cArray, n2, n3, this.fBuckets[n4]);
        ++this.fCount;
        return entry.symbol;
    }

    public int hash(String string2) {
        return string2.hashCode() & 0x7FFFFFF;
    }

    public int hash(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            n4 = n4 * 31 + cArray[n2 + n5];
            ++n5;
        }
        return n4 & 0x7FFFFFF;
    }

    protected void rehash() {
        int n2 = this.fBuckets.length;
        Entry[] entryArray = this.fBuckets;
        int n3 = n2 * 2 + 1;
        Entry[] entryArray2 = new Entry[n3];
        this.fThreshold = (int)((float)n3 * this.fLoadFactor);
        this.fBuckets = entryArray2;
        this.fTableSize = this.fBuckets.length;
        int n4 = n2;
        while (n4-- > 0) {
            Entry entry = entryArray[n4];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n5 = this.hash(entry2.characters, 0, entry2.characters.length) % n3;
                entry2.next = entryArray2[n5];
                entryArray2[n5] = entry2;
            }
        }
    }

    public boolean containsSymbol(String string2) {
        int n2 = this.hash(string2) % this.fTableSize;
        int n3 = string2.length();
        Entry entry = this.fBuckets[n2];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    int n4 = 0;
                    while (n4 < n3) {
                        if (string2.charAt(n4) == entry.characters[n4]) {
                            ++n4;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        Entry entry = this.fBuckets[n4];
        while (entry != null) {
            block4: {
                if (n3 == entry.characters.length) {
                    int n5 = 0;
                    while (n5 < n3) {
                        if (cArray[n2 + n5] == entry.characters[n5]) {
                            ++n5;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            entry = entry.next;
        }
        return false;
    }

    protected static final class Entry {
        public final String symbol;
        public final char[] characters;
        public Entry next;

        public Entry(String string2, Entry entry) {
            this.symbol = string2.intern();
            this.characters = new char[string2.length()];
            string2.getChars(0, this.characters.length, this.characters, 0);
            this.next = entry;
        }

        public Entry(char[] cArray, int n2, int n3, Entry entry) {
            this.characters = new char[n3];
            System.arraycopy(cArray, n2, this.characters, 0, n3);
            this.symbol = new String(this.characters).intern();
            this.next = entry;
        }
    }
}

