/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xs;

import org.python.apache.xerces.impl.xs.opti.ElementImpl;
import org.python.apache.xerces.util.NamespaceSupport;
import org.python.apache.xerces.util.SymbolTable;
import org.python.apache.xerces.util.XMLSymbols;
import org.python.apache.xerces.xni.NamespaceContext;
import org.python.apache.xerces.xni.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SchemaNamespaceSupport
extends NamespaceSupport {
    private SchemaRootContext fSchemaRootContext = null;

    public SchemaNamespaceSupport(Element element, SymbolTable symbolTable) {
        Document document;
        if (element != null && !(element instanceof ElementImpl) && (document = element.getOwnerDocument()) != null && element != document.getDocumentElement()) {
            this.fSchemaRootContext = new SchemaRootContext(element, symbolTable);
        }
    }

    public SchemaNamespaceSupport(SchemaNamespaceSupport schemaNamespaceSupport) {
        this.fSchemaRootContext = schemaNamespaceSupport.fSchemaRootContext;
        this.fNamespaceSize = schemaNamespaceSupport.fNamespaceSize;
        if (this.fNamespace.length < this.fNamespaceSize) {
            this.fNamespace = new String[this.fNamespaceSize];
        }
        System.arraycopy(schemaNamespaceSupport.fNamespace, 0, this.fNamespace, 0, this.fNamespaceSize);
        this.fCurrentContext = schemaNamespaceSupport.fCurrentContext;
        if (this.fContext.length <= this.fCurrentContext) {
            this.fContext = new int[this.fCurrentContext + 1];
        }
        System.arraycopy(schemaNamespaceSupport.fContext, 0, this.fContext, 0, this.fCurrentContext + 1);
    }

    public void setEffectiveContext(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.pushContext();
        int n2 = this.fNamespaceSize + stringArray.length;
        if (this.fNamespace.length < n2) {
            String[] stringArray2 = new String[n2];
            System.arraycopy(this.fNamespace, 0, stringArray2, 0, this.fNamespace.length);
            this.fNamespace = stringArray2;
        }
        System.arraycopy(stringArray, 0, this.fNamespace, this.fNamespaceSize, stringArray.length);
        this.fNamespaceSize = n2;
    }

    public String[] getEffectiveLocalContext() {
        int n2;
        int n3;
        String[] stringArray = null;
        if (this.fCurrentContext >= 3 && (n3 = this.fNamespaceSize - (n2 = this.fContext[3])) > 0) {
            stringArray = new String[n3];
            System.arraycopy(this.fNamespace, n2, stringArray, 0, n3);
        }
        return stringArray;
    }

    public void makeGlobal() {
        if (this.fCurrentContext >= 3) {
            this.fCurrentContext = 3;
            this.fNamespaceSize = this.fContext[3];
        }
    }

    public String getURI(String string2) {
        String string3 = super.getURI(string2);
        if (string3 == null && this.fSchemaRootContext != null) {
            if (!this.fSchemaRootContext.fDOMContextBuilt) {
                this.fSchemaRootContext.fillNamespaceContext();
                this.fSchemaRootContext.fDOMContextBuilt = true;
            }
            if (this.fSchemaRootContext.fNamespaceSize > 0 && !this.containsPrefix(string2)) {
                string3 = this.fSchemaRootContext.getURI(string2);
            }
        }
        return string3;
    }

    static final class SchemaRootContext {
        String[] fNamespace = new String[32];
        int fNamespaceSize = 0;
        boolean fDOMContextBuilt = false;
        private final Element fSchemaRoot;
        private final SymbolTable fSymbolTable;
        private final QName fAttributeQName = new QName();

        SchemaRootContext(Element element, SymbolTable symbolTable) {
            this.fSchemaRoot = element;
            this.fSymbolTable = symbolTable;
        }

        void fillNamespaceContext() {
            if (this.fSchemaRoot != null) {
                Node node = this.fSchemaRoot.getParentNode();
                while (node != null) {
                    if (1 == node.getNodeType()) {
                        NamedNodeMap namedNodeMap = node.getAttributes();
                        int n2 = namedNodeMap.getLength();
                        int n3 = 0;
                        while (n3 < n2) {
                            Attr attr = (Attr)namedNodeMap.item(n3);
                            String string2 = attr.getValue();
                            if (string2 == null) {
                                string2 = XMLSymbols.EMPTY_STRING;
                            }
                            this.fillQName(this.fAttributeQName, attr);
                            if (this.fAttributeQName.uri == NamespaceContext.XMLNS_URI) {
                                if (this.fAttributeQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                                    this.declarePrefix(this.fAttributeQName.localpart, string2.length() != 0 ? this.fSymbolTable.addSymbol(string2) : null);
                                } else {
                                    this.declarePrefix(XMLSymbols.EMPTY_STRING, string2.length() != 0 ? this.fSymbolTable.addSymbol(string2) : null);
                                }
                            }
                            ++n3;
                        }
                    }
                    node = node.getParentNode();
                }
            }
        }

        String getURI(String string2) {
            int n2 = 0;
            while (n2 < this.fNamespaceSize) {
                if (this.fNamespace[n2] == string2) {
                    return this.fNamespace[n2 + 1];
                }
                n2 += 2;
            }
            return null;
        }

        private void declarePrefix(String string2, String string3) {
            if (this.fNamespaceSize == this.fNamespace.length) {
                String[] stringArray = new String[this.fNamespaceSize * 2];
                System.arraycopy(this.fNamespace, 0, stringArray, 0, this.fNamespaceSize);
                this.fNamespace = stringArray;
            }
            this.fNamespace[this.fNamespaceSize++] = string2;
            this.fNamespace[this.fNamespaceSize++] = string3;
        }

        private void fillQName(QName qName, Node node) {
            String string2 = node.getPrefix();
            String string3 = node.getLocalName();
            String string4 = node.getNodeName();
            String string5 = node.getNamespaceURI();
            qName.prefix = string2 != null ? this.fSymbolTable.addSymbol(string2) : XMLSymbols.EMPTY_STRING;
            qName.localpart = string3 != null ? this.fSymbolTable.addSymbol(string3) : XMLSymbols.EMPTY_STRING;
            qName.rawname = string4 != null ? this.fSymbolTable.addSymbol(string4) : XMLSymbols.EMPTY_STRING;
            qName.uri = string5 != null && string5.length() > 0 ? this.fSymbolTable.addSymbol(string5) : null;
        }
    }
}

