/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xpath.regex;

import java.text.CharacterIterator;
import org.python.apache.xerces.impl.xpath.regex.Match;
import org.python.apache.xerces.impl.xpath.regex.ParseException;
import org.python.apache.xerces.impl.xpath.regex.RegularExpression;

public final class REUtil {
    static final int CACHESIZE = 20;
    static final RegularExpression[] regexCache = new RegularExpression[20];

    private REUtil() {
    }

    static final int composeFromSurrogates(int n2, int n3) {
        return 65536 + (n2 - 55296 << 10) + n3 - 56320;
    }

    static final boolean isLowSurrogate(int n2) {
        return (n2 & 0xFC00) == 56320;
    }

    static final boolean isHighSurrogate(int n2) {
        return (n2 & 0xFC00) == 55296;
    }

    static final String decomposeToSurrogates(int n2) {
        char[] cArray = new char[]{(char)(((n2 -= 65536) >> 10) + 55296), (char)((n2 & 0x3FF) + 56320)};
        return new String(cArray);
    }

    static final String substring(CharacterIterator characterIterator, int n2, int n3) {
        char[] cArray = new char[n3 - n2];
        int n4 = 0;
        while (n4 < cArray.length) {
            cArray[n4] = characterIterator.setIndex(n4 + n2);
            ++n4;
        }
        return new String(cArray);
    }

    static final int getOptionValue(int n2) {
        int n3 = 0;
        switch (n2) {
            case 105: {
                n3 = 2;
                break;
            }
            case 109: {
                n3 = 8;
                break;
            }
            case 115: {
                n3 = 4;
                break;
            }
            case 120: {
                n3 = 16;
                break;
            }
            case 117: {
                n3 = 32;
                break;
            }
            case 119: {
                n3 = 64;
                break;
            }
            case 70: {
                n3 = 256;
                break;
            }
            case 72: {
                n3 = 128;
                break;
            }
            case 88: {
                n3 = 512;
                break;
            }
            case 44: {
                n3 = 1024;
                break;
            }
        }
        return n3;
    }

    static final int parseOptions(String string2) throws ParseException {
        if (string2 == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < string2.length()) {
            int n4 = REUtil.getOptionValue(string2.charAt(n3));
            if (n4 == 0) {
                throw new ParseException("Unknown Option: " + string2.substring(n3), -1);
            }
            n2 |= n4;
            ++n3;
        }
        return n2;
    }

    static final String createOptionString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(9);
        if ((n2 & 0x100) != 0) {
            stringBuffer.append('F');
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append('H');
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append('X');
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append('m');
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append('s');
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append('u');
        }
        if ((n2 & 0x40) != 0) {
            stringBuffer.append('w');
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append('x');
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append(',');
        }
        return stringBuffer.toString().intern();
    }

    static String stripExtendedComment(String string2) {
        int n2 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        block0: while (n3 < n2) {
            char c2;
            if ((c2 = string2.charAt(n3++)) == '\t' || c2 == '\n' || c2 == '\f' || c2 == '\r' || c2 == ' ') continue;
            if (c2 == '#') {
                while (n3 < n2) {
                    if ((c2 = string2.charAt(n3++)) == '\r' || c2 == '\n') continue block0;
                }
                continue;
            }
            if (c2 == '\\' && n3 < n2) {
                char c3 = string2.charAt(n3);
                if (c3 == '#' || c3 == '\t' || c3 == '\n' || c3 == '\f' || c3 == '\r' || c3 == ' ') {
                    stringBuffer.append(c3);
                    ++n3;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c3);
                ++n3;
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] var0) {
        var1_1 = null;
        try {
            var2_2 = "";
            var3_4 = null;
            if (var0.length == 0) {
                System.out.println("Error:Usage: java REUtil -i|-m|-s|-u|-w|-X regularExpression String");
                System.exit(0);
            }
            var4_7 = 0;
            while (var4_7 < var0.length) {
                if (var0[var4_7].length() == 0 || var0[var4_7].charAt(0) != '-') {
                    if (var1_1 == null) {
                        var1_1 = var0[var4_7];
                    } else if (var3_4 == null) {
                        var3_4 = var0[var4_7];
                    } else {
                        System.err.println("Unnecessary: " + var0[var4_7]);
                    }
                } else if (var0[var4_7].equals("-i")) {
                    var2_2 = var2_2 + "i";
                } else if (var0[var4_7].equals("-m")) {
                    var2_2 = var2_2 + "m";
                } else if (var0[var4_7].equals("-s")) {
                    var2_2 = var2_2 + "s";
                } else if (var0[var4_7].equals("-u")) {
                    var2_2 = var2_2 + "u";
                } else if (var0[var4_7].equals("-w")) {
                    var2_2 = var2_2 + "w";
                } else if (var0[var4_7].equals("-X")) {
                    var2_2 = var2_2 + "X";
                } else {
                    System.err.println("Unknown option: " + var0[var4_7]);
                }
                ++var4_7;
            }
            var5_9 = new RegularExpression(var1_1, var2_2);
            System.out.println("RegularExpression: " + var5_9);
            var6_11 = new Match();
            var5_9.matches(var3_4, var6_11);
            var7_12 = 0;
            while (var7_12 < var6_11.getNumberOfGroups()) {
                if (var7_12 == 0) {
                    System.out.print("Matched range for the whole pattern: ");
                } else {
                    System.out.print("[" + var7_12 + "]: ");
                }
                if (var6_11.getBeginning(var7_12) < 0) {
                    System.out.println("-1");
                } else {
                    System.out.print(var6_11.getBeginning(var7_12) + ", " + var6_11.getEnd(var7_12) + ", ");
                    System.out.println("\"" + var6_11.getCapturedText(var7_12) + "\"");
                }
                ++var7_12;
            }
            return;
        }
        catch (ParseException var2_3) {
            if (var1_1 == null) {
                var2_3.printStackTrace();
                return;
            }
            System.err.println("org.apache.xerces.utils.regex.ParseException: " + var2_3.getMessage());
            var3_5 = "        ";
            System.err.println(var3_5 + var1_1);
            var4_8 = var2_3.getLocation();
            if (var4_8 < 0) return;
            System.err.print(var3_5);
            var5_10 = 0;
            ** while (var5_10 < var4_8)
        }
lbl-1000:
        // 1 sources

        {
            System.err.print("-");
            ++var5_10;
            continue;
        }
lbl74:
        // 1 sources

        System.err.println("^");
        return;
        catch (Exception var3_6) {
            var3_6.printStackTrace();
        }
    }

    public static RegularExpression createRegex(String string2, String string3) throws ParseException {
        RegularExpression regularExpression = null;
        int n2 = REUtil.parseOptions(string3);
        RegularExpression[] regularExpressionArray = regexCache;
        synchronized (regularExpressionArray) {
            int n3 = 0;
            while (n3 < 20) {
                RegularExpression regularExpression2 = regexCache[n3];
                if (regularExpression2 == null) {
                    n3 = -1;
                    break;
                }
                if (regularExpression2.equals(string2, n2)) {
                    regularExpression = regularExpression2;
                    break;
                }
                ++n3;
            }
            if (regularExpression != null) {
                if (n3 != 0) {
                    System.arraycopy(regexCache, 0, regexCache, 1, n3);
                    REUtil.regexCache[0] = regularExpression;
                }
            } else {
                regularExpression = new RegularExpression(string2, string3);
                System.arraycopy(regexCache, 0, regexCache, 1, 19);
                REUtil.regexCache[0] = regularExpression;
            }
        }
        return regularExpression;
    }

    public static boolean matches(String string2, String string3) throws ParseException {
        return REUtil.createRegex(string2, null).matches(string3);
    }

    public static boolean matches(String string2, String string3, String string4) throws ParseException {
        return REUtil.createRegex(string2, string3).matches(string4);
    }

    public static String quoteMeta(String string2) {
        int n2 = string2.length();
        StringBuffer stringBuffer = null;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string2.charAt(n3);
            if (".*+?{[()|\\^$".indexOf(c2) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n3 + (n2 - n3) * 2);
                    if (n3 > 0) {
                        stringBuffer.append(string2.substring(0, n3));
                    }
                }
                stringBuffer.append('\\');
                stringBuffer.append(c2);
            } else if (stringBuffer != null) {
                stringBuffer.append(c2);
            }
            ++n3;
        }
        return stringBuffer != null ? stringBuffer.toString() : string2;
    }

    static void dumpString(String string2) {
        int n2 = 0;
        while (n2 < string2.length()) {
            System.out.print(Integer.toHexString(string2.charAt(n2)));
            System.out.print(" ");
            ++n2;
        }
        System.out.println();
    }
}

