/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl;

import java.io.IOException;
import org.python.apache.xerces.impl.XMLEntityManager;
import org.python.apache.xerces.impl.XMLEntityScanner;
import org.python.apache.xerces.impl.XMLErrorReporter;
import org.python.apache.xerces.util.SymbolTable;
import org.python.apache.xerces.util.XMLChar;
import org.python.apache.xerces.util.XMLResourceIdentifierImpl;
import org.python.apache.xerces.util.XMLStringBuffer;
import org.python.apache.xerces.xni.Augmentations;
import org.python.apache.xerces.xni.XMLResourceIdentifier;
import org.python.apache.xerces.xni.XMLString;
import org.python.apache.xerces.xni.XNIException;
import org.python.apache.xerces.xni.parser.XMLComponent;
import org.python.apache.xerces.xni.parser.XMLComponentManager;
import org.python.apache.xerces.xni.parser.XMLConfigurationException;

public abstract class XMLScanner
implements XMLComponent {
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final boolean DEBUG_ATTR_NORMALIZATION = false;
    protected boolean fValidation = false;
    protected boolean fNamespaces;
    protected boolean fNotifyCharRefs = false;
    protected boolean fParserSettings = true;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityManager fEntityManager;
    protected XMLEntityScanner fEntityScanner;
    protected int fEntityDepth;
    protected String fCharRefLiteral = null;
    protected boolean fScanningAttribute;
    protected boolean fReportEntity;
    protected static final String fVersionSymbol = "version".intern();
    protected static final String fEncodingSymbol = "encoding".intern();
    protected static final String fStandaloneSymbol = "standalone".intern();
    protected static final String fAmpSymbol = "amp".intern();
    protected static final String fLtSymbol = "lt".intern();
    protected static final String fGtSymbol = "gt".intern();
    protected static final String fQuotSymbol = "quot".intern();
    protected static final String fAposSymbol = "apos".intern();
    private final XMLString fString = new XMLString();
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private final XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private final XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();
    protected final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fParserSettings = xMLComponentManager.getFeature(PARSER_SETTINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fParserSettings = true;
        }
        if (!this.fParserSettings) {
            this.init();
            return;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)xMLComponentManager.getProperty(ENTITY_MANAGER);
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        try {
            this.fNotifyCharRefs = xMLComponentManager.getFeature(NOTIFY_CHAR_REFS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNotifyCharRefs = false;
        }
        this.init();
    }

    public void setProperty(String string2, Object object) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/properties/")) {
            int n2 = string2.length() - "http://apache.org/xml/properties/".length();
            if (n2 == "internal/symbol-table".length() && string2.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (n2 == "internal/error-reporter".length() && string2.endsWith("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
            } else if (n2 == "internal/entity-manager".length() && string2.endsWith("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)object;
            }
        }
    }

    public void setFeature(String string2, boolean bl2) throws XMLConfigurationException {
        if (VALIDATION.equals(string2)) {
            this.fValidation = bl2;
        } else if (NOTIFY_CHAR_REFS.equals(string2)) {
            this.fNotifyCharRefs = bl2;
        }
    }

    public boolean getFeature(String string2) throws XMLConfigurationException {
        if (VALIDATION.equals(string2)) {
            return this.fValidation;
        }
        if (NOTIFY_CHAR_REFS.equals(string2)) {
            return this.fNotifyCharRefs;
        }
        throw new XMLConfigurationException(0, string2);
    }

    protected void reset() {
        this.init();
        this.fValidation = true;
        this.fNotifyCharRefs = false;
    }

    protected void scanXMLDeclOrTextDecl(boolean bl2, String[] stringArray) throws IOException, XNIException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        boolean bl3 = false;
        boolean bl4 = this.fEntityScanner.skipDeclSpaces();
        XMLEntityManager.ScannedEntity scannedEntity = this.fEntityManager.getCurrentEntity();
        boolean bl5 = scannedEntity.literal;
        scannedEntity.literal = false;
        while (this.fEntityScanner.peekChar() != 63) {
            bl3 = true;
            String string5 = this.scanPseudoAttribute(bl2, this.fString);
            switch (n2) {
                case 0: {
                    if (string5 == fVersionSymbol) {
                        if (!bl4) {
                            this.reportFatalError(bl2 ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n2 = 1;
                        if (this.versionSupported(string2)) break;
                        this.reportFatalError(this.getVersionNotSupportedKey(), new Object[]{string2});
                        break;
                    }
                    if (string5 == fEncodingSymbol) {
                        if (!bl2) {
                            this.reportFatalError("VersionInfoRequired", null);
                        }
                        if (!bl4) {
                            this.reportFatalError(bl2 ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string3 = this.fString.toString();
                        n2 = bl2 ? 3 : 2;
                        break;
                    }
                    if (bl2) {
                        this.reportFatalError("EncodingDeclRequired", null);
                        break;
                    }
                    this.reportFatalError("VersionInfoRequired", null);
                    break;
                }
                case 1: {
                    if (string5 == fEncodingSymbol) {
                        if (!bl4) {
                            this.reportFatalError(bl2 ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string3 = this.fString.toString();
                        n2 = bl2 ? 3 : 2;
                        break;
                    }
                    if (!bl2 && string5 == fStandaloneSymbol) {
                        if (!bl4) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string4 = this.fString.toString();
                        n2 = 3;
                        if (string4.equals("yes") || string4.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", new Object[]{string4});
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                case 2: {
                    if (string5 == fStandaloneSymbol) {
                        if (!bl4) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string4 = this.fString.toString();
                        n2 = 3;
                        if (string4.equals("yes") || string4.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", new Object[]{string4});
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                default: {
                    this.reportFatalError("NoMorePseudoAttributes", null);
                }
            }
            bl4 = this.fEntityScanner.skipDeclSpaces();
        }
        if (bl5) {
            scannedEntity.literal = true;
        }
        if (bl2 && n2 != 3) {
            this.reportFatalError("MorePseudoAttributes", null);
        }
        if (bl2) {
            if (!bl3 && string3 == null) {
                this.reportFatalError("EncodingDeclRequired", null);
            }
        } else if (!bl3 && string2 == null) {
            this.reportFatalError("VersionInfoRequired", null);
        }
        if (!this.fEntityScanner.skipChar(63)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
        stringArray[2] = string4;
    }

    public String scanPseudoAttribute(boolean bl2, XMLString xMLString) throws IOException, XNIException {
        String string2 = this.fEntityScanner.scanName();
        XMLEntityManager.print(this.fEntityManager.getCurrentEntity());
        if (string2 == null) {
            this.reportFatalError("PseudoAttrNameExpected", null);
        }
        this.fEntityScanner.skipDeclSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError(bl2 ? "EqRequiredInTextDecl" : "EqRequiredInXMLDecl", new Object[]{string2});
        }
        this.fEntityScanner.skipDeclSpaces();
        int n2 = this.fEntityScanner.peekChar();
        if (n2 != 39 && n2 != 34) {
            this.reportFatalError(bl2 ? "QuoteRequiredInTextDecl" : "QuoteRequiredInXMLDecl", new Object[]{string2});
        }
        this.fEntityScanner.scanChar();
        int n3 = this.fEntityScanner.scanLiteral(n2, xMLString);
        if (n3 != n2) {
            this.fStringBuffer2.clear();
            do {
                this.fStringBuffer2.append(xMLString);
                if (n3 == -1) continue;
                if (n3 == 38 || n3 == 37 || n3 == 60 || n3 == 93) {
                    this.fStringBuffer2.append((char)this.fEntityScanner.scanChar());
                    continue;
                }
                if (XMLChar.isHighSurrogate(n3)) {
                    this.scanSurrogates(this.fStringBuffer2);
                    continue;
                }
                if (!this.isInvalidLiteral(n3)) continue;
                String string3 = bl2 ? "InvalidCharInTextDecl" : "InvalidCharInXMLDecl";
                this.reportFatalError(string3, new Object[]{Integer.toString(n3, 16)});
                this.fEntityScanner.scanChar();
            } while ((n3 = this.fEntityScanner.scanLiteral(n2, xMLString)) != n2);
            this.fStringBuffer2.append(xMLString);
            xMLString.setValues(this.fStringBuffer2);
        }
        if (!this.fEntityScanner.skipChar(n2)) {
            this.reportFatalError(bl2 ? "CloseQuoteMissingInTextDecl" : "CloseQuoteMissingInXMLDecl", new Object[]{string2});
        }
        return string2;
    }

    protected void scanPI() throws IOException, XNIException {
        this.fReportEntity = false;
        String string2 = null;
        string2 = this.fNamespaces ? this.fEntityScanner.scanNCName() : this.fEntityScanner.scanName();
        if (string2 == null) {
            this.reportFatalError("PITargetRequired", null);
        }
        this.scanPIData(string2, this.fString);
        this.fReportEntity = true;
    }

    protected void scanPIData(String string2, XMLString xMLString) throws IOException, XNIException {
        int n2;
        if (string2.length() == 3) {
            n2 = Character.toLowerCase(string2.charAt(0));
            char c2 = Character.toLowerCase(string2.charAt(1));
            char c3 = Character.toLowerCase(string2.charAt(2));
            if (n2 == 120 && c2 == 'm' && c3 == 'l') {
                this.reportFatalError("ReservedPITarget", null);
            }
        }
        if (!this.fEntityScanner.skipSpaces()) {
            if (this.fEntityScanner.skipString("?>")) {
                xMLString.clear();
                return;
            }
            if (this.fNamespaces && this.fEntityScanner.peekChar() == 58) {
                this.fEntityScanner.scanChar();
                XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string2);
                xMLStringBuffer.append(":");
                String string3 = this.fEntityScanner.scanName();
                if (string3 != null) {
                    xMLStringBuffer.append(string3);
                }
                this.reportFatalError("ColonNotLegalWithNS", new Object[]{xMLStringBuffer.toString()});
                this.fEntityScanner.skipSpaces();
            } else {
                this.reportFatalError("SpaceRequiredInPI", null);
            }
        }
        this.fStringBuffer.clear();
        if (this.fEntityScanner.scanData("?>", this.fStringBuffer)) {
            do {
                if ((n2 = this.fEntityScanner.peekChar()) == -1) continue;
                if (XMLChar.isHighSurrogate(n2)) {
                    this.scanSurrogates(this.fStringBuffer);
                    continue;
                }
                if (!this.isInvalidLiteral(n2)) continue;
                this.reportFatalError("InvalidCharInPI", new Object[]{Integer.toHexString(n2)});
                this.fEntityScanner.scanChar();
            } while (this.fEntityScanner.scanData("?>", this.fStringBuffer));
        }
        xMLString.setValues(this.fStringBuffer);
    }

    protected void scanComment(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        xMLStringBuffer.clear();
        while (this.fEntityScanner.scanData("--", xMLStringBuffer)) {
            int n2 = this.fEntityScanner.peekChar();
            if (n2 == -1) continue;
            if (XMLChar.isHighSurrogate(n2)) {
                this.scanSurrogates(xMLStringBuffer);
                continue;
            }
            if (!this.isInvalidLiteral(n2)) continue;
            this.reportFatalError("InvalidCharInComment", new Object[]{Integer.toHexString(n2)});
            this.fEntityScanner.scanChar();
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("DashDashInComment", null);
        }
    }

    protected boolean scanAttributeValue(XMLString xMLString, XMLString xMLString2, String string2, boolean bl2, String string3) throws IOException, XNIException {
        int n2 = this.fEntityScanner.peekChar();
        if (n2 != 39 && n2 != 34) {
            this.reportFatalError("OpenQuoteExpected", new Object[]{string3, string2});
        }
        this.fEntityScanner.scanChar();
        int n3 = this.fEntityDepth;
        int n4 = this.fEntityScanner.scanLiteral(n2, xMLString);
        int n5 = 0;
        if (n4 == n2 && (n5 = this.isUnchangedByNormalization(xMLString)) == -1) {
            xMLString2.setValues(xMLString);
            int n6 = this.fEntityScanner.scanChar();
            if (n6 != n2) {
                this.reportFatalError("CloseQuoteExpected", new Object[]{string3, string2});
            }
            return true;
        }
        this.fStringBuffer2.clear();
        this.fStringBuffer2.append(xMLString);
        this.normalizeWhitespace(xMLString, n5);
        if (n4 != n2) {
            this.fScanningAttribute = true;
            this.fStringBuffer.clear();
            do {
                this.fStringBuffer.append(xMLString);
                if (n4 == 38) {
                    this.fEntityScanner.skipChar(38);
                    if (n3 == this.fEntityDepth) {
                        this.fStringBuffer2.append('&');
                    }
                    if (this.fEntityScanner.skipChar(35)) {
                        int n7;
                        if (n3 == this.fEntityDepth) {
                            this.fStringBuffer2.append('#');
                        }
                        if ((n7 = this.scanCharReferenceValue(this.fStringBuffer, this.fStringBuffer2)) != -1) {
                            // empty if block
                        }
                    } else {
                        String string4 = this.fEntityScanner.scanName();
                        if (string4 == null) {
                            this.reportFatalError("NameRequiredInReference", null);
                        } else if (n3 == this.fEntityDepth) {
                            this.fStringBuffer2.append(string4);
                        }
                        if (!this.fEntityScanner.skipChar(59)) {
                            this.reportFatalError("SemicolonRequiredInReference", new Object[]{string4});
                        } else if (n3 == this.fEntityDepth) {
                            this.fStringBuffer2.append(';');
                        }
                        if (string4 == fAmpSymbol) {
                            this.fStringBuffer.append('&');
                        } else if (string4 == fAposSymbol) {
                            this.fStringBuffer.append('\'');
                        } else if (string4 == fLtSymbol) {
                            this.fStringBuffer.append('<');
                        } else if (string4 == fGtSymbol) {
                            this.fStringBuffer.append('>');
                        } else if (string4 == fQuotSymbol) {
                            this.fStringBuffer.append('\"');
                        } else if (this.fEntityManager.isExternalEntity(string4)) {
                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{string4});
                        } else {
                            if (!this.fEntityManager.isDeclaredEntity(string4)) {
                                if (bl2) {
                                    if (this.fValidation) {
                                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{string4}, (short)1);
                                    }
                                } else {
                                    this.reportFatalError("EntityNotDeclared", new Object[]{string4});
                                }
                            }
                            this.fEntityManager.startEntity(string4, true);
                        }
                    }
                } else if (n4 == 60) {
                    this.reportFatalError("LessthanInAttValue", new Object[]{string3, string2});
                    this.fEntityScanner.scanChar();
                    if (n3 == this.fEntityDepth) {
                        this.fStringBuffer2.append((char)n4);
                    }
                } else if (n4 == 37 || n4 == 93) {
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer.append((char)n4);
                    if (n3 == this.fEntityDepth) {
                        this.fStringBuffer2.append((char)n4);
                    }
                } else if (n4 == 10 || n4 == 13) {
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer.append(' ');
                    if (n3 == this.fEntityDepth) {
                        this.fStringBuffer2.append('\n');
                    }
                } else if (n4 != -1 && XMLChar.isHighSurrogate(n4)) {
                    this.fStringBuffer3.clear();
                    if (this.scanSurrogates(this.fStringBuffer3)) {
                        this.fStringBuffer.append(this.fStringBuffer3);
                        if (n3 == this.fEntityDepth) {
                            this.fStringBuffer2.append(this.fStringBuffer3);
                        }
                    }
                } else if (n4 != -1 && this.isInvalidLiteral(n4)) {
                    this.reportFatalError("InvalidCharInAttValue", new Object[]{string3, string2, Integer.toString(n4, 16)});
                    this.fEntityScanner.scanChar();
                    if (n3 == this.fEntityDepth) {
                        this.fStringBuffer2.append((char)n4);
                    }
                }
                n4 = this.fEntityScanner.scanLiteral(n2, xMLString);
                if (n3 == this.fEntityDepth) {
                    this.fStringBuffer2.append(xMLString);
                }
                this.normalizeWhitespace(xMLString);
            } while (n4 != n2 || n3 != this.fEntityDepth);
            this.fStringBuffer.append(xMLString);
            xMLString.setValues(this.fStringBuffer);
            this.fScanningAttribute = false;
        }
        xMLString2.setValues(this.fStringBuffer2);
        int n8 = this.fEntityScanner.scanChar();
        if (n8 != n2) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{string3, string2});
        }
        return xMLString2.equals(xMLString.ch, xMLString.offset, xMLString.length);
    }

    protected void scanExternalID(String[] stringArray, boolean bl2) throws IOException, XNIException {
        String string2 = null;
        String string3 = null;
        if (this.fEntityScanner.skipString("PUBLIC")) {
            if (!this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterPUBLIC", null);
            }
            this.scanPubidLiteral(this.fString);
            string3 = this.fString.toString();
            if (!this.fEntityScanner.skipSpaces() && !bl2) {
                this.reportFatalError("SpaceRequiredBetweenPublicAndSystem", null);
            }
        }
        if (string3 != null || this.fEntityScanner.skipString("SYSTEM")) {
            int n2;
            if (string3 == null && !this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterSYSTEM", null);
            }
            if ((n2 = this.fEntityScanner.peekChar()) != 39 && n2 != 34) {
                if (string3 != null && bl2) {
                    stringArray[0] = null;
                    stringArray[1] = string3;
                    return;
                }
                this.reportFatalError("QuoteRequiredInSystemID", null);
            }
            this.fEntityScanner.scanChar();
            XMLString xMLString = this.fString;
            if (this.fEntityScanner.scanLiteral(n2, xMLString) != n2) {
                this.fStringBuffer.clear();
                do {
                    this.fStringBuffer.append(xMLString);
                    int n3 = this.fEntityScanner.peekChar();
                    if (!XMLChar.isMarkup(n3) && n3 != 93) continue;
                    this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
                } while (this.fEntityScanner.scanLiteral(n2, xMLString) != n2);
                this.fStringBuffer.append(xMLString);
                xMLString = this.fStringBuffer;
            }
            string2 = xMLString.toString();
            if (!this.fEntityScanner.skipChar(n2)) {
                this.reportFatalError("SystemIDUnterminated", null);
            }
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
    }

    protected boolean scanPubidLiteral(XMLString xMLString) throws IOException, XNIException {
        int n2 = this.fEntityScanner.scanChar();
        if (n2 != 39 && n2 != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean bl2 = true;
        boolean bl3 = true;
        while (true) {
            int n3;
            if ((n3 = this.fEntityScanner.scanChar()) == 32 || n3 == 10 || n3 == 13) {
                if (bl2) continue;
                this.fStringBuffer.append(' ');
                bl2 = true;
                continue;
            }
            if (n3 == n2) {
                if (bl2) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(n3)) {
                this.fStringBuffer.append((char)n3);
                bl2 = false;
                continue;
            }
            if (n3 == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            bl3 = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(n3)});
        }
        xMLString.setValues(this.fStringBuffer);
        return bl3;
    }

    protected void normalizeWhitespace(XMLString xMLString) {
        int n2 = xMLString.offset + xMLString.length;
        int n3 = xMLString.offset;
        while (n3 < n2) {
            char c2 = xMLString.ch[n3];
            if (c2 < ' ') {
                xMLString.ch[n3] = 32;
            }
            ++n3;
        }
    }

    protected void normalizeWhitespace(XMLString xMLString, int n2) {
        int n3 = xMLString.offset + xMLString.length;
        int n4 = xMLString.offset + n2;
        while (n4 < n3) {
            char c2 = xMLString.ch[n4];
            if (c2 < ' ') {
                xMLString.ch[n4] = 32;
            }
            ++n4;
        }
    }

    protected int isUnchangedByNormalization(XMLString xMLString) {
        int n2 = xMLString.offset + xMLString.length;
        int n3 = xMLString.offset;
        while (n3 < n2) {
            char c2 = xMLString.ch[n3];
            if (c2 < ' ') {
                return n3 - xMLString.offset;
            }
            ++n3;
        }
        return -1;
    }

    public void startEntity(String string2, XMLResourceIdentifier xMLResourceIdentifier, String string3, Augmentations augmentations) throws XNIException {
        ++this.fEntityDepth;
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
    }

    public void endEntity(String string2, Augmentations augmentations) throws XNIException {
        --this.fEntityDepth;
    }

    protected int scanCharReferenceValue(XMLStringBuffer xMLStringBuffer, XMLStringBuffer xMLStringBuffer2) throws IOException, XNIException {
        int n2;
        int n3;
        boolean bl2 = false;
        if (this.fEntityScanner.skipChar(120)) {
            if (xMLStringBuffer2 != null) {
                xMLStringBuffer2.append('x');
            }
            bl2 = true;
            this.fStringBuffer3.clear();
            n3 = 1;
            n2 = this.fEntityScanner.peekChar();
            int n4 = n3 = n2 >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102 || n2 >= 65 && n2 <= 70 ? 1 : 0;
            if (n3 != 0) {
                if (xMLStringBuffer2 != null) {
                    xMLStringBuffer2.append((char)n2);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n2);
                do {
                    int n5 = n3 = (n2 = this.fEntityScanner.peekChar()) >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102 || n2 >= 65 && n2 <= 70 ? 1 : 0;
                    if (n3 == 0) continue;
                    if (xMLStringBuffer2 != null) {
                        xMLStringBuffer2.append((char)n2);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)n2);
                } while (n3 != 0);
            } else {
                this.reportFatalError("HexdigitRequiredInCharRef", null);
            }
        } else {
            this.fStringBuffer3.clear();
            n3 = 1;
            n2 = this.fEntityScanner.peekChar();
            int n6 = n3 = n2 >= 48 && n2 <= 57 ? 1 : 0;
            if (n3 != 0) {
                if (xMLStringBuffer2 != null) {
                    xMLStringBuffer2.append((char)n2);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n2);
                do {
                    int n7 = n3 = (n2 = this.fEntityScanner.peekChar()) >= 48 && n2 <= 57 ? 1 : 0;
                    if (n3 == 0) continue;
                    if (xMLStringBuffer2 != null) {
                        xMLStringBuffer2.append((char)n2);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)n2);
                } while (n3 != 0);
            } else {
                this.reportFatalError("DigitRequiredInCharRef", null);
            }
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInCharRef", null);
        }
        if (xMLStringBuffer2 != null) {
            xMLStringBuffer2.append(';');
        }
        n3 = -1;
        try {
            n3 = Integer.parseInt(this.fStringBuffer3.toString(), bl2 ? 16 : 10);
            if (this.isInvalid(n3)) {
                StringBuffer stringBuffer = new StringBuffer(this.fStringBuffer3.length + 1);
                if (bl2) {
                    stringBuffer.append('x');
                }
                stringBuffer.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
                this.reportFatalError("InvalidCharRef", new Object[]{stringBuffer.toString()});
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer(this.fStringBuffer3.length + 1);
            if (bl2) {
                stringBuffer.append('x');
            }
            stringBuffer.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
            this.reportFatalError("InvalidCharRef", new Object[]{stringBuffer.toString()});
        }
        if (!XMLChar.isSupplemental(n3)) {
            xMLStringBuffer.append((char)n3);
        } else {
            xMLStringBuffer.append(XMLChar.highSurrogate(n3));
            xMLStringBuffer.append(XMLChar.lowSurrogate(n3));
        }
        if (this.fNotifyCharRefs && n3 != -1) {
            String string2 = "#" + (bl2 ? "x" : "") + this.fStringBuffer3.toString();
            if (!this.fScanningAttribute) {
                this.fCharRefLiteral = string2;
            }
        }
        return n3;
    }

    protected boolean isInvalid(int n2) {
        return XMLChar.isInvalid(n2);
    }

    protected boolean isInvalidLiteral(int n2) {
        return XMLChar.isInvalid(n2);
    }

    protected boolean isValidNameChar(int n2) {
        return XMLChar.isName(n2);
    }

    protected boolean isValidNameStartChar(int n2) {
        return XMLChar.isNameStart(n2);
    }

    protected boolean isValidNCName(int n2) {
        return XMLChar.isNCName(n2);
    }

    protected boolean isValidNameStartHighSurrogate(int n2) {
        return false;
    }

    protected boolean versionSupported(String string2) {
        return string2.equals("1.0");
    }

    protected String getVersionNotSupportedKey() {
        return "VersionNotSupported";
    }

    protected boolean scanSurrogates(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        int n2 = this.fEntityScanner.scanChar();
        int n3 = this.fEntityScanner.peekChar();
        if (!XMLChar.isLowSurrogate(n3)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n2, 16)});
            return false;
        }
        this.fEntityScanner.scanChar();
        int n4 = XMLChar.supplemental((char)n2, (char)n3);
        if (this.isInvalid(n4)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n4, 16)});
            return false;
        }
        xMLStringBuffer.append((char)n2);
        xMLStringBuffer.append((char)n3);
        return true;
    }

    protected void reportFatalError(String string2, Object[] objectArray) throws XNIException {
        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", string2, objectArray, (short)2);
    }

    private void init() {
        this.fEntityScanner = null;
        this.fEntityDepth = 0;
        this.fReportEntity = true;
        this.fResourceIdentifier.clear();
    }

    public abstract Object getPropertyDefault(String var1);

    public abstract Boolean getFeatureDefault(String var1);

    public abstract String[] getRecognizedProperties();

    public abstract String[] getRecognizedFeatures();
}

