/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.dom;

import org.python.apache.xerces.dom.AttrImpl;
import org.python.apache.xerces.dom.AttrNSImpl;
import org.python.apache.xerces.dom.AttributeMap;
import org.python.apache.xerces.dom.ChildNode;
import org.python.apache.xerces.dom.CoreDocumentImpl;
import org.python.apache.xerces.dom.DOMMessageFormatter;
import org.python.apache.xerces.dom.DeepNodeListImpl;
import org.python.apache.xerces.dom.DocumentTypeImpl;
import org.python.apache.xerces.dom.ElementDefinitionImpl;
import org.python.apache.xerces.dom.NamedNodeMapImpl;
import org.python.apache.xerces.dom.NodeImpl;
import org.python.apache.xerces.dom.ParentNode;
import org.python.apache.xerces.util.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements Element,
TypeInfo {
    static final long serialVersionUID = 3717253516652722278L;
    protected String name;
    protected AttributeMap attributes;

    public ElementImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl);
        this.name = string2;
        this.needsSyncData(true);
    }

    protected ElementImpl() {
    }

    void rename(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = string2;
        this.reconcileDefaultAttributes();
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public NamedNodeMap getAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes;
    }

    public Node cloneNode(boolean bl2) {
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl2);
        if (this.attributes != null) {
            elementImpl.attributes = (AttributeMap)this.attributes.cloneMap(elementImpl);
        }
        return elementImpl;
    }

    public String getBaseURI() {
        String string2;
        Attr attr;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes != null && (attr = (Attr)this.attributes.getNamedItem("xml:base")) != null && (string2 = attr.getNodeValue()).length() != 0) {
            try {
                string2 = new URI(string2).toString();
            }
            catch (URI.MalformedURIException malformedURIException) {
                String string3;
                String string4 = string3 = this.ownerNode != null ? this.ownerNode.getBaseURI() : null;
                if (string3 != null) {
                    try {
                        string2 = new URI(new URI(string3), string2).toString();
                    }
                    catch (URI.MalformedURIException malformedURIException2) {
                        return null;
                    }
                    return string2;
                }
                return null;
            }
            return string2;
        }
        Attr attr2 = attr = this.ownerNode != null ? this.ownerNode.getBaseURI() : null;
        if (attr != null) {
            try {
                return new URI((String)((Object)attr)).toString();
            }
            catch (URI.MalformedURIException malformedURIException) {
                return null;
            }
        }
        return null;
    }

    protected void setOwnerDocument(CoreDocumentImpl coreDocumentImpl) {
        super.setOwnerDocument(coreDocumentImpl);
        if (this.attributes != null) {
            this.attributes.setOwnerDocument(coreDocumentImpl);
        }
    }

    public String getAttribute(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(string2);
        return attr == null ? "" : attr.getValue();
    }

    public Attr getAttributeNode(String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string2);
    }

    public NodeList getElementsByTagName(String string2) {
        return new DeepNodeListImpl(this, string2);
    }

    public String getTagName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            ChildNode childNode2 = childNode.nextSibling;
            if (childNode.getNodeType() == 3) {
                if (childNode2 != null && childNode2.getNodeType() == 3) {
                    ((Text)((Object)childNode)).appendData(childNode2.getNodeValue());
                    this.removeChild(childNode2);
                    childNode2 = childNode;
                } else if (childNode.getNodeValue() == null || childNode.getNodeValue().length() == 0) {
                    this.removeChild(childNode);
                }
            } else if (childNode.getNodeType() == 1) {
                childNode.normalize();
            }
            childNode = childNode2;
        }
        if (this.attributes != null) {
            int n2 = 0;
            while (n2 < this.attributes.getLength()) {
                Node node = this.attributes.item(n2);
                node.normalize();
                ++n2;
            }
        }
        this.isNormalized(true);
    }

    public void removeAttribute(String string2) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string3);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItem(string2);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string2);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string3);
        }
        return (Attr)this.attributes.removeItem(attr, true);
    }

    public void setAttribute(String string2, String string3) {
        Attr attr;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string4);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr = this.getAttributeNode(string2)) == null) {
            attr = this.getOwnerDocument().createAttribute(string2);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr.setNodeValue(string3);
            this.attributes.setNamedItem(attr);
        } else {
            attr.setNodeValue(string3);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (attr.getOwnerDocument() != this.ownerDocument) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public String getAttributeNS(String string2, String string3) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItemNS(string2, string3);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String string2, String string3, String string4) {
        String string5;
        String string6;
        int n2;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string7);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((n2 = string3.indexOf(58)) < 0) {
            string6 = null;
            string5 = string3;
        } else {
            string6 = string3.substring(0, n2);
            string5 = string3.substring(n2 + 1);
        }
        Attr attr = this.getAttributeNodeNS(string2, string5);
        if (attr == null) {
            attr = this.getOwnerDocument().createAttributeNS(string2, string3);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr.setNodeValue(string4);
            this.attributes.setNamedItemNS(attr);
        } else {
            if (attr instanceof AttrNSImpl) {
                ((AttrNSImpl)attr).name = string6 != null ? string6 + ":" + string5 : string5;
            } else {
                attr = new AttrNSImpl((CoreDocumentImpl)this.getOwnerDocument(), string2, string3, string5);
                this.attributes.setNamedItemNS(attr);
            }
            attr.setNodeValue(string4);
        }
    }

    public void removeAttributeNS(String string2, String string3) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, string4);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItemNS(string2, string3);
    }

    public Attr getAttributeNodeNS(String string2, String string3) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string2, string3);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (attr.getOwnerDocument() != this.ownerDocument) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string3);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    protected int setXercesAttributeNode(Attr attr) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes.addItem(attr);
    }

    protected int getXercesAttribute(String string2, String string3) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return -1;
        }
        return this.attributes.getNamedItemIndex(string2, string3);
    }

    public boolean hasAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public boolean hasAttribute(String string2) {
        return this.getAttributeNode(string2) != null;
    }

    public boolean hasAttributeNS(String string2, String string3) {
        return this.getAttributeNodeNS(string2, string3) != null;
    }

    public NodeList getElementsByTagNameNS(String string2, String string3) {
        return new DeepNodeListImpl(this, string2, string3);
    }

    public boolean isEqualNode(Node node) {
        if (!super.isEqualNode(node)) {
            return false;
        }
        boolean bl2 = this.hasAttributes();
        if (bl2 != ((Element)node).hasAttributes()) {
            return false;
        }
        if (bl2) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            NamedNodeMap namedNodeMap2 = ((Element)node).getAttributes();
            int n2 = namedNodeMap.getLength();
            if (n2 != namedNodeMap2.getLength()) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                Node node2;
                Node node3 = namedNodeMap.item(n3);
                if (node3.getLocalName() == null ? (node2 = namedNodeMap2.getNamedItem(node3.getNodeName())) == null || !((NodeImpl)node3).isEqualNode(node2) : (node2 = namedNodeMap2.getNamedItemNS(node3.getNamespaceURI(), node3.getLocalName())) == null || !((NodeImpl)node3).isEqualNode(node2)) {
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    public void setIdAttributeNode(Attr attr, boolean bl2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (attr.getOwnerElement() != this) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string3);
            }
        }
        ((AttrImpl)attr).isIdAttribute(bl2);
        if (!bl2) {
            this.ownerDocument.removeIdentifier(attr.getValue());
        } else {
            this.ownerDocument.putIdentifier(attr.getValue(), this);
        }
    }

    public void setIdAttribute(String string2, boolean bl2) {
        Attr attr;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr = this.getAttributeNode(string2)) == null) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string3);
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string4);
            }
            if (attr.getOwnerElement() != this) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string5);
            }
        }
        ((AttrImpl)attr).isIdAttribute(bl2);
        if (!bl2) {
            this.ownerDocument.removeIdentifier(attr.getValue());
        } else {
            this.ownerDocument.putIdentifier(attr.getValue(), this);
        }
    }

    public void setIdAttributeNS(String string2, String string3, boolean bl2) {
        Attr attr;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr = this.getAttributeNodeNS(string2, string3)) == null) {
            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, string4);
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string5);
            }
            if (attr.getOwnerElement() != this) {
                String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, string6);
            }
        }
        ((AttrImpl)attr).isIdAttribute(bl2);
        if (!bl2) {
            this.ownerDocument.removeIdentifier(attr.getValue());
        } else {
            this.ownerDocument.putIdentifier(attr.getValue(), this);
        }
    }

    public String getTypeName() {
        return null;
    }

    public String getTypeNamespace() {
        return null;
    }

    public boolean isDerivedFrom(String string2, String string3, int n2) {
        return false;
    }

    public TypeInfo getSchemaTypeInfo() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this;
    }

    public void setReadOnly(boolean bl2, boolean bl3) {
        super.setReadOnly(bl2, bl3);
        if (this.attributes != null) {
            this.attributes.setReadOnly(bl2, true);
        }
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        boolean bl2 = this.ownerDocument.getMutationEvents();
        this.ownerDocument.setMutationEvents(false);
        this.setupDefaultAttributes();
        this.ownerDocument.setMutationEvents(bl2);
    }

    void moveSpecifiedAttributes(ElementImpl elementImpl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (elementImpl.hasAttributes()) {
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            this.attributes.moveSpecifiedAttributes(elementImpl.attributes);
        }
    }

    protected void setupDefaultAttributes() {
        NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
        if (namedNodeMapImpl != null) {
            this.attributes = new AttributeMap(this, namedNodeMapImpl);
        }
    }

    protected void reconcileDefaultAttributes() {
        if (this.attributes != null) {
            NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
            this.attributes.reconcileDefaults(namedNodeMapImpl);
        }
    }

    protected NamedNodeMapImpl getDefaultAttributes() {
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (documentTypeImpl == null) {
            return null;
        }
        ElementDefinitionImpl elementDefinitionImpl = (ElementDefinitionImpl)documentTypeImpl.getElements().getNamedItem(this.getNodeName());
        if (elementDefinitionImpl == null) {
            return null;
        }
        return (NamedNodeMapImpl)elementDefinitionImpl.getAttributes();
    }
}

