/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.math.BigInteger;
import java.util.ArrayList;
import org.python.antlr.ErrorHandler;
import org.python.antlr.PythonParser;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.Context;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.boolopType;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keyword;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.unaryopType;
import org.python.antlr.base.excepthandler;
import org.python.antlr.base.expr;
import org.python.antlr.base.slice;
import org.python.antlr.base.stmt;
import org.python.antlr.runtime.Token;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.codecs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarActions {
    private ErrorHandler errorHandler = null;

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    String makeFromText(java.util.List dots, java.util.List<Name> names) {
        StringBuilder d2 = new StringBuilder();
        d2.append(PythonTree.dottedNameListToString(names));
        return d2.toString();
    }

    java.util.List<Name> makeModuleNameNode(java.util.List dots, java.util.List<Name> names) {
        ArrayList<Name> result = new ArrayList<Name>();
        if (dots != null) {
            for (Object o2 : dots) {
                Token tok = (Token)o2;
                result.add(new Name(tok, tok.getText(), expr_contextType.Load));
            }
        }
        if (null != names) {
            result.addAll(names);
        }
        return result;
    }

    java.util.List<Name> makeDottedName(Token top, java.util.List<PythonTree> attrs) {
        ArrayList<Name> result = new ArrayList<Name>();
        result.add(new Name(top, top.getText(), expr_contextType.Load));
        if (attrs != null) {
            for (PythonTree attr : attrs) {
                Token token2 = attr.getToken();
                result.add(new Name(token2, token2.getText(), expr_contextType.Load));
            }
        }
        return result;
    }

    int makeLevel(java.util.List lev) {
        if (lev == null) {
            return 0;
        }
        return lev.size();
    }

    java.util.List<alias> makeStarAlias(Token t2) {
        ArrayList<alias> result = new ArrayList<alias>();
        result.add(new alias(t2, "*", null));
        return result;
    }

    java.util.List<alias> makeAliases(java.util.List<alias> atypes) {
        if (atypes == null) {
            return new ArrayList<alias>();
        }
        return atypes;
    }

    java.util.List<expr> makeBases(expr etype) {
        ArrayList<expr> result = new ArrayList<expr>();
        if (etype != null) {
            if (etype instanceof Tuple) {
                return ((Tuple)etype).getInternalElts();
            }
            result.add(etype);
        }
        return result;
    }

    java.util.List<String> makeNames(java.util.List names) {
        ArrayList<String> s2 = new ArrayList<String>();
        for (int i2 = 0; i2 < names.size(); ++i2) {
            s2.add(((Token)names.get(i2)).getText());
        }
        return s2;
    }

    Name makeNameNode(Token t2) {
        if (t2 == null) {
            return null;
        }
        return new Name(t2, t2.getText(), expr_contextType.Load);
    }

    java.util.List<Name> makeNameNodes(java.util.List<Token> names) {
        ArrayList<Name> s2 = new ArrayList<Name>();
        for (int i2 = 0; i2 < names.size(); ++i2) {
            s2.add(this.makeNameNode(names.get(i2)));
        }
        return s2;
    }

    void errorGenExpNotSoleArg(PythonTree t2) {
        this.errorHandler.error("Generator expression must be parenthesized if not sole argument", t2);
    }

    expr castExpr(Object o2) {
        if (o2 instanceof expr) {
            return (expr)o2;
        }
        if (o2 instanceof PythonTree) {
            return this.errorHandler.errorExpr((PythonTree)o2);
        }
        return null;
    }

    java.util.List<expr> castExprs(java.util.List exprs) {
        return this.castExprs(exprs, 0);
    }

    java.util.List<expr> castExprs(java.util.List exprs, int start) {
        ArrayList<expr> result = new ArrayList<expr>();
        if (exprs != null) {
            for (int i2 = start; i2 < exprs.size(); ++i2) {
                Object o2 = exprs.get(i2);
                if (o2 instanceof expr) {
                    result.add((expr)o2);
                    continue;
                }
                if (!(o2 instanceof PythonParser.test_return)) continue;
                result.add((expr)((PythonParser.test_return)o2).tree);
            }
        }
        return result;
    }

    java.util.List<stmt> makeElse(java.util.List elseSuite, PythonTree elif) {
        if (elseSuite != null) {
            return this.castStmts(elseSuite);
        }
        if (elif == null) {
            return new ArrayList<stmt>();
        }
        ArrayList<stmt> s2 = new ArrayList<stmt>();
        s2.add(this.castStmt(elif));
        return s2;
    }

    stmt castStmt(Object o2) {
        if (o2 instanceof stmt) {
            return (stmt)o2;
        }
        if (o2 instanceof PythonParser.stmt_return) {
            return (stmt)((PythonParser.stmt_return)o2).tree;
        }
        if (o2 instanceof PythonTree) {
            return this.errorHandler.errorStmt((PythonTree)o2);
        }
        return null;
    }

    java.util.List<stmt> castStmts(PythonTree t2) {
        stmt s2 = (stmt)t2;
        ArrayList<stmt> stmts = new ArrayList<stmt>();
        stmts.add(s2);
        return stmts;
    }

    java.util.List<stmt> castStmts(java.util.List stmts) {
        if (stmts != null) {
            ArrayList<stmt> result = new ArrayList<stmt>();
            for (Object o2 : stmts) {
                result.add(this.castStmt(o2));
            }
            return result;
        }
        return new ArrayList<stmt>();
    }

    expr makeDottedAttr(Token nameToken, java.util.List attrs) {
        expr current = new Name(nameToken, nameToken.getText(), expr_contextType.Load);
        for (Object o2 : attrs) {
            Token t2 = (Token)o2;
            current = new Attribute(t2, current, this.cantBeNoneName(t2), expr_contextType.Load);
        }
        return current;
    }

    stmt makeWhile(Token t2, expr test, java.util.List body, java.util.List orelse) {
        if (test == null) {
            return this.errorHandler.errorStmt(new PythonTree(t2));
        }
        java.util.List<stmt> o2 = this.castStmts(orelse);
        java.util.List<stmt> b2 = this.castStmts(body);
        return new While(t2, test, b2, o2);
    }

    stmt makeFor(Token t2, expr target, expr iter, java.util.List body, java.util.List orelse) {
        if (target == null || iter == null) {
            return this.errorHandler.errorStmt(new PythonTree(t2));
        }
        this.cantBeNone(target);
        java.util.List<stmt> o2 = this.castStmts(orelse);
        java.util.List<stmt> b2 = this.castStmts(body);
        return new For(t2, target, iter, b2, o2);
    }

    stmt makeTryExcept(Token t2, java.util.List body, java.util.List<excepthandler> handlers2, java.util.List orelse, java.util.List finBody) {
        java.util.List<stmt> b2 = this.castStmts(body);
        java.util.List<excepthandler> e2 = handlers2;
        java.util.List<stmt> o2 = this.castStmts(orelse);
        TryExcept te = new TryExcept(t2, b2, e2, o2);
        if (finBody == null) {
            return te;
        }
        java.util.List<stmt> f2 = this.castStmts(finBody);
        ArrayList<stmt> mainBody = new ArrayList<stmt>();
        mainBody.add(te);
        return new TryFinally(t2, mainBody, f2);
    }

    TryFinally makeTryFinally(Token t2, java.util.List body, java.util.List finBody) {
        java.util.List<stmt> b2 = this.castStmts(body);
        java.util.List<stmt> f2 = this.castStmts(finBody);
        return new TryFinally(t2, b2, f2);
    }

    stmt makeFuncdef(Token t2, Token nameToken, arguments args, java.util.List funcStatements, java.util.List decorators) {
        if (nameToken == null) {
            return this.errorHandler.errorStmt(new PythonTree(t2));
        }
        Name n2 = this.cantBeNoneName(nameToken);
        arguments a2 = args != null ? args : new arguments(t2, new ArrayList<expr>(), (Name)null, null, new ArrayList<expr>());
        java.util.List<stmt> s2 = this.castStmts(funcStatements);
        java.util.List<expr> d2 = this.castExprs(decorators);
        return new FunctionDef(t2, n2, a2, s2, d2);
    }

    java.util.List<expr> makeAssignTargets(expr lhs, java.util.List rhs) {
        ArrayList<expr> e2 = new ArrayList<expr>();
        this.checkAssign(lhs);
        e2.add(lhs);
        for (int i2 = 0; i2 < rhs.size() - 1; ++i2) {
            expr r2 = this.castExpr(rhs.get(i2));
            this.checkAssign(r2);
            e2.add(r2);
        }
        return e2;
    }

    expr makeAssignValue(java.util.List rhs) {
        expr value = this.castExpr(rhs.get(rhs.size() - 1));
        this.recurseSetContext(value, expr_contextType.Load);
        return value;
    }

    void recurseSetContext(PythonTree tree, expr_contextType context) {
        if (tree instanceof Context) {
            ((Context)((Object)tree)).setContext(context);
        }
        if (tree instanceof GeneratorExp) {
            GeneratorExp g2 = (GeneratorExp)tree;
            this.recurseSetContext(g2.getInternalElt(), context);
        } else if (tree instanceof ListComp) {
            ListComp lc = (ListComp)tree;
            this.recurseSetContext(lc.getInternalElt(), context);
        } else if (!(tree instanceof ListComp)) {
            for (int i2 = 0; i2 < tree.getChildCount(); ++i2) {
                this.recurseSetContext(tree.getChild(i2), context);
            }
        }
    }

    arguments makeArgumentsType(Token t2, java.util.List params, Token snameToken, Token knameToken, java.util.List defaults) {
        java.util.List<expr> p2 = this.castExprs(params);
        java.util.List<expr> d2 = this.castExprs(defaults);
        Name s2 = snameToken == null ? null : this.cantBeNoneName(snameToken);
        Name k2 = knameToken == null ? null : this.cantBeNoneName(knameToken);
        return new arguments(t2, p2, s2, k2, d2);
    }

    java.util.List<expr> extractArgs(java.util.List args) {
        return this.castExprs(args);
    }

    java.util.List<keyword> makeKeywords(java.util.List args) {
        ArrayList<keyword> k2 = new ArrayList<keyword>();
        if (args != null) {
            for (int i2 = 0; i2 < args.size(); ++i2) {
                java.util.List e2 = (java.util.List)args.get(i2);
                this.checkAssign(this.castExpr(e2.get(0)));
                if (e2.get(0) instanceof Name) {
                    Name arg = (Name)e2.get(0);
                    k2.add(new keyword(arg, arg.getInternalId(), this.castExpr(e2.get(1))));
                    continue;
                }
                this.errorHandler.error("keyword must be a name", (PythonTree)e2.get(0));
            }
        }
        return k2;
    }

    Object makeFloat(Token t2) {
        return Py.newFloat(Double.valueOf(t2.getText()));
    }

    Object makeComplex(Token t2) {
        String s2 = t2.getText();
        s2 = s2.substring(0, s2.length() - 1);
        return Py.newImaginary(Double.valueOf(s2));
    }

    Object makeInt(Token t2) {
        int i2;
        String s2 = t2.getText();
        int radix = 10;
        if (s2.startsWith("0x") || s2.startsWith("0X")) {
            radix = 16;
            s2 = s2.substring(2, s2.length());
        } else if (s2.startsWith("0")) {
            radix = 8;
        }
        if (s2.endsWith("L") || s2.endsWith("l")) {
            s2 = s2.substring(0, s2.length() - 1);
            return Py.newLong(new BigInteger(s2, radix));
        }
        int ndigits = s2.length();
        for (i2 = 0; i2 < ndigits && s2.charAt(i2) == '0'; ++i2) {
        }
        if (ndigits - i2 > 11) {
            return Py.newLong(new BigInteger(s2, radix));
        }
        long l2 = Long.valueOf(s2, radix);
        if (l2 > 0xFFFFFFFFL || l2 > Integer.MAX_VALUE) {
            return Py.newLong(new BigInteger(s2, radix));
        }
        return Py.newInteger((int)l2);
    }

    PyString extractStrings(java.util.List s2, String encoding) {
        boolean ustring = false;
        Token last2 = null;
        StringBuffer sb = new StringBuffer();
        for (Token last2 : s2) {
            StringPair sp = this.extractString(last2, encoding);
            if (sp.isUnicode()) {
                ustring = true;
            }
            sb.append(sp.getString());
        }
        if (ustring) {
            return new PyUnicode(sb.toString());
        }
        return new PyString(sb.toString());
    }

    /*
     * WARNING - void declaration
     */
    StringPair extractString(Token t2, String encoding) {
        void end;
        String string2 = t2.getText();
        char quoteChar = string2.charAt(0);
        int start = 0;
        boolean bl2 = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            bl2 = true;
            ++start;
        }
        quoteChar = string2.charAt(start);
        boolean ustring = false;
        if (quoteChar == 'r' || quoteChar == 'R') {
            ustring = true;
            ++start;
        }
        int raw = 3;
        if (string2.length() - start == 2) {
            raw = 1;
        }
        if (string2.charAt(start) != string2.charAt(start + 1)) {
            raw = 1;
        }
        start = raw + start;
        int quotes = string2.length() - raw;
        if (end == false && encoding != null) {
            string2 = new PyUnicode(string2.substring(start, quotes)).encode(encoding);
            if (!ustring) {
                string2 = PyString.decode_UnicodeEscape(string2, 0, string2.length(), "strict", (boolean)end);
            }
        } else if (ustring) {
            string2 = string2.substring(start, quotes);
            if (end != false) {
                string2 = codecs.PyUnicode_DecodeRawUnicodeEscape(string2, "strict");
            }
        } else {
            string2 = PyString.decode_UnicodeEscape(string2, start, quotes, "strict", (boolean)end);
        }
        return new StringPair(string2, (boolean)end);
    }

    Token extractStringToken(java.util.List s2) {
        return (Token)s2.get(0);
    }

    expr makeCall(Token t2, expr func) {
        return this.makeCall(t2, func, null, null, null, null);
    }

    expr makeCall(Token t2, expr func, java.util.List args, java.util.List keywords, expr starargs, expr kwargs) {
        if (func == null) {
            return this.errorHandler.errorExpr(new PythonTree(t2));
        }
        java.util.List<keyword> k2 = this.makeKeywords(keywords);
        java.util.List<expr> a2 = this.castExprs(args);
        return new Call(t2, func, a2, k2, starargs, kwargs);
    }

    expr negate(Token t2, expr o2) {
        return this.negate(new PythonTree(t2), o2);
    }

    expr negate(PythonTree t2, expr o2) {
        if (o2 instanceof Num) {
            double d2;
            Num num = (Num)o2;
            if (num.getInternalN() instanceof PyInteger) {
                int v2 = ((PyInteger)num.getInternalN()).getValue();
                if (v2 >= 0) {
                    num.setN(new PyInteger(-v2));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyLong) {
                BigInteger v3 = ((PyLong)num.getInternalN()).getValue();
                if (v3.compareTo(BigInteger.ZERO) == 1) {
                    num.setN(new PyLong(v3.negate()));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyFloat) {
                double d3 = ((PyFloat)num.getInternalN()).getValue();
                if (d3 >= 0.0) {
                    num.setN(new PyFloat(-d3));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyComplex && (d2 = ((PyComplex)num.getInternalN()).imag) >= 0.0) {
                num.setN(new PyComplex(0.0, -d2));
                return num;
            }
        }
        return new UnaryOp(t2, unaryopType.USub, o2);
    }

    String cantBeNone(Token t2) {
        if (t2 == null || t2.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t2));
        }
        return t2.getText();
    }

    Name cantBeNoneName(Token t2) {
        if (t2 == null || t2.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t2));
        }
        return new Name(t2, t2.getText(), expr_contextType.Load);
    }

    void cantBeNone(PythonTree e2) {
        if (e2.getText().equals("None")) {
            this.errorHandler.error("can't be None", e2);
        }
    }

    void checkAssign(expr e2) {
        block4: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block3: {
                                                                if (!(e2 instanceof Name) || !((Name)e2).getInternalId().equals("None")) break block3;
                                                                this.errorHandler.error("assignment to None", e2);
                                                                break block4;
                                                            }
                                                            if (!(e2 instanceof GeneratorExp)) break block5;
                                                            this.errorHandler.error("can't assign to generator expression", e2);
                                                            break block4;
                                                        }
                                                        if (!(e2 instanceof Num)) break block6;
                                                        this.errorHandler.error("can't assign to number", e2);
                                                        break block4;
                                                    }
                                                    if (!(e2 instanceof Str)) break block7;
                                                    this.errorHandler.error("can't assign to string", e2);
                                                    break block4;
                                                }
                                                if (!(e2 instanceof Yield)) break block8;
                                                this.errorHandler.error("can't assign to yield expression", e2);
                                                break block4;
                                            }
                                            if (!(e2 instanceof BinOp)) break block9;
                                            this.errorHandler.error("can't assign to operator", e2);
                                            break block4;
                                        }
                                        if (!(e2 instanceof BoolOp)) break block10;
                                        this.errorHandler.error("can't assign to operator", e2);
                                        break block4;
                                    }
                                    if (!(e2 instanceof Lambda)) break block11;
                                    this.errorHandler.error("can't assign to lambda", e2);
                                    break block4;
                                }
                                if (!(e2 instanceof Call)) break block12;
                                this.errorHandler.error("can't assign to function call", e2);
                                break block4;
                            }
                            if (!(e2 instanceof Repr)) break block13;
                            this.errorHandler.error("can't assign to repr", e2);
                            break block4;
                        }
                        if (!(e2 instanceof IfExp)) break block14;
                        this.errorHandler.error("can't assign to conditional expression", e2);
                        break block4;
                    }
                    if (!(e2 instanceof ListComp)) break block15;
                    this.errorHandler.error("can't assign to list comprehension", e2);
                    break block4;
                }
                if (!(e2 instanceof Tuple)) break block16;
                java.util.List<expr> elts = ((Tuple)e2).getInternalElts();
                if (elts.size() == 0) {
                    this.errorHandler.error("can't assign to ()", e2);
                }
                for (int i2 = 0; i2 < elts.size(); ++i2) {
                    this.checkAssign(elts.get(i2));
                }
                break block4;
            }
            if (!(e2 instanceof List)) break block4;
            java.util.List<expr> elts = ((List)e2).getInternalElts();
            for (int i3 = 0; i3 < elts.size(); ++i3) {
                this.checkAssign(elts.get(i3));
            }
        }
    }

    java.util.List<expr> makeDeleteList(java.util.List deletes) {
        java.util.List<expr> exprs = this.castExprs(deletes);
        for (expr e2 : exprs) {
            this.checkDelete(e2);
        }
        return exprs;
    }

    void checkDelete(expr e2) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            if (!(e2 instanceof Call)) break block3;
                            this.errorHandler.error("can't delete function call", e2);
                            break block4;
                        }
                        if (!(e2 instanceof Num)) break block5;
                        this.errorHandler.error("can't delete number", e2);
                        break block4;
                    }
                    if (!(e2 instanceof Str)) break block6;
                    this.errorHandler.error("can't delete string", e2);
                    break block4;
                }
                if (!(e2 instanceof Tuple)) break block7;
                java.util.List<expr> elts = ((Tuple)e2).getInternalElts();
                if (elts.size() == 0) {
                    this.errorHandler.error("can't delete ()", e2);
                }
                for (int i2 = 0; i2 < elts.size(); ++i2) {
                    this.checkDelete(elts.get(i2));
                }
                break block4;
            }
            if (!(e2 instanceof List)) break block4;
            java.util.List<expr> elts = ((List)e2).getInternalElts();
            for (int i3 = 0; i3 < elts.size(); ++i3) {
                this.checkDelete(elts.get(i3));
            }
        }
    }

    slice makeSubscript(PythonTree lower, Token colon, PythonTree upper, PythonTree sliceop) {
        boolean isSlice = false;
        expr s2 = null;
        expr e2 = null;
        expr o2 = null;
        if (lower != null) {
            s2 = this.castExpr(lower);
        }
        if (colon != null) {
            isSlice = true;
            if (upper != null) {
                e2 = this.castExpr(upper);
            }
        }
        if (sliceop != null) {
            isSlice = true;
            o2 = sliceop != null ? this.castExpr(sliceop) : new Name(sliceop, "None", expr_contextType.Load);
        }
        PythonTree tok = lower;
        if (lower == null) {
            tok = new PythonTree(colon);
        }
        if (isSlice) {
            return new Slice(tok, s2, e2, o2);
        }
        return new Index(tok, s2);
    }

    java.util.List<cmpopType> makeCmpOps(java.util.List cmps) {
        ArrayList<cmpopType> result = new ArrayList<cmpopType>();
        if (cmps != null) {
            for (Object o2 : cmps) {
                result.add((cmpopType)((Object)o2));
            }
        }
        return result;
    }

    BoolOp makeBoolOp(Token t2, PythonTree left, boolopType op, java.util.List right) {
        ArrayList<PythonTree> values = new ArrayList<PythonTree>();
        values.add(left);
        values.addAll(right);
        return new BoolOp(t2, op, this.castExprs(values));
    }

    BinOp makeBinOp(Token t2, PythonTree left, operatorType op, java.util.List rights) {
        BinOp current = new BinOp(t2, this.castExpr(left), op, this.castExpr(rights.get(0)));
        for (int i2 = 1; i2 < rights.size(); ++i2) {
            expr right = this.castExpr(rights.get(i2));
            current = new BinOp(left, (expr)current, op, right);
        }
        return current;
    }

    BinOp makeBinOp(Token t2, PythonTree left, java.util.List ops, java.util.List rights, java.util.List toks) {
        BinOp current = new BinOp(t2, this.castExpr(left), (operatorType)((Object)ops.get(0)), this.castExpr(rights.get(0)));
        for (int i2 = 1; i2 < rights.size(); ++i2) {
            expr right = this.castExpr(rights.get(i2));
            operatorType op = (operatorType)((Object)ops.get(i2));
            current = new BinOp((Token)toks.get(i2), (expr)current, op, right);
        }
        return current;
    }

    java.util.List<slice> castSlices(java.util.List slices) {
        ArrayList<slice> result = new ArrayList<slice>();
        if (slices != null) {
            for (Object o2 : slices) {
                result.add(this.castSlice(o2));
            }
        }
        return result;
    }

    slice castSlice(Object o2) {
        if (o2 instanceof slice) {
            return (slice)o2;
        }
        return this.errorHandler.errorSlice((PythonTree)o2);
    }

    slice makeSliceType(Token begin, Token c1, Token c2, java.util.List sltypes) {
        boolean isTuple = false;
        if (c1 != null || c2 != null) {
            isTuple = true;
        }
        slice s2 = null;
        boolean extslice = false;
        if (isTuple) {
            ArrayList<expr> arrayList = new ArrayList<expr>();
            for (Object i$ : sltypes) {
                if (i$ instanceof Index) {
                    Index o2 = (Index)i$;
                    arrayList.add(o2.getInternalValue());
                    continue;
                }
                extslice = true;
                break;
            }
            if (!extslice) {
                Tuple etypes = new Tuple(begin, arrayList, expr_contextType.Load);
                s2 = new Index(begin, (expr)etypes);
            }
        } else if (sltypes.size() == 1) {
            s2 = this.castSlice(sltypes.get(0));
        } else if (sltypes.size() != 0) {
            extslice = true;
        }
        if (extslice) {
            java.util.List<slice> list = this.castSlices(sltypes);
            s2 = new ExtSlice(begin, list);
        }
        return s2;
    }

    class StringPair {
        private String s;
        private boolean unicode;

        StringPair(String s2, boolean unicode) {
            this.s = s2;
            this.unicode = unicode;
        }

        String getString() {
            return this.s;
        }

        boolean isUnicode() {
            return this.unicode;
        }
    }
}

