/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc3g;

import java.sql.SQLException;
import java.util.UUID;
import org.postgresql.jdbc3.AbstractJdbc3Connection;
import org.postgresql.jdbc3.AbstractJdbc3Statement;
import org.postgresql.util.ByteConverter;

public abstract class AbstractJdbc3gStatement
extends AbstractJdbc3Statement {
    public AbstractJdbc3gStatement(AbstractJdbc3Connection c2, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(c2, rsType, rsConcurrency, rsHoldability);
    }

    public AbstractJdbc3gStatement(AbstractJdbc3Connection connection, String sql, boolean isCallable, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, isCallable, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    public void setObject(int parameterIndex, Object x2) throws SQLException {
        if (x2 instanceof UUID && this.connection.haveMinimumServerVersion("8.3")) {
            this.setUuid(parameterIndex, (UUID)x2);
        } else {
            super.setObject(parameterIndex, x2);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        if (targetSqlType == 1111 && x2 instanceof UUID && this.connection.haveMinimumServerVersion("8.3")) {
            this.setUuid(parameterIndex, (UUID)x2);
        } else {
            super.setObject(parameterIndex, x2, targetSqlType, scale);
        }
    }

    private void setUuid(int parameterIndex, UUID uuid2) throws SQLException {
        if (this.connection.binaryTransferSend(2950)) {
            byte[] val = new byte[16];
            ByteConverter.int8(val, 0, uuid2.getMostSignificantBits());
            ByteConverter.int8(val, 8, uuid2.getLeastSignificantBits());
            this.bindBytes(parameterIndex, val, 2950);
        } else {
            this.bindLiteral(parameterIndex, uuid2.toString(), 2950);
        }
    }
}

