/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.lang.ref.PhantomReference;
import org.postgresql.core.Field;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Parser;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.V3Query;

class SimpleQuery
implements V3Query {
    private final String[] fragments;
    private final ProtocolConnectionImpl protoConnection;
    private String statementName;
    private byte[] encodedStatementName;
    private Field[] fields;
    private boolean portalDescribed;
    private boolean statementDescribed;
    private PhantomReference cleanupRef;
    private int[] preparedTypes;
    private Integer cachedMaxResultRowSize;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0, null);

    SimpleQuery(String[] fragments, ProtocolConnectionImpl protoConnection) {
        this.fragments = this.unmarkDoubleQuestion(fragments, protoConnection);
        this.protoConnection = protoConnection;
    }

    @Override
    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1, this.protoConnection);
    }

    @Override
    public String toString(ParameterList parameters) {
        StringBuilder sbuf = new StringBuilder(this.fragments[0]);
        for (int i2 = 1; i2 < this.fragments.length; ++i2) {
            if (parameters == null) {
                sbuf.append('?');
            } else {
                sbuf.append(parameters.toString(i2));
            }
            sbuf.append(this.fragments[i2]);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public void close() {
        this.unprepare();
    }

    @Override
    public SimpleQuery[] getSubqueries() {
        return null;
    }

    public int getMaxResultRowSize() {
        if (this.cachedMaxResultRowSize != null) {
            return this.cachedMaxResultRowSize;
        }
        if (!this.statementDescribed) {
            throw new IllegalStateException("Cannot estimate result row size on a statement that is not described");
        }
        int maxResultRowSize = 0;
        if (this.fields != null) {
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                Field f2 = this.fields[i2];
                int fieldLength = f2.getLength();
                if (fieldLength < 1 || fieldLength >= 65535) {
                    maxResultRowSize = -1;
                    break;
                }
                maxResultRowSize += fieldLength;
            }
        }
        this.cachedMaxResultRowSize = maxResultRowSize;
        return maxResultRowSize;
    }

    String[] getFragments() {
        return this.fragments;
    }

    String[] unmarkDoubleQuestion(String[] fragments, ProtocolConnectionImpl protoConnection) {
        if (fragments != null && protoConnection != null) {
            boolean standardConformingStrings = protoConnection.getStandardConformingStrings();
            for (int i2 = 0; i2 < fragments.length; ++i2) {
                if (fragments[i2] == null) continue;
                fragments[i2] = Parser.unmarkDoubleQuestion(fragments[i2], standardConformingStrings);
            }
        }
        return fragments;
    }

    void setStatementName(String statementName) {
        this.statementName = statementName;
        this.encodedStatementName = Utils.encodeUTF8(statementName);
    }

    void setStatementTypes(int[] paramTypes) {
        this.preparedTypes = paramTypes;
    }

    int[] getStatementTypes() {
        return this.preparedTypes;
    }

    String getStatementName() {
        return this.statementName;
    }

    boolean isPreparedFor(int[] paramTypes) {
        if (this.statementName == null) {
            return false;
        }
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (paramTypes[i2] == 0 || paramTypes[i2] == this.preparedTypes[i2]) continue;
            return false;
        }
        return true;
    }

    boolean hasUnresolvedTypes() {
        if (this.preparedTypes == null) {
            return true;
        }
        for (int i2 = 0; i2 < this.preparedTypes.length; ++i2) {
            if (this.preparedTypes[i2] != 0) continue;
            return true;
        }
        return false;
    }

    byte[] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setFields(Field[] fields) {
        this.fields = fields;
        this.cachedMaxResultRowSize = null;
    }

    Field[] getFields() {
        return this.fields;
    }

    boolean isPortalDescribed() {
        return this.portalDescribed;
    }

    void setPortalDescribed(boolean portalDescribed) {
        this.portalDescribed = portalDescribed;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isStatementDescribed() {
        return this.statementDescribed;
    }

    void setStatementDescribed(boolean statementDescribed) {
        this.statementDescribed = statementDescribed;
        this.cachedMaxResultRowSize = null;
    }

    @Override
    public boolean isEmpty() {
        return this.fragments.length == 1 && "".equals(this.fragments[0]);
    }

    void setCleanupRef(PhantomReference cleanupRef) {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
        }
        this.cleanupRef = cleanupRef;
    }

    void unprepare() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
        this.statementName = null;
        this.encodedStatementName = null;
        this.fields = null;
        this.portalDescribed = false;
        this.statementDescribed = false;
        this.cachedMaxResultRowSize = null;
    }
}

