/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Utils {
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i2 = 0; i2 < data.length; ++i2) {
            sb.append(Integer.toHexString(data[i2] >> 4 & 0xF));
            sb.append(Integer.toHexString(data[i2] & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        ByteBuffer buf = utf8Charset.encode(CharBuffer.wrap(str));
        byte[] b2 = new byte[buf.limit()];
        buf.get(b2, 0, buf.limit());
        return b2;
    }

    public static StringBuffer appendEscapedLiteral(StringBuffer sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(value.length() * 11 / 10);
        }
        Utils.doAppendEscapedLiteral(sbuf, value, standardConformingStrings);
        return sbuf;
    }

    public static StringBuilder escapeLiteral(StringBuilder sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(value.length() * 11 / 10);
        }
        Utils.doAppendEscapedLiteral(sbuf, value, standardConformingStrings);
        return sbuf;
    }

    private static void doAppendEscapedLiteral(Appendable sbuf, String value, boolean standardConformingStrings) throws SQLException {
        try {
            if (standardConformingStrings) {
                for (int i2 = 0; i2 < value.length(); ++i2) {
                    char ch2 = value.charAt(i2);
                    if (ch2 == '\u0000') {
                        throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch2 == '\'') {
                        sbuf.append('\'');
                    }
                    sbuf.append(ch2);
                }
            } else {
                for (int i3 = 0; i3 < value.length(); ++i3) {
                    char ch3 = value.charAt(i3);
                    if (ch3 == '\u0000') {
                        throw new PSQLException(GT.tr("Zero bytes may not occur in string parameters."), PSQLState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch3 == '\\' || ch3 == '\'') {
                        sbuf.append(ch3);
                    }
                    sbuf.append(ch3);
                }
            }
        }
        catch (IOException e2) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder"), PSQLState.UNEXPECTED_ERROR, (Throwable)e2);
        }
    }

    public static StringBuffer appendEscapedIdentifier(StringBuffer sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuffer(2 + value.length() * 11 / 10);
        }
        Utils.doAppendEscapedIdentifier(sbuf, value);
        return sbuf;
    }

    public static StringBuilder escapeIdentifier(StringBuilder sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(2 + value.length() * 11 / 10);
        }
        Utils.doAppendEscapedIdentifier(sbuf, value);
        return sbuf;
    }

    private static void doAppendEscapedIdentifier(Appendable sbuf, String value) throws SQLException {
        try {
            sbuf.append('\"');
            for (int i2 = 0; i2 < value.length(); ++i2) {
                char ch2 = value.charAt(i2);
                if (ch2 == '\u0000') {
                    throw new PSQLException(GT.tr("Zero bytes may not occur in identifiers."), PSQLState.INVALID_PARAMETER_VALUE);
                }
                if (ch2 == '\"') {
                    sbuf.append(ch2);
                }
                sbuf.append(ch2);
            }
            sbuf.append('\"');
        }
        catch (IOException e2) {
            throw new PSQLException(GT.tr("No IOException expected from StringBuffer or StringBuilder"), PSQLState.UNEXPECTED_ERROR, (Throwable)e2);
        }
    }

    public static int parseServerVersionStr(String serverVersion) throws NumberFormatException {
        NumberFormat numformat = NumberFormat.getIntegerInstance();
        numformat.setGroupingUsed(false);
        ParsePosition parsepos = new ParsePosition(0);
        if (serverVersion == null) {
            return 0;
        }
        Long parsed = (Long)numformat.parseObject(serverVersion, parsepos);
        if (parsed == null) {
            return 0;
        }
        if (parsed.intValue() >= 10000) {
            if (parsepos.getIndex() == serverVersion.length()) {
                return parsed.intValue();
            }
            throw new NumberFormatException("First major-version part equal to or greater than 10000 in invalid version string: " + serverVersion);
        }
        int vers = parsed.intValue() * 10000;
        if (parsepos.getIndex() == serverVersion.length()) {
            return 0;
        }
        if (serverVersion.charAt(parsepos.getIndex()) != '.') {
            return 0;
        }
        parsepos.setIndex(parsepos.getIndex() + 1);
        parsed = (Long)numformat.parseObject(serverVersion, parsepos);
        if (parsed == null) {
            return 0;
        }
        if (parsed.intValue() > 99) {
            throw new NumberFormatException("Unsupported second part of major version > 99 in invalid version string: " + serverVersion);
        }
        vers += parsed.intValue() * 100;
        if (parsepos.getIndex() == serverVersion.length()) {
            return vers;
        }
        if (serverVersion.charAt(parsepos.getIndex()) != '.') {
            return vers;
        }
        parsepos.setIndex(parsepos.getIndex() + 1);
        parsed = (Long)numformat.parseObject(serverVersion, parsepos);
        if (parsed != null) {
            if (parsed.intValue() > 99) {
                throw new NumberFormatException("Unsupported minor version value > 99 in invalid version string: " + serverVersion);
            }
            vers += parsed.intValue();
        }
        return vers;
    }
}

