/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import org.apache.batik.util.EncodingUtilities;
import org.apache.batik.xml.XMLCharacters;

public class XMLUtilities
extends XMLCharacters {
    public static final int IS_XML_10_NAME = 1;
    public static final int IS_XML_10_QNAME = 2;

    protected XMLUtilities() {
    }

    public static boolean isXMLSpace(char c2) {
        return c2 <= ' ' && (4294977024L >> c2 & 1L) != 0L;
    }

    public static boolean isXMLNameFirstCharacter(char c2) {
        return (NAME_FIRST_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXML11NameFirstCharacter(char c2) {
        return (NAME11_FIRST_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLNameCharacter(char c2) {
        return (NAME_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXML11NameCharacter(char c2) {
        return (NAME11_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLCharacter(int n2) {
        return (XML_CHARACTER[n2 >>> 5] & 1 << (n2 & 0x1F)) != 0 || n2 >= 65536 && n2 <= 0x10FFFF;
    }

    public static boolean isXML11Character(int n2) {
        return n2 >= 1 && n2 <= 55295 || n2 >= 57344 && n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF;
    }

    public static boolean isXMLPublicIdCharacter(char c2) {
        return c2 < '\u0080' && (PUBLIC_ID_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLVersionCharacter(char c2) {
        return c2 < '\u0080' && (VERSION_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static boolean isXMLAlphabeticCharacter(char c2) {
        return c2 < '\u0080' && (ALPHABETIC_CHARACTER[c2 / 32] & 1 << c2 % 32) != 0;
    }

    public static int testXMLQName(String string2) {
        int n2 = 2;
        boolean bl2 = false;
        int n3 = string2.length();
        if (n3 == 0) {
            return 0;
        }
        char c2 = string2.charAt(0);
        if (!XMLUtilities.isXMLNameFirstCharacter(c2)) {
            return 0;
        }
        if (c2 == ':') {
            n2 = 0;
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            c2 = string2.charAt(i2);
            if (!XMLUtilities.isXMLNameCharacter(c2)) {
                return 0;
            }
            if (n2 == 0 || c2 != ':') continue;
            if (bl2 || i2 == n3 - 1) {
                n2 = 0;
                continue;
            }
            bl2 = true;
        }
        return 1 | n2;
    }

    public static Reader createXMLDocumentReader(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 128);
        byte[] byArray = new byte[4];
        int n2 = pushbackInputStream.read(byArray);
        if (n2 > 0) {
            pushbackInputStream.unread(byArray, 0, n2);
        }
        if (n2 == 4) {
            switch (byArray[0] & 0xFF) {
                case 0: {
                    if (byArray[1] != 60 || byArray[2] != 0 || byArray[3] != 63) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "UnicodeBig");
                }
                case 60: {
                    switch (byArray[1] & 0xFF) {
                        case 0: {
                            if (byArray[2] != 63 || byArray[3] != 0) break;
                            return new InputStreamReader((InputStream)pushbackInputStream, "UnicodeLittle");
                        }
                        case 63: {
                            if (byArray[2] != 120 || byArray[3] != 109) break;
                            Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "UTF8");
                            String string2 = XMLUtilities.getXMLDeclarationEncoding(reader, "UTF8");
                            return new InputStreamReader((InputStream)pushbackInputStream, string2);
                        }
                    }
                    break;
                }
                case 76: {
                    if (byArray[1] != 111 || (byArray[2] & 0xFF) != 167 || (byArray[3] & 0xFF) != 148) break;
                    Reader reader = XMLUtilities.createXMLDeclarationReader(pushbackInputStream, "CP037");
                    String string3 = XMLUtilities.getXMLDeclarationEncoding(reader, "CP037");
                    return new InputStreamReader((InputStream)pushbackInputStream, string3);
                }
                case 254: {
                    if ((byArray[1] & 0xFF) != 255) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "Unicode");
                }
                case 255: {
                    if ((byArray[1] & 0xFF) != 254) break;
                    return new InputStreamReader((InputStream)pushbackInputStream, "Unicode");
                }
            }
        }
        return new InputStreamReader((InputStream)pushbackInputStream, "UTF8");
    }

    protected static Reader createXMLDeclarationReader(PushbackInputStream pushbackInputStream, String string2) throws IOException {
        byte[] byArray = new byte[128];
        int n2 = pushbackInputStream.read(byArray);
        if (n2 > 0) {
            pushbackInputStream.unread(byArray, 0, n2);
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 4, n2), string2);
    }

    protected static String getXMLDeclarationEncoding(Reader reader, String string2) throws IOException {
        int n2 = reader.read();
        if (n2 != 108) {
            return string2;
        }
        n2 = reader.read();
        if (!XMLUtilities.isXMLSpace((char)n2)) {
            return string2;
        }
        while (XMLUtilities.isXMLSpace((char)(n2 = reader.read()))) {
        }
        if (n2 != 118) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 101) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 114) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 115) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 105) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 111) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 110) {
            return string2;
        }
        n2 = reader.read();
        while (XMLUtilities.isXMLSpace((char)n2)) {
            n2 = reader.read();
        }
        if (n2 != 61) {
            return string2;
        }
        while (XMLUtilities.isXMLSpace((char)(n2 = reader.read()))) {
        }
        if (n2 != 34 && n2 != 39) {
            return string2;
        }
        char c2 = (char)n2;
        while ((n2 = reader.read()) != c2) {
            if (XMLUtilities.isXMLVersionCharacter((char)n2)) continue;
            return string2;
        }
        n2 = reader.read();
        if (!XMLUtilities.isXMLSpace((char)n2)) {
            return string2;
        }
        while (XMLUtilities.isXMLSpace((char)(n2 = reader.read()))) {
        }
        if (n2 != 101) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 110) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 99) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 111) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 100) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 105) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 110) {
            return string2;
        }
        n2 = reader.read();
        if (n2 != 103) {
            return string2;
        }
        n2 = reader.read();
        while (XMLUtilities.isXMLSpace((char)n2)) {
            n2 = reader.read();
        }
        if (n2 != 61) {
            return string2;
        }
        while (XMLUtilities.isXMLSpace((char)(n2 = reader.read()))) {
        }
        if (n2 != 34 && n2 != 39) {
            return string2;
        }
        c2 = (char)n2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = reader.read()) != -1) {
            if (n2 == c2) {
                return XMLUtilities.encodingToJavaEncoding(stringBuffer.toString(), string2);
            }
            stringBuffer.append((char)n2);
        }
        return string2;
    }

    public static String encodingToJavaEncoding(String string2, String string3) {
        String string4 = EncodingUtilities.javaEncoding(string2);
        return string4 == null ? string3 : string4;
    }
}

