/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.util.io.AbstractCharDecoder;

public class UTF8Decoder
extends AbstractCharDecoder {
    protected static final byte[] UTF8_BYTES = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0};
    protected int nextChar = -1;

    public UTF8Decoder(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int readChar() throws IOException {
        if (this.nextChar != -1) {
            int n2 = this.nextChar;
            this.nextChar = -1;
            return n2;
        }
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            return -1;
        }
        int n3 = this.buffer[this.position++] & 0xFF;
        switch (UTF8_BYTES[n3]) {
            default: {
                this.charError("UTF-8");
            }
            case 1: {
                return n3;
            }
            case 2: {
                if (this.position == this.count) {
                    this.fillBuffer();
                }
                if (this.count == -1) {
                    this.endOfStreamError("UTF-8");
                }
                return (n3 & 0x1F) << 6 | this.buffer[this.position++] & 0x3F;
            }
            case 3: {
                if (this.position == this.count) {
                    this.fillBuffer();
                }
                if (this.count == -1) {
                    this.endOfStreamError("UTF-8");
                }
                byte by2 = this.buffer[this.position++];
                if (this.position == this.count) {
                    this.fillBuffer();
                }
                if (this.count == -1) {
                    this.endOfStreamError("UTF-8");
                }
                byte by3 = this.buffer[this.position++];
                if ((by2 & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                    this.charError("UTF-8");
                }
                return (n3 & 0x1F) << 12 | (by2 & 0x3F) << 6 | by3 & 0x1F;
            }
            case 4: 
        }
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            this.endOfStreamError("UTF-8");
        }
        byte by4 = this.buffer[this.position++];
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            this.endOfStreamError("UTF-8");
        }
        byte by5 = this.buffer[this.position++];
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            this.endOfStreamError("UTF-8");
        }
        byte by6 = this.buffer[this.position++];
        if ((by4 & 0xC0) != 128 || (by5 & 0xC0) != 128 || (by6 & 0xC0) != 128) {
            this.charError("UTF-8");
        }
        int n4 = (n3 & 0x1F) << 18 | (by4 & 0x3F) << 12 | (by5 & 0x1F) << 6 | by6 & 0x1F;
        this.nextChar = (n4 - 65536) % 1024 + 56320;
        return (n4 - 65536) / 1024 + 55296;
    }
}

