/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class ParsedURLData {
    protected static final String HTTP_USER_AGENT_HEADER = "User-Agent";
    protected static final String HTTP_ACCEPT_HEADER = "Accept";
    protected static final String HTTP_ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    protected static final String HTTP_ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    protected static List acceptedEncodings = new LinkedList();
    public static final byte[] GZIP_MAGIC;
    public String protocol = null;
    public String host = null;
    public int port = -1;
    public String path = null;
    public String ref = null;
    public String contentType = null;
    public String contentEncoding = null;
    public InputStream stream = null;
    public boolean hasBeenOpened = false;
    protected String contentTypeMediaType;
    protected String contentTypeCharset;
    protected URL postConnectionURL;

    public static InputStream checkGZIP(InputStream inputStream) throws IOException {
        int n2;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        byte[] byArray = new byte[2];
        try {
            inputStream.mark(2);
            inputStream.read(byArray);
            inputStream.reset();
        }
        catch (Exception exception) {
            inputStream.reset();
            return inputStream;
        }
        if (byArray[0] == GZIP_MAGIC[0] && byArray[1] == GZIP_MAGIC[1]) {
            return new GZIPInputStream(inputStream);
        }
        if ((byArray[0] & 0xF) == 8 && byArray[0] >>> 4 <= 7 && (n2 = (byArray[0] & 0xFF) * 256 + (byArray[1] & 0xFF)) % 31 == 0) {
            try {
                inputStream.mark(100);
                FilterInputStream filterInputStream = new InflaterInputStream(inputStream);
                if (!((InputStream)filterInputStream).markSupported()) {
                    filterInputStream = new BufferedInputStream(filterInputStream);
                }
                ((InputStream)filterInputStream).mark(2);
                ((InputStream)filterInputStream).read(byArray);
                inputStream.reset();
                filterInputStream = new InflaterInputStream(inputStream);
                return filterInputStream;
            }
            catch (ZipException zipException) {
                inputStream.reset();
                return inputStream;
            }
        }
        return inputStream;
    }

    public ParsedURLData() {
    }

    public ParsedURLData(URL uRL) {
        this.protocol = uRL.getProtocol();
        if (this.protocol != null && this.protocol.length() == 0) {
            this.protocol = null;
        }
        this.host = uRL.getHost();
        if (this.host != null && this.host.length() == 0) {
            this.host = null;
        }
        this.port = uRL.getPort();
        this.path = uRL.getFile();
        if (this.path != null && this.path.length() == 0) {
            this.path = null;
        }
        this.ref = uRL.getRef();
        if (this.ref != null && this.ref.length() == 0) {
            this.ref = null;
        }
    }

    protected URL buildURL() throws MalformedURLException {
        if (this.protocol != null && this.host != null) {
            String string2 = "";
            if (this.path != null) {
                string2 = this.path;
            }
            if (this.port == -1) {
                return new URL(this.protocol, this.host, string2);
            }
            return new URL(this.protocol, this.host, this.port, string2);
        }
        return new URL(this.toString());
    }

    public int hashCode() {
        int n2;
        int n3 = this.port;
        if (this.protocol != null) {
            n3 ^= this.protocol.hashCode();
        }
        if (this.host != null) {
            n3 ^= this.host.hashCode();
        }
        if (this.path != null) {
            n2 = this.path.length();
            n3 = n2 > 20 ? (n3 ^= this.path.substring(n2 - 20).hashCode()) : (n3 ^= this.path.hashCode());
        }
        if (this.ref != null) {
            n2 = this.ref.length();
            n3 = n2 > 20 ? (n3 ^= this.ref.substring(n2 - 20).hashCode()) : (n3 ^= this.ref.hashCode());
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ParsedURLData)) {
            return false;
        }
        ParsedURLData parsedURLData = (ParsedURLData)object;
        if (parsedURLData.port != this.port) {
            return false;
        }
        if (parsedURLData.protocol == null) {
            if (this.protocol != null) {
                return false;
            }
        } else {
            if (this.protocol == null) {
                return false;
            }
            if (!parsedURLData.protocol.equals(this.protocol)) {
                return false;
            }
        }
        if (parsedURLData.host == null) {
            if (this.host != null) {
                return false;
            }
        } else {
            if (this.host == null) {
                return false;
            }
            if (!parsedURLData.host.equals(this.host)) {
                return false;
            }
        }
        if (parsedURLData.ref == null) {
            if (this.ref != null) {
                return false;
            }
        } else {
            if (this.ref == null) {
                return false;
            }
            if (!parsedURLData.ref.equals(this.ref)) {
                return false;
            }
        }
        if (parsedURLData.path == null) {
            if (this.path != null) {
                return false;
            }
        } else {
            if (this.path == null) {
                return false;
            }
            if (!parsedURLData.path.equals(this.path)) {
                return false;
            }
        }
        return true;
    }

    public String getContentType(String string2) {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (!this.hasBeenOpened) {
            try {
                this.openStreamInternal(string2, null, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.contentType;
    }

    public String getContentTypeMediaType(String string2) {
        if (this.contentTypeMediaType != null) {
            return this.contentTypeMediaType;
        }
        this.extractContentTypeParts(string2);
        return this.contentTypeMediaType;
    }

    public String getContentTypeCharset(String string2) {
        if (this.contentTypeMediaType != null) {
            return this.contentTypeCharset;
        }
        this.extractContentTypeParts(string2);
        return this.contentTypeCharset;
    }

    public boolean hasContentTypeParameter(String string2, String string3) {
        int n2;
        this.getContentType(string2);
        if (this.contentType == null) {
            return false;
        }
        int n3 = this.contentType.length();
        int n4 = string3.length();
        block3: for (n2 = 0; n2 < n3; ++n2) {
            switch (this.contentType.charAt(n2)) {
                case ' ': 
                case ';': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        this.contentTypeMediaType = n2 == n3 ? this.contentType : this.contentType.substring(0, n2);
        block4: while (true) {
            if (n2 < n3 && this.contentType.charAt(n2) != ';') {
                ++n2;
                continue;
            }
            if (n2 == n3) {
                return false;
            }
            ++n2;
            while (n2 < n3 && this.contentType.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n3 - n4 - 1) {
                return false;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                if (this.contentType.charAt(n2++) != string3.charAt(i2)) continue block4;
            }
            if (this.contentType.charAt(n2) == '=') break;
        }
        return true;
    }

    protected void extractContentTypeParts(String string2) {
        int n2;
        this.getContentType(string2);
        if (this.contentType == null) {
            return;
        }
        int n3 = this.contentType.length();
        block6: for (n2 = 0; n2 < n3; ++n2) {
            switch (this.contentType.charAt(n2)) {
                case ' ': 
                case ';': {
                    break block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        this.contentTypeMediaType = n2 == n3 ? this.contentType : this.contentType.substring(0, n2);
        while (true) {
            if (n2 < n3 && this.contentType.charAt(n2) != ';') {
                ++n2;
                continue;
            }
            if (n2 == n3) {
                return;
            }
            ++n2;
            while (n2 < n3 && this.contentType.charAt(n2) == ' ') {
                ++n2;
            }
            if (n2 >= n3 - 8) {
                return;
            }
            if (this.contentType.charAt(n2++) == 'c' && this.contentType.charAt(n2++) == 'h' && this.contentType.charAt(n2++) == 'a' && this.contentType.charAt(n2++) == 'r' && this.contentType.charAt(n2++) == 's' && this.contentType.charAt(n2++) == 'e' && this.contentType.charAt(n2++) == 't' && this.contentType.charAt(n2++) == '=') break;
        }
        int n4 = n2;
        block9: while (n2 < n3) {
            switch (this.contentType.charAt(n2)) {
                case ' ': 
                case ';': {
                    break block9;
                }
                default: {
                    ++n2;
                    continue block9;
                }
            }
        }
        this.contentTypeCharset = this.contentType.substring(n4, n2);
    }

    public String getContentEncoding(String string2) {
        if (this.contentEncoding != null) {
            return this.contentEncoding;
        }
        if (!this.hasBeenOpened) {
            try {
                this.openStreamInternal(string2, null, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.contentEncoding;
    }

    public boolean complete() {
        try {
            this.buildURL();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public InputStream openStream(String string2, Iterator iterator) throws IOException {
        InputStream inputStream = this.openStreamInternal(string2, iterator, acceptedEncodings.iterator());
        if (inputStream == null) {
            return null;
        }
        this.stream = null;
        return ParsedURLData.checkGZIP(inputStream);
    }

    public InputStream openStreamRaw(String string2, Iterator iterator) throws IOException {
        InputStream inputStream = this.openStreamInternal(string2, iterator, null);
        this.stream = null;
        return inputStream;
    }

    protected InputStream openStreamInternal(String string2, Iterator iterator, Iterator iterator2) throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        this.hasBeenOpened = true;
        URL uRL = null;
        try {
            uRL = this.buildURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Unable to make sense of URL for connection");
        }
        if (uRL == null) {
            return null;
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            String string3;
            if (string2 != null) {
                uRLConnection.setRequestProperty(HTTP_USER_AGENT_HEADER, string2);
            }
            if (iterator != null) {
                string3 = "";
                while (iterator.hasNext()) {
                    string3 = string3 + iterator.next();
                    if (!iterator.hasNext()) continue;
                    string3 = string3 + ",";
                }
                uRLConnection.setRequestProperty(HTTP_ACCEPT_HEADER, string3);
            }
            if (iterator2 != null) {
                string3 = "";
                while (iterator2.hasNext()) {
                    string3 = string3 + iterator2.next();
                    if (!iterator2.hasNext()) continue;
                    string3 = string3 + ",";
                }
                uRLConnection.setRequestProperty(HTTP_ACCEPT_ENCODING_HEADER, string3);
            }
            this.contentType = uRLConnection.getContentType();
            this.contentEncoding = uRLConnection.getContentEncoding();
            this.postConnectionURL = uRLConnection.getURL();
        }
        try {
            this.stream = uRLConnection.getInputStream();
            return this.stream;
        }
        catch (IOException iOException) {
            if (uRLConnection instanceof HttpURLConnection) {
                this.stream = ((HttpURLConnection)uRLConnection).getErrorStream();
                return this.stream;
            }
            throw iOException;
        }
    }

    public String getPortStr() {
        String string2 = "";
        if (this.protocol != null) {
            string2 = string2 + this.protocol + ":";
        }
        if (this.host != null || this.port != -1) {
            string2 = string2 + "//";
            if (this.host != null) {
                string2 = string2 + this.host;
            }
            if (this.port != -1) {
                string2 = string2 + ":" + this.port;
            }
        }
        return string2;
    }

    protected boolean sameFile(ParsedURLData parsedURLData) {
        if (this == parsedURLData) {
            return true;
        }
        return this.port == parsedURLData.port && (this.path == parsedURLData.path || this.path != null && this.path.equals(parsedURLData.path)) && (this.host == parsedURLData.host || this.host != null && this.host.equals(parsedURLData.host)) && (this.protocol == parsedURLData.protocol || this.protocol != null && this.protocol.equals(parsedURLData.protocol));
    }

    public String toString() {
        String string2 = this.getPortStr();
        if (this.path != null) {
            string2 = string2 + this.path;
        }
        if (this.ref != null) {
            string2 = string2 + "#" + this.ref;
        }
        return string2;
    }

    public String getPostConnectionURL() {
        if (this.postConnectionURL != null) {
            if (this.ref != null) {
                return this.postConnectionURL.toString() + '#' + this.ref;
            }
            return this.postConnectionURL.toString();
        }
        return this.toString();
    }

    static {
        acceptedEncodings.add("gzip");
        GZIP_MAGIC = new byte[]{31, -117};
    }
}

